///////////////////////////////////////////////////////////////////////////
// CFindText 饹Υ󥿥ե
//
// ƥȸѤΥåɥ֥
////////////////////////////////////////////////////////////////////////////

#if !defined( FINDTEXT_H_INCLUDED_ )
#define FINDTEXT_H_INCLUDED_

#include "regex/SRegex.h"
#include "LineData.h"
#include "TextMatchLib.h"
#include "TaEditProcessingDlg.h"
#include "ConfigInfo.h"
#include "ErrorBool.h"

#include "TaEditDoc.h"

// ʸʸ̤ʤѴؿ֥
template < typename T_Char >
class IgnoreCaseCompare
{
public:
	IgnoreCaseCompare(){};
	bool operator()( const T_Char &r1, const T_Char &r2 ) const 
	{
		assert( sizeof( T_Char ) == sizeof( wchar_t ) );
		int i = wsncasecmp( &r1, &r2, 1 );
		return i == 0;
	};
};

class CFindText : public CProcesingObj
{
protected:
	typedef N_SRegex::SRegex< wchar_t, const wchar_t*, tagPseudPtr > T_FindSensitiveObj;
	typedef N_SRegex::SRegex< wchar_t, const wchar_t*, tagPseudPtr, IgnoreCaseCompare< wchar_t > > T_FindIgnoreObj;

public:
	CFindText();
	CFindText( const CFindText &r );	// ʣʶػߡ
	~CFindText();

	// Τξꤹ
	bool SetFindInfo(
		const CTaEditDoc *pArgDoc,
		T_CurPos SPos, 
		const wstring &rArgPtn,
		VClsPtr< CConfigInfo > pArgConf,
		bool argIgnoreCase );

	// 򳫻Ϥ
	virtual bool start();

	// ѥå
	virtual void run();

	// λǽݤ
	virtual bool EnableExit() const;

	// 
	virtual void Interrupt();

	// åɤνλ碌
	virtual void WaitThreadTerminate();

	// ֤åɤνλԤ碌
	virtual bool WaitThreadTerminateForTime( int ms );

	// Ĥäݤ
	bool IsMatched() const;

	// ̤ϰϤ
	const T_SelRange& GetMatchRange() const;

	// 顼
	CErrorBool GetErrorInfo() const;

	// ʶػߡ
	const CFindText& operator =( const CFindText &r );

protected:
	// ѥ֥Ȥι
	template< typename T >
	bool CreateFindObj( T *pFindObj, const wstring &rPattern, VClsPtr< CConfigInfo > pConf ) const;

	// SRegexΥ顼ͤбå
	const wstring& GetRegexErrString( N_SRegex::SREGEX_ERR err, VClsPtr< CConfigInfo > pConf ) const;

	// 
	template< typename T >
	bool FindNext( T *pFindObj, T_SelRange *pRange ) const;

	// ɥ
	const CTaEditDoc *pDoc;

	// ϰ
	T_CurPos SPos;

	volatile bool EnableExitFlg;	// λǽݤ

	T_SelRange m_ResultRange;	// 
	bool IsMatchedFlg;	// Ĥäݤ
	CErrorBool ErrorInfo;	// 顼̵ͭ
	bool IgnoreCase;	// ʸʸƱ뤹뤫ݤ

	// ѥ֥
	T_FindSensitiveObj m_SensitiveObj;
	T_FindIgnoreObj m_IgnoreObj;

};

#endif // FINDTEXT_H_INCLUDED_

