////////////////////////////////////////////////////////////////////////////
// CScrollMgr 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( SCROLLMGR_H_INCLUDED_ )
#define SCROLLMGR_H_INCLUDED_

// СͤѲΥ٥Ȥ륯饹Υ󥿥ե
class CScrEventHandler
{
	friend class CScrollMgr;
protected:
	virtual void OnScrValueChange( const CScrollMgr *argpMgr, int value, bool NeedRedraw ) = 0;
};

class CScrollMgr
{
public:
	CScrollMgr();
	CScrollMgr( const CScrollMgr &r );	// ʣʶػߡ
	~CScrollMgr();

	void SetPadding( unsigned int argMin, unsigned int argMax );

	// СΥ٥ȥϥɥ
	void SetEventHandler( CScrEventHandler *pArg );

	void SetMin( int argMin );
	void SetMax( int argMax );
	bool SetPageSize( int argPageSize, int *pRequireValue );
	void SetMinChickSize( int argMinChick );
	void SetValue( int argValue );

	void SetToMin();

	int GetValue() const;

	bool IsManaged() const;

	// ʶػߡ
	const CScrollMgr& operator =( const CScrollMgr &r );

protected:
	void OnCreate( Widget argWgt, XtPointer user_data );
	void OnDecrement( Widget argWgt, XtPointer user_data );
	void OnIncrement( Widget argWgt, XtPointer user_data );
	void OnPageDown( Widget argWgt, XtPointer user_data );
	void OnPageUp( Widget argWgt, XtPointer user_data );
	void OnDrag( Widget argWgt, XtPointer user_data );
	void ToBottom( Widget argWgt, XtPointer user_data );
	void ToTop( Widget argWgt, XtPointer user_data );
	void OnChangeValue( Widget argWgt, XtPointer user_data );

	void SetResource() const;

	Widget m_Scr;

	int m_Min;	// 
	int m_Max;	// Ǿ
	int m_PageSize;	// ڡ
	int m_MinChickSize;	// Ǿ
	unsigned int MinPadding;	// ǾͤΥѥǥ
	unsigned int MaxPadding;	// ͤΥѥǥ

	CScrEventHandler *pEventHandler;
};

#endif // SCROLLMGR_H_INCLUDED_

