////////////////////////////////////////////////////////////////////////////
// CTaEditDoc 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( TAEDITDOC_H_INCLUDED_ )
#define TAEDITDOC_H_INCLUDED_

#include "LineData.h"
#include "UndoListMgr.h"
#include "EditCommand.h"
#include "lang/TxtColorMgr.h"
#include "EncodeInfo.h"


using namespace NLangExt;

class CTaEditDoc
{
public:
	CTaEditDoc();
	CTaEditDoc( const CTaEditDoc &r );	// ʣʶػߡ
	~CTaEditDoc();

	// եɤ߹
	CErrorBool OnOpenDocument( const string &argFileName, bool *pIsChanged, enumLANGTYPE LangType, const CEncodeInfo &rEncode );

	// ե¸
	CErrorBool OnSaveDocument( const string &argFileName, bool *pColChanged, const CEncodeInfo &rEncode );

	// ե̾λ
	const string& GetFileName() const;

	// 
	void Initialize();

	// ʸ
	CErrorBool Insert( const wstring& rStr, const T_CurPos &rCurPos, const T_SelRange &rSelRange, T_CurPos *pResultCurPos );

	// ü쵭
	CErrorBool InsertSpecialCode( KeySym argKeySym, const T_CurPos &rCurPos, const T_SelRange &rSelRange, T_CurPos *pResultCurPos );

	// ʣԤؤTAB
	CErrorBool MultiLineTabInsert( const T_SelRange &rSelRange, T_CurPos *pResultCurPos, T_SelRange *pResultSelRange );

	// ʣԤTABκ
	CErrorBool MultiLineTabDelete( const T_SelRange &rSelRange, T_CurPos *pResultCurPos, T_SelRange *pResultSelRange );

	// Խνλ
	void EndEdit();

	// ĥ
	CErrorBool SetExtendInfo( size_t Line, int idx, bool flg );

	const T_LineData& RefData() const;

	// ե饰
	bool GetIsModify() const;

	// Undoꥹȴ֥Ȥ򻲾
	const CUndoListMgr& RefUndoListMgr() const;

	// ɥ
	void Undo( T_SelRange *pAfterUndoSelRange, T_CurPos *pAfterUndoCurPos );

	// ɥ
	void Redo( T_SelRange *pAfterRedoSelRange, T_CurPos *pAfterRedoCurPos );

	// ꤷϰϤʸ
	void GetRangeStr( const T_SelRange &range, wstring *pStr );

	// ¸󥪥֥Ȥ
	const NLangExt::CTxtColorMgr* GetTxtColorMgr() const;

	// 󥪥֥Ȥ
	CErrorBool SetTxtColorMgr( enumLANGTYPE type, bool *pIsUpdate = NULL );

	// ¾ŪԽüʣ
	CTaEditDoc* CopyForExclusiveEditing();

	// ¾ŪԽη̤ȿǤ
	void ReflectionExclusiveEditing( CTaEditDoc *pDoc );

	// 󥳡ɤξ
	const CEncodeInfo& GetEncodeInfo() const;

	// ʶػߡ
	const CTaEditDoc& operator =( const CTaEditDoc &r );

protected:

	// ꤷ֤¸ߤ롢ꤷʸ
	CErrorBool DelSpecifiedStr( T_CurPos pos, const wstring &rStr );

	// ꤷ֤˻ꤷʸʲԥɤޤˤɲä
	void InsertSpecifiedStr( T_CurPos pos, const wstring &rStr );

	// ꤷϰϤԽޥɥ֥Ȥۤ
	CErrorBool Delete_WithCreateEC( T_SelRange DelRange, T_CurPos BeforeCurPos );

	// 
	void AddCR( T_CurPos pos );

	// ưǥȤˤĴ
	int ExecAutoIndent( int line );

	// ʸκ
	CErrorBool Delete( const T_SelRange &rRange );

	// Խޥɥ֥Ȥ
	VClsPtr< CEditCommand > CreateEditCommandObj( enumTEC_TYPE argType );

	// եξ֤ǧ
	CErrorBool CheckFileStatus( const string &rFileName, bool Exist );

	// ¸󥪥֥Ȥ򹹿
	CErrorBool UpdateTextColorMgr( bool *pIsUpdate );

	// ե饰ꤹ
	void SetModifyFlg( bool flg );

protected:
	// ʸݻ
	T_LineData vecLine;

	// ե̾
	string FileName;

	// Ǹ¸Ƥѹ줿ݤ
	bool IsModify;

	// Undoꥹȴ֥
	CUndoListMgr UndoListMgr;

	// 󥳡
	CEncodeInfo EncodeInfo;

	// ¸󥪥֥
	NLangExt::CTxtColorMgr *pTxtColorMgr;

};

#endif // TAEDITDOC_H_INCLUDED_

