/////////////////////////////////////////////////////////////////////////
// CTaEditDraw 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"

#include "TaEditDraw.h"
#include "TaEditShell.h"
#include "TaEditJPEXT.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditDraw::CTaEditDraw() :
	CDraw(),
	CScrEventHandler(),
	BackgndPixmap( NULL ),
	numTopLine( 0 ),
	pCursorInfo( NULL ),
	pMouseInfo( NULL ),
	pGCStorage( NULL ),
	pGCMgr( NULL ),
	pXimMgr( NULL ),
	pTextEditor( NULL ),
	MaxLengthPix( 0 ),
	DrawedLineCnt_hoz( 0 ),
	vDrewLD(),
	TextHeight( 0 ),
	TextAscent( 0 ),
	TabWidth( 0 ),
	TabWidth_CM( TWCM_FIX ),
	pTabString( NULL ),
	pVScrollMgr( NULL ),
	pHScrollMgr( NULL ),
	IsFirstExposed( false ),
	ForcusState( false ),
	LeftColumnWidth( 0 )
{

}

CTaEditDraw::~CTaEditDraw()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// staticʥ٥ȥϥɥ
////////////////////////////////////////////////////////////////////////////

// եξ֤ѲФ륤٥ȥϥɥ
void CTaEditDraw::OnForcusEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnForcus( w, event, continue_to_dispatch );
}

// ܡϤФ륤٥ȥϥɥ
void CTaEditDraw::OnKeybordEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnKey( w, event, continue_to_dispatch );
}

// ޥФ륤٥ȥϥɥ
void CTaEditDraw::OnMouseEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnMouse( w, event, continue_to_dispatch );
}

// ޥݥ󥿤ΰưФ륤٥ȥϥɥ
void CTaEditDraw::OnPointerMotionEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnPointerMotion( w, event, continue_to_dispatch );
}

// ɥåפ줿ȤΥХå
void CTaEditDraw::OnDropCallback( Widget w, XtPointer client_data, XtPointer callback_data )
{
	CTaEditDraw *p = reinterpret_cast< CTaEditDraw* >( client_data );
	p->OnDrop( reinterpret_cast< DtDndTransferCallbackStruct* >( callback_data ) );
}

// ٥ȥϥɥ
////////////////////////////////////////////////////////////////////////////

// 
void CTaEditDraw::OnCreate( Widget argWgt, XtPointer user_data )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int i;

	// եȥåȤ
	const string &rFontName = pConf->RefFontName();
	fontSet = JPEXT_CreateFontSet( XtDisplay( m_Draw ), rFontName.c_str() );
	FontHeight = JPEXT_GetFontHeight( fontSet );
	TextHeight = FontHeight + pConf->GetLineGapWidth();
	if ( TextHeight <= 0 ) TextHeight = 1;
	TabWidth = JPEXT_GetMinWidth( fontSet ) * pConf->RefTabWidth();
	TabWidth_CM = pConf->GetTabWidthCalculationMethod();
	pTabString = &( pConf->RefTabString() );
	TextAscent = JPEXT_GetFont_ascent( fontSet ) + pConf->GetLineGapWidth();
	if ( TextAscent <= 0 ) TextAscent = 1;

	// եޥѤΥ٥ȥϥɥ
	XtAddEventHandler( m_Draw, FocusChangeMask, False, CTaEditDraw::OnForcusEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, KeyPressMask, False, CTaEditDraw::OnKeybordEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, ButtonPressMask, False, CTaEditDraw::OnMouseEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, ButtonReleaseMask, False, CTaEditDraw::OnMouseEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, Button1MotionMask, False, CTaEditDraw::OnMouseEvent, (XtPointer)this );
	XtAddEventHandler( m_Draw, PointerMotionMask, False, CTaEditDraw::OnPointerMotionEvent, (XtPointer)this );

	// ɥåץȤȤϿ
	Arg al[10];
	int ac = 0;
        XtCallbackRec cblist[] = { { CTaEditDraw::OnDropCallback, (XtPointer)this }, { NULL, NULL } };
	XtSetArg( al[ac], const_cast< char* >( DtNregisterChildren ), False ); ac++;
	DtDndDropRegister( m_Draw, DtDND_FILENAME_TRANSFER, XmDROP_COPY, cblist, al, ac );

	// ¦˶ΰ򻻽
	LeftColumnWidth = pConf->GetExInfoColumnWidth() * pConf->GetExInfoColumnCount();
	LeftColumnWidth += pConf->GetLineNumberColumnWidth();
}

// ˲
void CTaEditDraw::OnDestroy( Widget argWgt, XtPointer user_data )
{
	OnExit();	// ϸƤФ뤳Ȥʤ餷
}

// ץλ
void CTaEditDraw::OnExit()
{
	// եȥåȤ˴
	XFreeFontSet( XtDisplay( m_Draw ), fontSet );

	if ( BackgndPixmap )
		XFreePixmap( XtDisplay( m_Draw ), BackgndPixmap );
	BackgndPixmap = NULL;

	pGCStorage = NULL;
	pGCMgr = NULL;
	pCursorInfo = NULL;
	pXimMgr = NULL;
	pMouseInfo = NULL;
	pTextEditor = NULL;
	pHScrollMgr = NULL;
	pVScrollMgr = NULL;
	vDrewLD.clear();

	// ɥåץȤȤƤϿ
	DtDndDropUnregister( m_Draw );
}

// ϥХå
void CTaEditDraw::OnInput( Widget argWgt, XtPointer user_data )
{
}

// ϥ٥
void CTaEditDraw::OnKey( Widget w, XEvent *event, Boolean *continue_to_dispatch )
{
	wstring wstr;
	int i;
	KeySym keysym;
	ScrollInfoPacket scrPacket;
	bool OnShift;
	bool OnCtrl;
	T_CurPos NextPos;
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	CErrorBool r;

	if ( pXimMgr.IsNull() ) return ;

	// Ϥ줿ʸ
	pXimMgr->GetInputText( reinterpret_cast< XKeyPressedEvent* >( event ), &wstr, &keysym, &OnShift, &OnCtrl );

	if ( wstr.length() <= 0 ) {

		// KeySymͤѤϤ줿Ƚꤹ
		switch ( keysym ) {
		case XK_Left:
			pCursorInfo->Left( &scrPacket, OnShift, OnCtrl );
			break;
		case XK_Up:
			pCursorInfo->Up( &scrPacket, OnShift );
			break;
		case XK_Right:
			pCursorInfo->Right( &scrPacket, OnShift, OnCtrl );
			break;
		case XK_Down:
			pCursorInfo->Down( &scrPacket, OnShift );
			break;
		case XK_Page_Up:
			pCursorInfo->PageUp( &scrPacket, OnShift );
			break;
		case XK_Page_Down:
			pCursorInfo->PageDown( &scrPacket, OnShift );
			break;
		case XK_End:
			pCursorInfo->End( &scrPacket, OnShift, OnCtrl );
			break;
		case XK_Home:
			pCursorInfo->Home( &scrPacket, OnShift, OnCtrl );
			break;
		case XK_L4:	// (Undo)˥塼UndoƤӽФ
			m_TaEditShell->OnEditUndo( NULL, NULL );
			break;
		case XK_L2:	// (Again)˥塼RedoƤӽФ
			m_TaEditShell->OnEditRedo( NULL, NULL );
			break;
		case XK_L6:	// (Copy)˥塼CopyƤӽФ
			m_TaEditShell->OnEditCopy( NULL, NULL );
			break;
		case XK_L8:	// (Paste)˥塼PasteƤӽФ
			m_TaEditShell->OnEditPaste( NULL, NULL );
			break;
		case XK_L10:	// (Cut)˥塼CutƤӽФ
			m_TaEditShell->OnEditCut( NULL, NULL );
			break;
		// case XK_L9:	// (Find)
		}

		// ɬפ˱ơ̤򥹥뤵
		if ( scrPacket.NeedXScroll ) ScrollH( scrPacket.pixX, false );
		if ( scrPacket.NeedYScroll ) ScrollV( scrPacket.lineY, false );

		// 
		// ϰϤѲ
		if ( scrPacket.IsSelCange && !scrPacket.NeedXScroll && !scrPacket.NeedYScroll )
			AfterSelRangeRedraw( scrPacket.ChangeSLine, scrPacket.ChangeELine );
		// 뤵줿
		if ( scrPacket.NeedXScroll || scrPacket.NeedYScroll )
			OnRedraw( TED_REUSE_CHAR_INFO );
		return ;
	}

	// CtrlƤϡ桼ΥץߥȽǤơʤˤ⤷ʤ
	if ( OnCtrl ) return ;

	// Խ٤֤
	const T_CurPos &rCurPos = pCursorInfo->GetCurPos();
	const T_SelRange &rSelRange = pCursorInfo->GetSelRange();

	// ʣ򤵤줿֤TAB줿
	if ( rSelRange.GetSPos().GetLine() != rSelRange.GetEPos().GetLine() && wstr == L"\t" ) {
		T_SelRange NextSelRange;
		// 򤵤ƤΤФTABɲá롣
		if ( !OnShift )
			r = pDoc->MultiLineTabInsert( rSelRange, &NextPos, &NextSelRange );
		else
			r = pDoc->MultiLineTabDelete( rSelRange, &NextPos, &NextSelRange );
		pDoc->EndEdit();
		m_TaEditShell->ProcErrorMsg( r );

		// ֤Ⱥ
		// ľ˺褹뤿ᡢκϹԤʤ
		pCursorInfo->SetCurPos( NextPos, &scrPacket, NextSelRange, false );
		AfterEditRedraw( scrPacket );

		// ˥塼ξ֤򹹿
		m_TaEditShell->UpdateUndoRedoMenuState();

		return ;
	}

	// ֥줿Ϥʸꤹ
	if ( wstr == L"\t" && NULL != pTabString )
		wstr = (*pTabString);

	// üʥξ
	if ( wstr.length() == 1 &&
		( XK_BackSpace == keysym || XK_Return == keysym || XK_Delete == keysym || XK_KP_Enter == keysym ) )
		r = pDoc->InsertSpecialCode( keysym, rCurPos, rSelRange, &NextPos );
	else
		// ̾ʸؼ
		r = pDoc->Insert( wstr, rSelRange.GetSPos(), pCursorInfo->GetSelRange(), &NextPos );
	pDoc->EndEdit();
	m_TaEditShell->ProcErrorMsg( r );

	// Ϥ줿ʬư
	pCursorInfo->SetCurPos( NextPos, &scrPacket, false, true );

	// 
	AfterEditRedraw( scrPacket );

	// ˥塼ξ֤򹹿
	m_TaEditShell->UpdateUndoRedoMenuState();
}

// ɽ
void CTaEditDraw::OnExpose( Widget argWgt, XtPointer user_data )
{
	// ǽΰܤɽ򥤥٥ȤȤƽ
	if ( !IsFirstExposed ){
		m_TaEditShell->OnFirstExpose();
		OnFirstExpose();
	}

	ClearBackScreen();
	OnRedraw( TED_REUSE_CHAR_INFO );	// 
}

// ѹ
void CTaEditDraw::OnResize( Widget argWgt, XtPointer user_data )
{
	int x, y;
	int wrv;
	int ViewLineCnt;

	// ޤɽƤ⤤ʤΤʤ顢ɬפϤʤ
	if ( !IsFirstExposed ) return ;

	GetSize( &x, &y );
	ViewLineCnt = GetViewLineCnt();	// ̤ǽʹԿ

	// СΥڡ
	if ( !pVScrollMgr->SetPageSize( ViewLineCnt, &wrv ) ) {
		ScrollV( wrv, false );
		pVScrollMgr->SetPageSize( ViewLineCnt, NULL );
	}
	if ( !pHScrollMgr->SetPageSize( x, &wrv ) ) {
		ScrollH( wrv, false );
		pHScrollMgr->SetPageSize( x, NULL );
	}

	ClearBackScreen();
	OnRedraw( TED_REUSE_CHAR_INFO );	// 
	if ( !pCursorInfo.IsNull() )
		pCursorInfo->RefleshXIMPos();	// XIMΰ֤
}

// եν
void CTaEditDraw::OnForcus( Widget w, XEvent *event, Boolean *continue_to_dispatch )
{
	XFocusChangeEvent *pf = (XFocusChangeEvent*)event;

	if ( pXimMgr.IsNull() ) return ;

	// XIM֥ȤˡեѲΤ
	switch ( pf->type ){
	case FocusIn:
		pXimMgr->OnForcus();
		ForcusState = true;
		break;
	case FocusOut:
		pXimMgr->ExitForcus();
		ForcusState = false;
		break;
	}
}

// ޥ
void CTaEditDraw::OnMouse( Widget w, XEvent *event, Boolean *continue_to_dispatch )
{
	enumBTN2FUNC Btn2Func = m_TaEditShell->GetConfigInfo()->GetBtn2Func();
	TA_EVENT e;
	int x;
	int y;
	XButtonEvent *pBtnE = NULL;
	XMotionEvent *pMtnE = NULL;
	bool OnShift;
	bool OnCtrl;
	Display *pDisplay = XtDisplay( w );
	Window window = XtWindow( w );
	ScrollInfoPacket scrPacket;

	switch ( event->type ) {
	case ButtonPress:
		pBtnE = &( event->xbutton );

		// ˥塼Сå줿Ȥˡ뤬äƤޤؤк
		XSetInputFocus( pDisplay, window, RevertToParent, CurrentTime );

		//  ڤܥʳΤΤФ
		switch ( pBtnE->button ) {
		case 3:	// ܥ
			OnMouse3Push( pBtnE );
			return ;
		case 4:	// 她
			OnMouseScrollUp( pBtnE );
			return ;
		case 5:	// 
			OnMouseScrollDown( pBtnE );
			return ;
		default:
			// 15ʳΥܥ󤬲줿̵뤹
			if ( pBtnE->button > 5 ) return ;
		}

		e = TAE_BUTTON1_DOWN;
		x = pBtnE->x - LeftColumnWidth;
		y = pBtnE->y;
		if ( 2 == pBtnE->button && B2F_LEFT != Btn2Func ) {
			// ܥФ
			if ( Btn2Func == B2F_LEFT_CTRL ) {
				OnCtrl = true;
				OnShift = false;
			}
			else {
				OnCtrl = false;
				OnShift = true;
			}
		}
		else {
			OnShift = ( pBtnE->state & ShiftMask ) ? true : false;
			OnCtrl = ( pBtnE->state & ControlMask ) ? true : false;
		}

		// ޥΥ֤
		//XGrabPointer( pDisplay, window, True, ButtonReleaseMask | PointerMotionMask, GrabModeAsync, GrabModeSync, None, None, CurrentTime );
		break;

	case ButtonRelease:
		pBtnE = &( event->xbutton );

		// ڤܥʳΤΤǤ̵뤹
		if ( pBtnE->button > 2 ) return ;

		e = TAE_BUTTON1_UP;
		x = pBtnE->x - LeftColumnWidth;
		y = pBtnE->y;
		OnShift = ( pBtnE->state & ShiftMask ) ? true : false;
		OnCtrl = ( pBtnE->state & ControlMask ) ? true : false;

		// ޥΥ֤
		//XUngrabPointer( pDisplay, CurrentTime );
		break;

	case MotionNotify:
		pMtnE = &( event->xmotion );
		e = TAE_MOTION;
		x = pMtnE->x - LeftColumnWidth;
		y = pMtnE->y;
		OnShift = ( pMtnE->state & ShiftMask ) ? true : false;
		OnCtrl = ( pMtnE->state & ControlMask ) ? true : false;
		break;
	default:
		return ;
	}

	pMouseInfo->OnMouse( e, x, y, &scrPacket, OnShift, OnCtrl );
	if ( scrPacket.IsSelCange && !scrPacket.NeedXScroll && !scrPacket.NeedYScroll )
		OnRedraw( TED_REUSE_CHAR_INFO, scrPacket.ChangeSLine, scrPacket.ChangeELine );

	if ( scrPacket.NeedXScroll ) ScrollH( scrPacket.pixX, false );
	if ( scrPacket.NeedYScroll ) ScrollV( scrPacket.lineY, false );
	if ( scrPacket.NeedXScroll || scrPacket.NeedYScroll )
		OnRedraw( TED_REUSE_CHAR_INFO );
}

// ޥݥ󥿤ΰư
void CTaEditDraw::OnPointerMotion( Widget w, XEvent *event, Boolean *continue_to_dispatch )
{
	XMotionEvent *pMtnE = &( event->xmotion );
	pMouseInfo->OnPointerMotion( pMtnE->x, pMtnE->y );
}

// ޥܥβ
void CTaEditDraw::OnMouse2Push( XButtonPressedEvent* event )
{

}

// ޥαܥβ
void CTaEditDraw::OnMouse3Push( XButtonPressedEvent* event )
{
	// ݥåץåץ˥塼ɽ
	m_menuPopup->Popup( event );
}

// ޥΥܥˤؤΥ
void CTaEditDraw::OnMouseScrollUp( XButtonPressedEvent* event )
{
	int cy = GetTopLineNum();
	int ScrollMouseSpeed = m_TaEditShell->GetConfigInfo()->GetScrollMouseSpeed();
	cy -= ScrollMouseSpeed;
	if ( cy < 0 ) cy = 0;
	ScrollV( cy, true );
}

// ޥΥܥˤ벼ؤΥ
void CTaEditDraw::OnMouseScrollDown( XButtonPressedEvent* event )
{
	int cy = GetTopLineNum();
	int CurLineCnt = m_TaEditShell->GetDocument()->RefData().size();
	int ScrollMouseSpeed = m_TaEditShell->GetConfigInfo()->GetScrollMouseSpeed();
	int VLC = GetViewLineCnt();

	if ( CurLineCnt <= VLC )
		cy = 0;
	else {
			cy += ScrollMouseSpeed;
			if ( cy + VLC >= CurLineCnt ) cy = CurLineCnt - VLC;
	}
	ScrollV( cy, true );
}

// ޥ٥
void CTaEditDraw::OnTimer()
{
	if ( !pCursorInfo.IsNull() )
		pCursorInfo->OnTimer();
}

// ɥåץ٥
void CTaEditDraw::OnDrop( DtDndTransferCallbackStruct *pCallbackData )
{
	DtDndProtocol prot = pCallbackData->dropData->protocol;
	if ( DtDND_TEXT_TRANSFER == prot || DtDND_BUFFER_TRANSFER == prot )
		return ;
	if ( pCallbackData->dropData->numItems <= 0 )
		return ;

	// ɥåפ줿ե򳫤
	m_TaEditShell->OpenDnDFiles(
		pCallbackData->dropData->numItems,
		pCallbackData->dropData->data.files
	);
}

// ¾Ūʥ٥
////////////////////////////////////////////////////////////////////////////

// ɥȤɤ߹ޤ줿
void CTaEditDraw::OnReadDocument()
{
	int ViewLineCnt;
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	numTopLine = 0;
	MaxLengthPix = 0;

	pCursorInfo = NULL;
	pMouseInfo = NULL;
	pTextEditor = NULL;
	pGCMgr = NULL;
	pCursorInfo = new CCursor( this, pDoc, pXimMgr );
	if ( pCursorInfo.IsNull() ) goto ERR_EXIT;
	pTextEditor = new CTextEdit( this, pCursorInfo, pDoc );
	if ( pTextEditor.IsNull() ) goto ERR_EXIT;
	pMouseInfo = new CMouse( pCursorInfo, this, pTextEditor );
	if ( pMouseInfo.IsNull() ) goto ERR_EXIT;
	pGCMgr = new CGCMgr();
	if ( pGCMgr.IsNull() ) goto ERR_EXIT;
	if ( !pGCMgr->CreateGC( m_Draw, pConf, pDoc->GetTxtColorMgr(), pGCStorage ) )
		return ;
	ViewLineCnt = GetViewLineCnt();

	// 빽ۤؼ
	pMouseInfo->CreateCursor( m_Draw );

	// Сν
	pVScrollMgr->SetMin( 0 );
	pVScrollMgr->SetToMin();
	pVScrollMgr->SetMax( pDoc->RefData().size() );
	pVScrollMgr->SetMinChickSize( 1 );
	pVScrollMgr->SetPageSize( ViewLineCnt, NULL );

	pHScrollMgr->SetMin( 0 );
	pHScrollMgr->SetToMin();
	pHScrollMgr->SetMax( 0 );
	pHScrollMgr->SetMinChickSize( GetCharWidth( L' ', 0 ) );
	pHScrollMgr->SetPageSize( GetViewWidth(), NULL );

	// ƥ˥塼ν֤
	m_TaEditShell->SetEnableCopyPasteMenu( false );
	m_TaEditShell->UpdateUndoRedoMenuState();

	OnRedraw( TED_REUSE_CHAR_INFO );

	// XIMΰ֤
	pCursorInfo->RefleshXIMPos();

	// ȥ
	m_TaEditShell->ResetTitle( TITLESTR_ALL );

	return ;

ERR_EXIT:
	m_TaEditShell->ShowErrorMsgBox( pConf->RefOutOfMemoryErrorMsg() );
	pCursorInfo = NULL;	// 
	pMouseInfo = NULL;
	pTextEditor = NULL;
	pGCMgr = NULL;
}

// 
void CTaEditDraw::DrawCursor( int x, int y ) const
{
	Drawable drawable = XtWindow( m_Draw );
	DrawCursor( x, y, drawable );
}
void CTaEditDraw::DrawCursor( int x, int y, Drawable drawable ) const
{
	Display *pDisplay = XtDisplay( m_Draw );
	GC CursorGC;
	int y1;	// ξü
	int y2;	// βü

	if ( NULL == pDisplay || NULL == drawable || pGCMgr.IsNull() ) return ;

	// ֤
	x += LeftColumnWidth;	// Ϳ줿xˤϾɽΰäƤʤ
	y1 = y + TextHeight - FontHeight;	// Ϳ줿yϡԤξüǤ
	y2 = y + TextHeight - 1;

	CursorGC = pGCMgr->GetCursorGC();
	XDrawLine( pDisplay, drawable, CursorGC, x, y1 + 1, x, y2 - 1 );
	XDrawLine( pDisplay, drawable, CursorGC, x - 2, y2, x + 2, y2 );
	XDrawLine( pDisplay, drawable, CursorGC, x - 2, y1, x + 2, y1 );
}


// ȹԤβ
void CTaEditDraw::DrawCurLineUnderbar( int curline, bool flg ) const
{
	Drawable drawable = XtWindow( m_Draw );
	DrawCurLineUnderbar( curline, flg, drawable );
}
void CTaEditDraw::DrawCurLineUnderbar( int curline, bool flg, Drawable drawable ) const
{
	int w = 0;
	int h = 0;
	int y = 0;
	Display *pDisplay = XtDisplay( m_Draw );
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int hpos = 0;
	GC wGC;
	int TopLineNum = 0;

	GetSize( &w, &h );

	// 褹ɬפʤФʤˤ⤷ʤ
	if ( !pConf->GetDrawCurLineUnderBar() ) return ;
	TopLineNum = GetTopLineNum();
	if ( curline < TopLineNum || curline >= TopLineNum + GetViewLineCnt() )
		return ;

	// GC
	if ( flg )
		wGC = pGCMgr->GetCurLineUnderBarGC();
	else
		wGC = pGCMgr->GetClearGC();

	if ( !wGC ) return ;

	// 褹
	hpos = pConf->GetCurrentLineUnderbarPosition();
	y = ( curline - TopLineNum + 1 ) * GetTextHeight() - 1 + hpos;
	XDrawLine( pDisplay, drawable, wGC, LeftColumnWidth + 1, y, w + LeftColumnWidth, y );
}

// ĥ
void CTaEditDraw::ScrollV( int y, bool NeedRedraw )
{
	pVScrollMgr->SetValue( y );
	OnScrValueChange( pVScrollMgr, y, NeedRedraw );
}

// 
void CTaEditDraw::ScrollH( int x, bool NeedRedraw )
{
	// Xޤޤ褦ScrollAtñ̤ˤʤ褦˥뤵
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int ViewWidth = GetViewWidth();
	int ScrMin = ( 0 - pConf->GetLeftPadding() );	// 뤷Ǿ
	int ScrMax = ( MaxLengthPix - ViewWidth + pConf->GetRightPadding() );	// Ʊ
	int HScrollAt = pConf->GetHScrollAt();			// 뤹ñ
	int wx = x;

	// ǾScrMinHScrollAtñ̤˥뤷
	wx -= ScrMin;
	wx /= HScrollAt;
	if ( x >= pHScrollMgr->GetValue() )
		wx += 1;	// 뤹
	wx *= HScrollAt;
	wx += ScrMin;

	// ʥˤäơ뤬ʤʤäƤޤȤɻ
	if ( x >= pHScrollMgr->GetValue() ) {
		if ( x + ViewWidth < wx ) wx = x + ViewWidth / 2;
	}
	else {
		if ( wx + ViewWidth < x ) wx = x - ViewWidth / 2;
	}

	// ΰ֤¤䲼¤ۤƤʤȤݾ
	if ( wx < ScrMin ) wx = ScrMin;
	if ( wx >= ScrMax ) wx = ScrMax;

	pHScrollMgr->SetValue( wx );
	OnScrValueChange( pHScrollMgr, wx, NeedRedraw );
}

// ǽ˲̤ɽȤΥ٥
void CTaEditDraw::OnFirstExpose()
{
	int w = 0;
	int h = 0;
	int Line = 0;
	int DocLineCnt = 0;
	const CCmdOption& rCmdOption = m_TaEditShell->GetCmdOption();
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();

	IsFirstExposed = true;	// ǽβɽλȤ򼨤

	// XIM֥Ȥ
	pXimMgr = new CXimMgr();
	if ( pXimMgr.IsNull() ) goto ERR_EXIT;
	if( !pXimMgr->Initialize( m_Draw, pConf ) )  goto ERR_EXIT;
	pXimMgr->SetLeftColumnWidth( LeftColumnWidth );

	// ֥Хåեѥԥåޥåפ
	w = WidthOfScreen( XtScreen( m_Draw ) );
	h = HeightOfScreen( XtScreen( m_Draw ) );
	if ( pConf->GetUseDoubleBuffering() )
		BackgndPixmap = XCreatePixmap( XtDisplay( m_Draw ), XtWindow( m_Draw ), w, h, 24 );
	else
		BackgndPixmap = NULL;

	// GCݻ֥Ȥۤ
	pGCStorage = new CGCStorage();
	if ( pGCStorage.IsNull() ) goto ERR_EXIT;

	// ΥɥȤۤ줿νԤ
	OnReadDocument();

	// ޥɹԤ˻ꤵ줿ץ

	// ư˳եλ
	if ( rCmdOption.IsEnableFileName() ) {
		string fname = rCmdOption.GetFileName();
		enumLANGTYPE LType = rCmdOption.GetLangType();
		string encodename = rCmdOption.GetEncodeName();
		m_TaEditShell->OpenFile( fname, LType, encodename );
	}

	// ư˥ꤹֹ
	if ( rCmdOption.IsEnableInitLine() ) {
		ScrollInfoPacket scrPacket;
		Line = rCmdOption.GetInitLine() - pConf->GetLineNumberOrigin();
		DocLineCnt = m_TaEditShell->GetDocument()->RefData().size();	// ɥȤιԿ

		// ꤹԤϰϤǧ
		if ( Line < 0 ) Line = 0;
		if ( Line >= DocLineCnt ) Line = DocLineCnt - 1;

		// ֤ꤹ
		pCursorInfo->SetCurPos( T_CurPos( Line, 0 ), &scrPacket, false );
		// 
		if ( scrPacket.NeedYScroll ) ScrollV( scrPacket.lineY, true );
	}

	// ȥꤹ
	m_TaEditShell->ResetTitle( TITLESTR_ALL );

	return ;

ERR_EXIT:
	m_TaEditShell->ShowErrorMsgBox( pConf->RefOutOfMemoryErrorMsg() );
	pXimMgr = NULL;
}

// 
////////////////////////////////////////////////////////////////////////////

// СΥ֥Ȥ
void CTaEditDraw::SetScrollMgr( CScrollMgr *argpH, CScrollMgr *argpV )
{
	pHScrollMgr = argpH;
	pVScrollMgr = argpV;
}

// μ
////////////////////////////////////////////////////////////////////////////

// ƥȤι⤵
int CTaEditDraw::GetTextHeight() const
{
	return TextHeight;
}
int CTaEditDraw::GetTextAscent() const
{
	return TextAscent;
}

// ʸ
int CTaEditDraw::GetCharWidth( wchar_t c, int xpos ) const
{
	// tabʳʸʤСʸ֤
	if ( c != '\t' )
		return XwcTextEscapement( fontSet, &c, 1 );

	// Tabʸξϡ˽׻ɬפ
	if ( TWCM_FIX == TabWidth_CM )
		return TabWidth;	// 
	else {
		// TabWidthñ̤ڤ夲
		int w = ( (int)ceil( (double)xpos / (double)TabWidth ) ) * TabWidth - xpos;
		if ( w <= 0 ) w = TabWidth;
		return w;
	}
}

// ־褷ƤԤιֹ
int CTaEditDraw::GetTopLineNum() const
{
	return numTopLine;
}

// ϰϤκüΥԥΰ֤
int CTaEditDraw::GetLeftPixPos() const
{
	if ( NULL != pHScrollMgr )
		return pHScrollMgr->GetValue();
	return 0;
}

// ӥ塼ǤԿ
int CTaEditDraw::GetViewLineCnt() const
{
	int x, y;
	GetSize( &x, &y );	// ɥ
	return y / TextHeight;	// ̤ǽʹԿ򻻽
}

// ӥ塼
int CTaEditDraw::GetViewWidth() const
{
	int w, h;
	GetSize( &w, &h );
	return w;
}

// ̤˲褷Ƥ뤫
int CTaEditDraw::GetDrawedLineCnt() const
{
	const T_LineData &rData = m_TaEditShell->GetDocument()->RefData();
	return min( (long)( rData.size() - numTopLine ), (long)GetViewLineCnt() );
}

// ΰΥ
void CTaEditDraw::GetSize( int *pX, int *pY ) const
{
	int ac = 0;
	Arg al[2];
	Dimension wx, wy;

	// ɥΥ
	XtSetArg( al[ac], XmNwidth, &wx ); ac++;
	XtSetArg( al[ac], XmNheight, &wy ); ac++;
	XtGetValues( m_Draw, al, ac );
	(*pX) = wx - LeftColumnWidth;
	(*pY) = wy;
}

// Խ֥Ȥ
VClsPtr< CTextEdit > CTaEditDraw::GetTextEditor()
{
	return pTextEditor;
}

// ֥Ȥ
VClsPtr< CCursor > CTaEditDraw::GetCursorInfo()
{
	return pCursorInfo;
}
const CCursor* CTaEditDraw::GetCursorInfo() const
{
	return pCursorInfo.GetPtr();
}

// եξ֤
bool CTaEditDraw::GetForcusState() const
{
	return ForcusState;
}

// 
////////////////////////////////////////////////////////////////////////////

// ̾Xɸ顢鲿ʸܤ򻻽Ф
int CTaEditDraw::XPosToCharNum( int lineY, int pixX ) const
{
	assert( NULL != this && lineY >= 0 );
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	const T_LineData &rl = pDoc->RefData();
	assert( lineY < rl.size() );

	// ʸˡ
	enumCHARSELTYPE CharSelType = m_TaEditShell->GetConfigInfo()->GetCharSelType();

	// ƥ졼
	T_LineDataItr_c witr = rl.begin() + lineY;
	const CDrawCharPos& rDCP = witr->GetDrawCharPos();

	// ̾Ǥκɸ򡢹Ƭ0ȤɸѴ
	const int wXPos = pixX + GetLeftPixPos();

	// ꤵ줿顢ƬǤΤȤ
	if ( wXPos <= 0 ) return 0;

	// ־ѤǤʤä顢ۤ
	if ( !witr->IsEnableDrawCharPos() )
		witr->UpdateDrawCharPos( this );

	int r = rDCP.FindPosToRowNum( (unsigned int)wXPos, CharSelType );
	return r;
}

// ̾κɸ顢ʸ֤򻻽Ф
T_CurPos CTaEditDraw::PixPosToCurPos( int pixX, int pixY ) const
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	const int DataLineCnt = pDoc->RefData().size();

	// Ԥΰ֤򻻽
	int lineY = numTopLine + ( pixY / TextHeight );
	if ( lineY < 0 ) lineY = 0;
	if ( lineY >= DataLineCnt ) lineY = DataLineCnt - 1;

	// ʸ֤򻻽
	int cposX = XPosToCharNum( lineY, pixX );

	return T_CurPos( lineY, cposX );
}

// С줿
void CTaEditDraw::OnScrValueChange( const CScrollMgr *argpMgr, int value, bool NeedRedraw )
{
	if ( argpMgr != pVScrollMgr && argpMgr != pHScrollMgr && !IsFirstExposed )
		return ;
	if ( argpMgr == pVScrollMgr ) numTopLine = value;

	if ( NeedRedraw ) OnRedraw( TED_REUSE_CHAR_INFO );
	pCursorInfo->RefleshXIMPos();	// XIMΰ֤

}

// ̤򥯥ꥢ
void CTaEditDraw::ClearBackScreen()
{
	XRectangle rect;
	Display *pDisplay = XtDisplay( m_Draw );
	Drawable drawable = BackgndPixmap;
	int w, h;

	// ֤äƤʤСʤ
	if ( NULL == pDisplay || NULL == drawable || pGCMgr.IsNull() )
		return ;

	GetSize( &w, &h );	// ̤Υ
	w += LeftColumnWidth;	// GetSizeǼϡ餫LeftColumnWidthƤ
	XFillRectangle( pDisplay, drawable, pGCMgr->GetClearGC(), 0, 0, w, h );

	// ѤߤιԤ򼨤򥯥ꥢ
	vDrewLD.clear();
}

// 
void CTaEditDraw::OnRedraw( enumREDRAWTYPE type )
{
	OnRedraw( type, numTopLine, numTopLine + GetDrawedLineCnt() );
}


// ϰϤꤷơ
void CTaEditDraw::OnRedraw( enumREDRAWTYPE type, int argSLine, int argELine )
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const T_LineData &rData = pDoc->RefData();
	const int TotalLineCount = rData.size();
	int i, w, h;
	XRectangle rect;
	Display *pDisplay = XtDisplay( m_Draw );
	Drawable drawable;
	int wMaxLineLength = 0;	// 褷ǡǤĹԤΥԥ
	int RetMarkWidth;
	GC wGC;

	// Եɽɬפϡʬݤ
	if ( pConf->GetDrawEditMark() )
		RetMarkWidth = GetTextHeight();
	else
		RetMarkWidth = 0;

	// ֥Хåե󥰤ѤϡöBackgndPixmap褹
	if ( pConf->GetUseDoubleBuffering() )
		drawable = BackgndPixmap;
	else
		drawable = XtWindow( m_Draw );

	// ֤äƤʤСʤ
	if ( NULL == pDisplay ) return ;
	if ( NULL == drawable ) return ;
	if ( NULL == fontSet ) return ;
	if ( pGCMgr.IsNull() ) return ;

	// ϰϤǧĴ
	if ( argSLine < numTopLine )
		argSLine = numTopLine;
	if ( argELine > numTopLine + GetViewLineCnt() )
		argELine = numTopLine + GetViewLineCnt();

	const int RedrawLineCnt = argELine - argSLine;	// 褹Կ
	const int wSL = argSLine - numTopLine;			// ̾Ǥ賫ϰ
	const int wEL = argELine - numTopLine;			// ̾Ǥ轪λ
	const int wRealViewLineCnt = GetDrawedLineCnt();	// ̤ǽʹԿ
	const int DrawPosX = GetLeftPixPos();			// 
	int AbsLN;	// ƬԤιֹݻ

	T_LineDataItr_c itr = rData.begin() + argSLine;
	GetSize( &w, &h );		// ̤Υ
	w += LeftColumnWidth;	// GetSizeǼϡLeftColumnWidthƤ

	// ѤˡvDrewLDΥݾڤ
	vDrewLD.resize( GetViewLineCnt(), CDrewLineCash() );

	// ʸ
	for ( i = wSL; i < wEL && numTopLine + i < TotalLineCount; i++, itr++ ) {
		AbsLN = i + numTopLine;	// ƬԤιֹ򻻽Ф

		// typeTED_LINE_BASEǺ褹ɬפʤϥåפ
		if ( TED_LINE_BASE == type && vDrewLD[ i ] == CDrewLineCash( (*itr) ) )
			continue;

		// ־ѤǤʤϺƹۤ
		if ( !itr->IsEnableDrawCharPos() )
			itr->UpdateDrawCharPos( this );

		// ǤĹԤΥԥ줿ݤ
		if ( itr->GetDrawCharPos().GetRightXPos() > wMaxLineLength )
			wMaxLineLength = itr->GetDrawCharPos().GetRightXPos();

		// Ԥα¦طʿɤĤ֤
		wGC = pGCMgr->GetClearGC();
		if ( (int)( itr->GetDrawCharPos().GetRightXPos() ) - DrawPosX + LeftColumnWidth < w ) {
			// ʹԤαṳ̈αüۤƤΤʤ顢طʿǾõɬפϤʤ
			int wxpos =  ( (int)itr->GetDrawCharPos().GetRightXPos() ) - DrawPosX + LeftColumnWidth;
			int wwidth = w -  wxpos;
			XFillRectangle( pDisplay, drawable, wGC, wxpos, i * TextHeight, wwidth, TextHeight );
		}

		// Ԥκ¦طʿɤĤ֤
		if ( DrawPosX < 0 ) {
			// ʹԤκṳ̈κüۤƤΤǤСطʿǾõɬפϤʤ
			XFillRectangle( pDisplay, drawable, wGC, LeftColumnWidth + 1, i * TextHeight, -DrawPosX, TextHeight );
		}

		// 
		DrawString_ReuseCharInfo( pDisplay, drawable, -DrawPosX,
			TextHeight * i, itr, AbsLN, w, ( AbsLN == TotalLineCount - 1 ) );

		// ¦Υ褹
		if ( LeftColumnWidth > 0 ) {
			int wLineNumber = AbsLN + pConf->GetLineNumberOrigin();
			DrawLeftColumn( pDisplay, drawable, TextHeight * i, itr, wLineNumber );
		}

		// 褷Ԥɤ줫¸
		vDrewLD[ i ] = CDrewLineCash( (*itr) );
	}

	if ( DrawedLineCnt_hoz > wRealViewLineCnt ) {
		// 褵줿Ԥϡä٤ʬ˻ĤäƤʸõ
		wGC = pGCMgr->GetClearGC();
		int y = wRealViewLineCnt * TextHeight;
		int height = ( DrawedLineCnt_hoz - wRealViewLineCnt ) * TextHeight;
		XFillRectangle( pDisplay, drawable, wGC, 0, y, w, height );

		// äȤ褵ƤԤˡ̤õ줿ȤϿ
		for ( i = wRealViewLineCnt; i < DrawedLineCnt_hoz; i++ )
			vDrewLD[ i ] = CDrewLineCash();
	}

	// ĥΰȥƥΰʬ䤹褹
	if ( pConf->GetDrawSeparatorLine() ) {
		wGC = pGCMgr->GetLeftColumnSeparatorGC();
		XDrawLine( pDisplay, drawable, wGC, LeftColumnWidth, 0, LeftColumnWidth, h );
	}

	if ( pConf->GetUseDoubleBuffering() ) {
		// ԥåޥåפƤɥåȤɽ
		wGC = pGCMgr->GetClearGC();
		XCopyArea( pDisplay, BackgndPixmap, XtWindow( m_Draw ), wGC, 0, 0, w, h, 0, 0 );
	}

	// ˺褵줿ȤΤ
	pCursorInfo->OnRedraw();

	// Сκͤꤹ
	if ( MaxLengthPix < wMaxLineLength + RetMarkWidth ) {
		MaxLengthPix = wMaxLineLength + RetMarkWidth;
		pHScrollMgr->SetMax( MaxLengthPix );
	}

	// ̤褷Կݻ
	DrawedLineCnt_hoz = wRealViewLineCnt;
}

// ʸ褹
// XPos,YPos 褹
// XPosͿ줿ϡιԤκü褵ʤ
// Ϳ줿ϡιԤκü˶
// LineNum ̾βܤιԤ
void CTaEditDraw::DrawString_ReuseCharInfo(
	Display *pDisplay,
	Drawable argDrawable,
	int XPos,
	int YPos,
	const T_LineDataItr_c &rItr,
	int LineNum,
	int ViewWidth,
	bool IsLastLine ) const
{
	int s, e;	// 褹ϰϡʸ
	int wXPos;		// 򳫻Ϥ֡ʥԥ
	const wstring &rStr = rItr->getString();	// 褹ʸ
	const CDrawCharPos &rDPos = rItr->GetDrawCharPos();
	const int CharCnt = rDPos.GetCharCnt();

	// 򳫻Ϥ֡ʸˤ
	if ( XPos < 0 )
		s = rDPos.FindPosToRowNum( abs( XPos ), CST_LEFT );
	else {
		// ˶褹ϡüƬʸ褹롣
		s = rDPos.FindPosToRowNum( 0, CST_LEFT );
	}

	// 򳫻Ϥ֡ʥԥˤ
	if ( CharCnt > s )
		wXPos = rDPos.GetCharPos( s ) + XPos + LeftColumnWidth;
	else
		wXPos = rDPos.GetRightXPos() + XPos + LeftColumnWidth;

	// λ֡ʸˤ
	e = rDPos.FindPosToRowNum( ViewWidth - XPos, CST_RIGHT );

	DrawString( pDisplay, argDrawable, wXPos, YPos, rItr, s, e - s, LineNum, IsLastLine );
}

// ̤λꤵ줿֤ʸ
void CTaEditDraw::DrawString(
	Display *pDisplay,
	Drawable argDrawable,
	int XPos,
	int YPos,
	const T_LineDataItr_c &rItr,
	int StrSPos,
	int StrCnt,
	int LineNum,
	bool IsLastLine ) const
{
	unsigned int wXPos = XPos;
	GC hGC;		// GC¸
	bool hIsTab;	// ʸ֤äݤ
	int hIdx;	// 褹Ȥϰ֤ȤʤʸΥǥå
	bool hIsSel;
	int i;
	const wstring &rStr = rItr->getString();
	const size_t StrLength = rStr.length();
	bool wIsSel;	// GCݤˡ򤵤Ƥ뤫ݤöݻѿ
	unsigned int wWidth;	// ʸ(Pixcel)ݻѿ
	const CDrawCharPos& rDrawCharPos = rItr->GetDrawCharPos();
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	GC LineGapGC;	// Դ֤η֤褹뤿GC
	bool DrawLineGap = false;	// Դ֤褹ɬפ뤫ݤ

	// ⤽Դ֤˷֤ʤСԴ֤ɬפʤ
	if ( pConf->GetLineGapWidth() > 0 ) DrawLineGap = true;

	if ( !( StrCnt <= 0 || StrLength <= StrSPos || StrLength < StrSPos + StrCnt ) ) {

		// ֡󥿥֤ޤGCѲ뤿Ӥ褹
		wIsSel = pCursorInfo->IsCharSelected( T_CurPos( LineNum, StrSPos ) );
		hIsTab = ( (*rItr)[ StrSPos ].moji == L'\t' );
		hGC = pGCMgr->GetTextDrawGC( (*rItr)[ StrSPos ].iro, wIsSel, hIsTab );
		hIdx = StrSPos;
		hIsSel = wIsSel;
		wWidth = 0;

		for ( i = StrSPos; i < StrSPos + StrCnt; i++ ) {

			// rStr[i]褹Τ˻ѤGC
			wIsSel = pCursorInfo->IsCharSelected( T_CurPos( LineNum, i ) );
			GC wGC = pGCMgr->GetTextDrawGC( (*rItr)[ i ].iro, wIsSel, ( rStr[i] == L'\t' ) );

			if ( hGC != wGC || hIsTab != ( rStr[i] == L'\t' ) ) {
				// ѤäᡢʸϤ
				if ( hIsTab ) {
					// TAB褹
					DrawTab( pDisplay, argDrawable, hIdx, i, rDrawCharPos, wWidth, wXPos, YPos, hGC, pGCMgr->GetEditMarkGC() );
				}
				else {
					// ʸ褹
					XwcDrawImageString( pDisplay, argDrawable, fontSet, hGC, wXPos, YPos + TextAscent, rStr.begin() + hIdx, i - hIdx );

					// Դ֤ζ褹
					if ( DrawLineGap ) {
						if ( hIsSel )
							LineGapGC = pGCMgr->GetSelTabGC();
						else
							LineGapGC = pGCMgr->GetClearGC();
						XFillRectangle( pDisplay, argDrawable, LineGapGC, wXPos, YPos, wWidth, TextHeight - FontHeight );						
					}
				}

				// ߤξ¸
				hGC = wGC;
				hIsTab = ( rStr[i] == L'\t' );
				hIdx = i;
				hIsSel = wIsSel;
				wXPos += wWidth;	// 褹٤֤򻻽Ф
				wWidth = 0;
			}

			// ʸ
			wWidth += rDrawCharPos.GetCharWidth( i );
		}

		// ԤκǸʬ
		if ( hIsTab )
			DrawTab( pDisplay, argDrawable, hIdx, i, rDrawCharPos, wWidth, wXPos, YPos, hGC, pGCMgr->GetEditMarkGC() );
		else
			XwcDrawImageString( pDisplay, argDrawable, fontSet, hGC, wXPos, YPos + TextAscent, rStr.begin() + hIdx, i - hIdx );

		// ԤκǸʬιԴ֤
		if ( DrawLineGap ) {
			if ( hIsSel )
				LineGapGC = pGCMgr->GetSelTabGC();
			else
				LineGapGC = pGCMgr->GetClearGC();
			XFillRectangle( pDisplay, argDrawable, LineGapGC, wXPos, YPos, wWidth, TextHeight - FontHeight );						
		}

		wXPos += wWidth;
	}
	else {
		wXPos = XPos;
	}

	// Ե褹
	if ( pConf->GetDrawEditMark() && wXPos + GetTextHeight() >= 0 && wXPos < GetViewWidth() && !IsLastLine ) {
		GC wClearGC = pGCMgr->GetClearGC();
		GC wEditMarkGC = pGCMgr->GetEditMarkGC();
		DrawRetMark( pDisplay, argDrawable, wXPos, YPos, wClearGC, wEditMarkGC );
	}
}

// TAB
void CTaEditDraw::DrawTab(
	Display *pDisplay,
	Drawable argDrawable,
	int s,
	int e,
	const CDrawCharPos& rDrawCharPos,
	int width,
	int XPos,
	int YPos,
	GC ClearGC,
	GC EditMarkGC ) const
{
	int HPos = YPos + FontHeight / 2;	// 褹Y
	int i;
	int wx = XPos;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	// ޤ϶
	XFillRectangle( pDisplay, argDrawable, ClearGC, XPos, YPos, width, TextHeight );

	// Խ褷ʤΤʤ顢ǽλ
	if ( !pConf->GetDrawEditMark() ) return;

	// 
	for ( i = s; i < e; i++ ) {
		int CharWidth = rDrawCharPos.GetCharWidth( i );	// TABʬ
		int ArrowWidth = CharWidth / 2;	// Ĺ
		int LPos = wx + ArrowWidth / 2;	// κü
		int RPos = LPos + ArrowWidth;	// αü
		wx += CharWidth;

		XDrawLine( pDisplay, argDrawable, EditMarkGC, LPos, HPos, RPos, HPos );
		XDrawLine( pDisplay, argDrawable, EditMarkGC, RPos, HPos, RPos - ArrowWidth / 4, HPos - FontHeight / 4 );
		XDrawLine( pDisplay, argDrawable, EditMarkGC, RPos, HPos, RPos - ArrowWidth / 4, HPos + FontHeight / 4 );
	}
}

// Եɽ
// ԽɽʤΤǤСϸƤФʤ
void CTaEditDraw::DrawRetMark( Display *pDisplay, Drawable drawable, int x, int y, GC ClearGC, GC EditMarkGC ) const
{
	int RetMarkHeight = GetTextHeight();
	int RetMarkWidth = GetTextHeight();
	int h_waru_3 = RetMarkHeight / 3;
	int w_waru_3 = RetMarkWidth / 3;
	int xp[] = { x + w_waru_3, x + RetMarkWidth - w_waru_3, x + w_waru_3, x + RetMarkWidth - w_waru_3 };
	int yp[] = { y + h_waru_3, y + h_waru_3, y + RetMarkHeight - h_waru_3, y + RetMarkHeight - h_waru_3 };
	int cpx = x + RetMarkWidth / 2;
	int cpy = y + RetMarkHeight / 2;
	int bpx = x + RetMarkWidth / 2;
	int bpy = cpy + h_waru_3;

	// ޤ϶
	XFillRectangle( pDisplay, drawable, ClearGC, x, y, RetMarkWidth, RetMarkHeight );

	// 
	XDrawLine( pDisplay, drawable, EditMarkGC, xp[1], yp[1], xp[3], yp[3] );
	XDrawLine( pDisplay, drawable, EditMarkGC, xp[2], yp[2], xp[3], yp[3] );
	XDrawLine( pDisplay, drawable, EditMarkGC, xp[2], yp[2], cpx, cpy );
	XDrawLine( pDisplay, drawable, EditMarkGC, xp[2], yp[2], bpx, bpy );		
}

// ¦Υ
void CTaEditDraw::DrawLeftColumn(
	Display *pDisplay,
	Drawable argDrawable,
	int YPos,
	const T_LineDataItr_c &rItr,
	int LineNumber ) const
{
	int i;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int ExInfoColW = pConf->GetExInfoColumnWidth();
	int ExInfoColCnt = pConf->GetExInfoColumnCount();
	int ExInfoWidth = ExInfoColW * ExInfoColCnt;		// ĥΰ
	int LineNumberWidth = LeftColumnWidth - ExInfoWidth;	// ֹΰ
	GC wGC;
	wchar_t Buf[25];
	XRectangle rect;

	// פʤΤõ
	wGC = pGCMgr->GetClearGC();
	XFillRectangle( pDisplay, argDrawable, wGC, 0, YPos, ExInfoWidth, TextHeight );

	// ƥ褹
	for ( i = 0; i < ExInfoColCnt; i++ ) {
		if ( rItr->GetExtendInfo( i ) ) {
			wGC = pGCMgr->GetExInfoColumnGC( i );
			XFillRectangle( pDisplay, argDrawable, wGC, ExInfoColW * i, YPos, ExInfoColW, TextHeight );
		}
	}

	// ֹɽΰ褬1Pixelʾ夢ϡֹɽ
	if ( pConf->GetLineNumberColumnWidth() <= 0 ) return ;

	// ֹɽΰ
	wGC = pGCMgr->GetClearGC();
	XFillRectangle( pDisplay, argDrawable, wGC, ExInfoWidth, YPos, LineNumberWidth, TextHeight );

	// ֹ
	wGC =  pGCMgr->GetLineNumberGC();
	rect.x = 0;
	rect.y = 0;
	rect.width = LineNumberWidth;
	rect.height = TextHeight;
	XSetClipRectangles( pDisplay, wGC, ExInfoWidth, YPos, &rect, 1, Unsorted );
	swprintf( Buf, sizeof( Buf ) / sizeof( Buf[0] ), L"%d", LineNumber );
	XwcDrawImageString( pDisplay, argDrawable, fontSet, wGC, ExInfoWidth, YPos + TextAscent, Buf, wslen( Buf ) );
}

// ԽκԤ
void CTaEditDraw::AfterEditRedraw( const ScrollInfoPacket &rScrPacket )
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	ScrollInfoPacket wScrPacket = rScrPacket;
	int ViewLineCnt = GetViewLineCnt();
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int RetMarkWidth;

	// Եɽɬפϡʬݤ
	if ( pConf->GetDrawEditMark() )
		RetMarkWidth = GetTextHeight();
	else
		RetMarkWidth = 0;

	// β֤MaxLengthPixۤϡMaxLengthPix򹹿
	if ( MaxLengthPix < pCursorInfo->GetCurPosX() + RetMarkWidth ) {
		MaxLengthPix = pCursorInfo->GetCurPosX() + RetMarkWidth;
		pHScrollMgr->SetMax( MaxLengthPix );
	}
	if ( wScrPacket.NeedXScroll ) ScrollH( wScrPacket.pixX, false );

	const int AfterLineCnt = pDoc->RefData().size();	// ԽιԿ

	// ̤ͭäơԿäϡ˥뤹ɬפ
	if ( ( pVScrollMgr->GetValue() + ViewLineCnt > AfterLineCnt ) ) {
		int wScrCnt = AfterLineCnt - ViewLineCnt;	// ɤ˥뤹뤫
		if ( wScrCnt < 0 ) wScrCnt = 0;
		ScrollV( wScrCnt, false );
		// wScrPacket.NeedYScroll = false;
	}

	// ͤ
	pVScrollMgr->SetMax( AfterLineCnt );

	// ΰưȼ
	if ( wScrPacket.NeedYScroll ) ScrollV( wScrPacket.lineY, false );

	// ɬפ˱
	if ( rScrPacket.NeedYScroll || rScrPacket.NeedXScroll )
		OnRedraw( TED_REUSE_CHAR_INFO );
	else
		OnRedraw( TED_LINE_BASE );
}

// ϰϤѲκԤ
void CTaEditDraw::AfterSelRangeRedraw( int argSLine, int argELine )
{
	OnRedraw( TED_REUSE_CHAR_INFO, argSLine, argELine );
}
