////////////////////////////////////////////////////////////////////////////
// CTaEditPrintDlg 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"
#include "TaEditPrintDlg.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// ¾
////////////////////////////////////////////////////////////////////////////

// ֤ο
#define TAB_BTN_CNT 6

// ǥե͵ҥեΥ̾
#define DF_SECTION		L"PrintDlg"

// ǥե͵ҥեǻѤƤ롢ͤ̾
#define DF_TargetPrinter	L"TargetPrinter"
#define DF_PrintCount		L"PrintCount"
#define DF_OutputFile		L"OutputFile"
#define DF_OptFileName		L"OptFileName"
#define DF_Size				L"Size"
#define DF_Direction		L"Direction"
#define DF_NUp				L"NUp"
#define DF_Duplex			L"Duplex"
#define DF_Font				L"Font"
#define DF_FontSize			L"FontSize"
#define DF_PrintLineNumber	L"PrintLineNumber"
#define DF_TopSpace			L"TopSpace"
#define DF_BottomSpace		L"BottomSpace"
#define DF_LeftSpace		L"LeftSpace"
#define DF_RightSpace		L"RightSpace"
#define DF_HeaderPosition	L"HeaderPosition"
#define DF_HeaderLeft		L"HeaderLeft"
#define DF_HeaderCenter		L"HeaderCenter"
#define DF_HeaderRight		L"HeaderRight"
#define DF_FooterPosition	L"FooterPosition"
#define DF_FooterLeft		L"FooterLeft"
#define DF_FooterCenter		L"FooterCenter"
#define DF_FooterRight		L"FooterRight"

// ѻ極ҥեǻѤƤ롢ͤ̾
#define PSF_Name			L"Name"
#define PSF_Width			L"Width"
#define PSF_Height			L"Height"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditPrintDlg::CTaEditPrintDlg() :
	IsFirst( true ),
	OptFileName( "" )
{
	int i;
	for ( i = 0; i < TAB_BTN_CNT; i++ )
		TabBtnShadowTickness[i] = 1;
	PageChangeByProg = false;

	TargetPrinter = "_default";
	PrintCount = 1;
	OutputFile = false;
	OptFileName = "";
	Size = "";
	Direction = true;
	NUp = 1;
	Duplex = false;
	Font = "";
	FontSize = 12;
	PrintLineNumber = false;
	TopSpace = 25;
	BottomSpace = 25;
	LeftSpace = 25;
	RightSpace = 25;
	HeaderPosition = 25;
	HeaderLeft = "";
	HeaderCenter = "";
	HeaderRight = "";
	FooterPosition = 25;
	FooterLeft = "";
	FooterCenter = "";
	FooterRight = "";

	vPaperSize.clear();
	IsOK = false;
}

CTaEditPrintDlg::~CTaEditPrintDlg()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ɽ
bool CTaEditPrintDlg::ShowDlg()
{
	char wbuf[3] = { 0 };
	IsOK = false;

	// ΰ
	if ( IsFirst ) {
		// ޥ͡ƤʤȡåȤͤǤʤ
		XtManageChild( m_PrintDlg );
		XtUnmanageChild( m_PrintDlg );
		IsFirst = false;

		// ѻ極ͤ
		ReadPaperSizeConfig();

		// ץ̾ΰ
		ReadPrinterName();

		// åȤν
		InitializeWidget();
	}

	// ǥեͤɤ߹
	GetDefaultValue();

	// åȤ˥ǥեͤꤹ
	SetValuesToWidget();

	// ⡼ɽ
	m_ModalDlg.DoModal( m_PrintDlg );
	return true;
}

// åȤνԤ
void CTaEditPrintDlg::InitializeWidget()
{
	int i;
	vector< string > vFontList;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	// ѻ極
	for ( i = vPaperSize.size() - 1; i >= 0; i-- ) {
		CCompoundStr wCS( vPaperSize[i].Name );
		XmComboBoxAddItem( m_PrintFormSize, wCS, 1, true );
	}

	// ץ̾
	for ( i = vPrinterName.size() - 1; i >= 0; i-- ) {
		CCompoundStr wCS( vPrinterName[i] );
		XmComboBoxAddItem( m_PrintPrinterPrinterName, wCS, 1, true );
	}

	// ե̾
	vFontList = GlbFunc::DiviteString( pConf->RefPrintDlg_FontList(), ',' );
	for ( i = vFontList.size() - 1; i >= 0; i-- ) {
		CCompoundStr wCS( vFontList[i] );
		XmComboBoxAddItem( m_PrintTextFont, wCS, 1, true );
	}
}

// ƥåȤؤͤ
void CTaEditPrintDlg::SetValuesToWidget()
{
	int ac = 0;
	Arg al[3];
	Widget wgt;
	char wbuf[20];

	ac = 0;
	XtSetArg( al[ac], XmNtextField, &wgt ); ac++;
	XtGetValues( m_PrintPrinterPrinterName, al, ac );
	XmTextFieldSetString( wgt, GlbFunc::TempStr( TargetPrinter ).GetPtr() );

	snprintf( wbuf, 20, "%d", PrintCount );
	XmTextFieldSetString( m_PrintPrinterCopyNums, wbuf );

	if ( OutputFile )
		XmToggleButtonSetState( m_PrintPrinterOptFileTgl, True, True );
	else
		XmToggleButtonSetState( m_PrintPrinterOptFileTgl, False, True );

	XmTextFieldSetString( m_PrintPrinterOptFileFName, GlbFunc::TempStr( OptFileName ).GetPtr() );

	ac = 0;
	XtSetArg( al[ac], XmNtextField, &wgt ); ac++;
	XtGetValues( m_PrintFormSize, al, ac );
	XmTextFieldSetString( wgt, GlbFunc::TempStr( Size ).GetPtr() );

	if ( Direction ) {
		XmToggleButtonSetState( m_PrintFormDirectionV, True, True );
		XmToggleButtonSetState( m_PrintFormDirectionH, False, True );
	}
	else {
		XmToggleButtonSetState( m_PrintFormDirectionV, False, True );
		XmToggleButtonSetState( m_PrintFormDirectionH, True, True );
	}

	switch( NUp ) {
	case 1:
		XmToggleButtonSetState( m_PrintFormNUpTgl1, True, True );
		XmToggleButtonSetState( m_PrintFormNUpTgl2, False, True );
		XmToggleButtonSetState( m_PrintFormNUpTgl4, False, True );
		break;		
	case 2:
		XmToggleButtonSetState( m_PrintFormNUpTgl1, False, True );
		XmToggleButtonSetState( m_PrintFormNUpTgl2, True, True );
		XmToggleButtonSetState( m_PrintFormNUpTgl4, False, True );
		break;
	case 4:
		XmToggleButtonSetState( m_PrintFormNUpTgl1, False, True );
		XmToggleButtonSetState( m_PrintFormNUpTgl2, False, True );
		XmToggleButtonSetState( m_PrintFormNUpTgl4, True, True );
	}

	if ( Duplex )
		XmToggleButtonSetState( m_PrintFormDuplex, True, True );
	else
		XmToggleButtonSetState( m_PrintFormDuplex, False, True );

	ac = 0;
	XtSetArg( al[ac], XmNtextField, &wgt ); ac++;
	XtGetValues( m_PrintTextFont, al, ac );
	XmTextFieldSetString( wgt, GlbFunc::TempStr( Font ).GetPtr() );

	snprintf( wbuf, 15, "%d", FontSize );
	XmTextFieldSetString( m_PrintTextFontSize, wbuf );

	if ( PrintLineNumber )
		XmToggleButtonSetState( m_PrintTextShowLineNumber, True, True );
	else
		XmToggleButtonSetState( m_PrintTextShowLineNumber, False, True );

	snprintf( wbuf, 20, "%d", TopSpace );
	XmTextFieldSetString( m_PrintSpaceTop, wbuf );

	snprintf( wbuf, 20, "%d", BottomSpace );
	XmTextFieldSetString( m_PrintSpaceBottom, wbuf );

	snprintf( wbuf, 20, "%d", LeftSpace );
	XmTextFieldSetString( m_PrintSpaceLeft, wbuf );

	snprintf( wbuf, 20, "%d", RightSpace );
	XmTextFieldSetString( m_PrintSpaceRight, wbuf );

	snprintf( wbuf, 20, "%d", HeaderPosition );
	XmTextFieldSetString( m_PrintHeaderPosition, wbuf );

	XmTextFieldSetString( m_PrintHeaderLeft, GlbFunc::TempStr( HeaderLeft ).GetPtr() );

	XmTextFieldSetString( m_PrintHeaderCenter, GlbFunc::TempStr( HeaderCenter ).GetPtr() );

	XmTextFieldSetString( m_PrintHeaderRight, GlbFunc::TempStr( HeaderRight ).GetPtr() );

	snprintf( wbuf, 20, "%d", FooterPosition );
	XmTextFieldSetString( m_PrintFooterPosition, wbuf );

	XmTextFieldSetString( m_PrintFooterLeft, GlbFunc::TempStr( FooterLeft ).GetPtr() );

	XmTextFieldSetString( m_PrintFooterCenter, GlbFunc::TempStr( FooterCenter ).GetPtr() );

	XmTextFieldSetString( m_PrintFooterRight, GlbFunc::TempStr( FooterRight ).GetPtr() );

}

// ƥåȤͤɤ߹
// ͤμưĴԤ줿ˤϵ֤
bool CTaEditPrintDlg::GetValuesToWidget()
{
	int ac = 0;
	Arg al[3];
	Widget wgt;
	char *pVal;
	string wstr;
	bool ErrorFlg = false;

	ac = 0;
	XtSetArg( al[ac], XmNtextField, &wgt ); ac++;
	XtGetValues( m_PrintPrinterPrinterName, al, ac );
	pVal = XmTextFieldGetString( wgt );
	TargetPrinter = pVal;
	XtFree( pVal );
	pVal = NULL;

	pVal = XmTextFieldGetString( m_PrintPrinterCopyNums );
	PrintCount = atoi( pVal );
	XtFree( pVal );
	pVal = NULL;
	PrintCount = GlbFunc::CheckRange( PrintCount, 1, 128, &ErrorFlg );
	
	if ( XmToggleButtonGetState( m_PrintPrinterOptFileTgl ) )
		OutputFile = true;
	else
		OutputFile = false;

	pVal = XmTextFieldGetString( m_PrintPrinterOptFileFName );
	OptFileName = pVal;
	XtFree( pVal );
	pVal = NULL;

	ac = 0;
	XtSetArg( al[ac], XmNtextField, &wgt ); ac++;
	XtGetValues( m_PrintFormSize, al, ac );
	pVal = XmTextFieldGetString( wgt );
	Size = pVal;
	XtFree( pVal );
	pVal = NULL;

	if ( XmToggleButtonGetState( m_PrintFormDirectionV ) )
		Direction = true;
	else
		Direction = false;

	if ( XmToggleButtonGetState( m_PrintFormNUpTgl1 ) ) NUp = 1;
	if ( XmToggleButtonGetState( m_PrintFormNUpTgl2 ) ) NUp = 2;
	if ( XmToggleButtonGetState( m_PrintFormNUpTgl4 ) ) NUp = 4;

	if ( XmToggleButtonGetState( m_PrintFormDuplex ) )
		Duplex = true;
	else
		Duplex = false;

	ac = 0;
	XtSetArg( al[ac], XmNtextField, &wgt ); ac++;
	XtGetValues( m_PrintTextFont, al, ac );
	pVal = XmTextFieldGetString( wgt );
	Font = pVal;
	XtFree( pVal );
	pVal = NULL;

	pVal = XmTextFieldGetString( m_PrintTextFontSize );
	FontSize = atoi( pVal );
	XtFree( pVal );
	pVal = NULL;
	FontSize = GlbFunc::CheckRange( FontSize, 1, 256, &ErrorFlg );

	if ( XmToggleButtonGetState( m_PrintTextShowLineNumber ) )
		PrintLineNumber = true;
	else
		PrintLineNumber = false;

	pVal = XmTextFieldGetString( m_PrintSpaceTop );
	TopSpace = atoi( pVal );
	XtFree( pVal );
	pVal = NULL;
	TopSpace = GlbFunc::CheckRange( TopSpace, 1, 65535, &ErrorFlg );

	pVal = XmTextFieldGetString( m_PrintSpaceBottom );
	BottomSpace = atoi( pVal );
	XtFree( pVal );
	pVal = NULL;
	BottomSpace = GlbFunc::CheckRange( BottomSpace, 1, 65535, &ErrorFlg );

	pVal = XmTextFieldGetString( m_PrintSpaceLeft );
	LeftSpace = atoi( pVal );
	XtFree( pVal );
	pVal = NULL;
	LeftSpace = GlbFunc::CheckRange( LeftSpace, 1, 65535, &ErrorFlg );

	pVal = XmTextFieldGetString( m_PrintSpaceRight );
	RightSpace = atoi( pVal );
	XtFree( pVal );
	pVal = NULL;
	RightSpace = GlbFunc::CheckRange( RightSpace, 1, 65535, &ErrorFlg );

	pVal = XmTextFieldGetString( m_PrintHeaderPosition );
	HeaderPosition = atoi( pVal );
	XtFree( pVal );
	pVal = NULL;
	HeaderPosition = GlbFunc::CheckRange( HeaderPosition, 1, 65535, &ErrorFlg );

	pVal = XmTextFieldGetString( m_PrintHeaderLeft );
	HeaderLeft = pVal;
	XtFree( pVal );
	pVal = NULL;

	pVal = XmTextFieldGetString( m_PrintHeaderCenter );
	HeaderCenter = pVal;
	XtFree( pVal );
	pVal = NULL;

	pVal = XmTextFieldGetString( m_PrintHeaderRight );
	HeaderRight = pVal;
	XtFree( pVal );
	pVal = NULL;

	pVal = XmTextFieldGetString( m_PrintFooterPosition );
	FooterPosition = atoi( pVal );
	XtFree( pVal );
	pVal = NULL;
	FooterPosition = GlbFunc::CheckRange( FooterPosition, 1, 65535, &ErrorFlg );

	pVal = XmTextFieldGetString( m_PrintFooterLeft );
	FooterLeft = pVal;
	XtFree( pVal );
	pVal = NULL;

	pVal = XmTextFieldGetString( m_PrintFooterCenter );
	FooterCenter = pVal;
	XtFree( pVal );
	pVal = NULL;

	pVal = XmTextFieldGetString( m_PrintFooterRight );
	FooterRight = pVal;
	XtFree( pVal );
	pVal = NULL;

	return !ErrorFlg;
}

// ѻ極ɤ߹
void CTaEditPrintDlg::ReadPaperSizeConfig()
{
	CONFMAN pCM = NULL;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const string &rPSCFName = pConf->RefPrintDlg_PaperSizeConfFileName();
	PAPERSIZE wPS;
	void *wp = NULL;
	int SecListLen = 0;
	wchar_t *SectionList = NULL;
	wchar_t *pWSL = NULL;

	vPaperSize.clear();

	// ͤ򵭽Ҥե򳫤
	if ( rPSCFName.empty() ) goto ERR_EXIT;
	pCM = confman_CreateConf( rPSCFName.c_str() );
	if ( NULL == pCM ) goto ERR_EXIT;
	if ( !confman_Open( pCM ) ) goto ERR_EXIT;

	// ̾ꥹȤۤ
	wp = exconf_CreateInternalSectionList( pCM, &SecListLen );
	if ( NULL == wp ) goto ERR_EXIT;

	// ̾ꥹȤ뤿ΥХåեݤ
	SectionList = (wchar_t*)calloc( SecListLen + 1, sizeof( wchar_t ) );
	if ( NULL == SectionList ) goto ERR_EXIT;

	// ̾ꥹȤ
	exconf_GetInternalList( wp, SectionList, SecListLen );
	wp = NULL;	// wpϤѺѤߤˤʤ

	pWSL = SectionList;
	while ( (*pWSL) ) {
		const wchar_t *pV_Name = NULL;
		const wchar_t *pV_Width = NULL;
		const wchar_t *pV_Height = NULL;

		// ͤ
		pV_Name = exconf_GetConstStr( pCM, pWSL, PSF_Name );
		pV_Width = exconf_GetConstStr( pCM, pWSL, PSF_Width );
		pV_Height = exconf_GetConstStr( pCM, pWSL, PSF_Height );

		if ( !pV_Name || !pV_Width || !pV_Height  ) {
			// ͤμ˼Ԥ顢ΥɤФ
			CF_SKIPPTR( pWSL );
			continue;
		}
		// ɲä
		GlbFunc::WCStoMBS( pV_Name, &( wPS.Name ) );
		wPS.width = watof( pV_Width );
		wPS.height = watof( pV_Height );
		vPaperSize.push_back( wPS );
		
		CF_SKIPPTR( pWSL );
	}

	// ̾ꥹȤΥΰ
	if ( SectionList ) free( SectionList );
	SectionList = NULL;

	// COMFMAN˴
	if ( NULL != pCM ) confman_Close( pCM );
	pCM = NULL;

	// ͤĤɤ߹ʤäϡ顼Ȥ
	if ( vPaperSize.size() == 0 ) goto ERR_EXIT;

	return ;

ERR_EXIT:
	if ( wp ) exconf_GetInternalList( wp, NULL, 0 );
	wp = NULL;
	if ( SectionList ) free( SectionList );
	SectionList = NULL;
	if ( NULL != pCM ) confman_Delete( pCM );
	pCM = NULL;

	// 顼åɽ
	m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToReadPaperSizeConfigMsg() );

	// ǥեͤȤơA4A3ξɲäƤ
	vPaperSize.clear();
	wPS.Name = "A4";
	wPS.width = 210.22410384;
	wPS.height = 297.30177879;
	vPaperSize.push_back( wPS );
	wPS.Name = "A3";
	wPS.width = 297.30177879;
	wPS.height = 420.44820768;
	vPaperSize.push_back( wPS );
}

// ץ̾ΰɤ߹
void CTaEditPrintDlg::ReadPrinterName()
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	string InFName;	// ϥե̾
	VClsPtr< CFilePtr > ppInfile;
	string LineStr;
	vector< string > vEntry;

	vPrinterName.clear();

	// printer.confեΥե̾
	InFName = pConf->RefPrintDlg_PrinterConfFileName();
	if ( InFName.empty() ) goto ERR_EXIT;

	// ե򳫤
	ppInfile = new CFilePtr( InFName.c_str(), "r" );
	if ( ppInfile.IsNull() || (*ppInfile).IsNull() ) goto ERR_EXIT;

	while( !feof( (*ppInfile) ) && !ferror( (*ppInfile) ) ) {
		// ɤ߹
		GlbFunc::ReadLine( (*ppInfile), &LineStr, '\n', true, '\\' );

		// Ƭζ
		LineStr = GlbFunc::Trim( LineStr, " \t\n", "" );

		// ԤɤФ
		if ( LineStr.empty() ) continue;

		// Ƭ#äɤФ
		if ( LineStr[0] == '#' ) continue;

		// :ǹԤʬ䤹
		vEntry = GlbFunc::DiviteString( LineStr, ':' );

		// ʬ䤷̤Ǥ0ĤʤɤФ
		if ( vEntry.empty() ) continue;

		// ƬǤ;ʬʶץ̾Ȥ
		vPrinterName.push_back( GlbFunc::Trim( vEntry[0], " \t\n", " \t\n" ) );
	}
	ppInfile = NULL;

	if ( !vPrinterName.empty() ) return ;

ERR_EXIT:

	// 顼åɽ
	m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToReadPrinterConfMsg() );

	// ɤ߹ߤ˼Ԥϡ_defaultɲäƤ
	vPrinterName.clear();
	vPrinterName.push_back( "_default" );
}

// ͤɤ߹
void CTaEditPrintDlg::GetDefaultValue()
{
	CONFMAN pCM = NULL;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	string InFName;	// ϥե̾
	const wchar_t *pV;

	// ƥ桼̤եɤ߹ߤߤ
	InFName = pConf->RefPrintDlg_ValueRegFile();
	if ( !InFName.empty() ) {
		// ꤵ줿ե̾ХѥǤʤäϡ
		// $HOMEХѥȸʤ
		if ( InFName[0] != '/' )
			InFName = GlbFunc::ResolvPath( InFName, getenv( "HOME" ) );
		pCM = confman_CreateConf( InFName.c_str() );
		if ( pCM ) {
			if ( !confman_Open( pCM ) ) {
				confman_Close( pCM );
				pCM = NULL;
			}
		}
	}

	// 桼̤ե뤬ɤʤäϡ
	// ƥǥեȤեɤ߹
	if ( !pCM ) {
		InFName = pConf->RefPrintDlg_DefaultValueRegFile();
		if ( InFName.empty() ) goto ERR_EXIT;

		pCM = confman_CreateConf( InFName.c_str() );
		if ( NULL == pCM ) goto ERR_EXIT;

		if ( !confman_Open( pCM ) ) goto ERR_EXIT;
	}

	// ͤ
	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_TargetPrinter );
	GlbFunc::WCStoMBS( pV, &TargetPrinter );

	exconf_GetInt( pCM, DF_SECTION, DF_PrintCount, &PrintCount );
	PrintCount = GlbFunc::CheckRange( PrintCount, 1, 128 );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_OutputFile );
	OutputFile = GlbFunc::WcsToBoolean( pV, false );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_OptFileName );
	GlbFunc::WCStoMBS( pV, &OptFileName );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_Size );
	GlbFunc::WCStoMBS( pV, &Size );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_Direction );
	Direction = GlbFunc::WcsToValue( pV, true, 2, L"Vertical", true, L"Horizontal", false );

	exconf_GetInt( pCM, DF_SECTION, DF_NUp, &NUp );
	if ( NUp != 1 && NUp != 2 && NUp != 4 ) NUp = 1;

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_Duplex );
	Duplex = GlbFunc::WcsToBoolean( pV, false );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_Font );
	GlbFunc::WCStoMBS( pV, &Font );

	exconf_GetInt( pCM, DF_SECTION, DF_FontSize, &FontSize );
	FontSize = GlbFunc::CheckRange( FontSize, 1, 256 );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_PrintLineNumber );
	PrintLineNumber = GlbFunc::WcsToBoolean( pV, false );

	exconf_GetInt( pCM, DF_SECTION, DF_TopSpace, &TopSpace );
	TopSpace = GlbFunc::CheckRange( TopSpace, 1, 65535 );

	exconf_GetInt( pCM, DF_SECTION, DF_BottomSpace, &BottomSpace );
	BottomSpace = GlbFunc::CheckRange( BottomSpace, 1, 65535 );

	exconf_GetInt( pCM, DF_SECTION, DF_LeftSpace, &LeftSpace );
	LeftSpace = GlbFunc::CheckRange( LeftSpace, 1, 65535 );

	exconf_GetInt( pCM, DF_SECTION, DF_RightSpace, &RightSpace );
	RightSpace = GlbFunc::CheckRange( RightSpace, 1, 65535 );

	exconf_GetInt( pCM, DF_SECTION, DF_HeaderPosition, &HeaderPosition );
	HeaderPosition = GlbFunc::CheckRange( HeaderPosition, 1, 65535 );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_HeaderLeft );
	GlbFunc::WCStoMBS( pV, &HeaderLeft );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_HeaderCenter );
	GlbFunc::WCStoMBS( pV, &HeaderCenter );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_HeaderRight );
	GlbFunc::WCStoMBS( pV, &HeaderRight );

	exconf_GetInt( pCM, DF_SECTION, DF_FooterPosition, &FooterPosition );
	FooterPosition = GlbFunc::CheckRange( FooterPosition, 1, 65535 );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_FooterLeft );
	GlbFunc::WCStoMBS( pV, &FooterLeft );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_FooterCenter );
	GlbFunc::WCStoMBS( pV, &FooterCenter );

	pV = exconf_GetConstStr( pCM, DF_SECTION, DF_FooterRight );
	GlbFunc::WCStoMBS( pV, &FooterRight );

ERR_EXIT:
	if ( NULL != pCM ) confman_Delete( pCM );
	pCM = NULL;
}

// Ƥ¸
void CTaEditPrintDlg::SaveDefaultValue()
{
	CONFMAN pCM = NULL;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	string InFName;	// ϥե̾
	const wchar_t *pV;
	wstring wStr;

	// 桼̤եΥե̾
	// ʻꤵ줿ե̾ХѥǤʤäϡ
	// $HOMEХѥȸʤ
	InFName = pConf->RefPrintDlg_ValueRegFile();
	if ( InFName.empty() ) return ;
	if ( InFName[0] != '/' )
		InFName = GlbFunc::ResolvPath( InFName, getenv( "HOME" ) );

	// 桼̤ե򳫤
	pCM = confman_CreateConf( InFName.c_str() );
	if ( !pCM ) return ;

	// ɲ
	if ( !confman_AddSection( pCM, DF_SECTION ) ) goto ERR_EXIT;

	// ͤɲ
	if ( !GlbFunc::MBStoWCS( TargetPrinter.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_TargetPrinter, wStr.c_str() ) ) goto ERR_EXIT;

	if ( !confman_AddKeyInteger( pCM, DF_SECTION, DF_PrintCount, PrintCount ) ) goto ERR_EXIT;

	pV = GlbFunc::TranslateValue( OutputFile, L"False", 2, true, L"True", false, L"False" );
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_OutputFile, pV ) ) goto ERR_EXIT;

	if ( !GlbFunc::MBStoWCS( OptFileName.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_OptFileName, wStr.c_str() ) ) goto ERR_EXIT;

	if ( !GlbFunc::MBStoWCS( Size.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_Size, wStr.c_str() ) ) goto ERR_EXIT;

	pV = GlbFunc::TranslateValue( Direction, L"Vertical", 2, true, L"Vertical", false, L"Horizontal" );
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_Direction, pV ) ) goto ERR_EXIT;

	if ( !confman_AddKeyInteger( pCM, DF_SECTION, DF_NUp, NUp ) ) goto ERR_EXIT;

	pV = GlbFunc::TranslateValue( Duplex, L"False", 2, true, L"True", false, L"False" );
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_Duplex, pV ) ) goto ERR_EXIT;

	if ( !GlbFunc::MBStoWCS( Font.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_Font, wStr.c_str() ) ) goto ERR_EXIT;

	if ( !confman_AddKeyInteger( pCM, DF_SECTION, DF_FontSize, FontSize ) ) goto ERR_EXIT;

	pV = GlbFunc::TranslateValue( PrintLineNumber, L"False", 2, true, L"True", false, L"False" );
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_PrintLineNumber, pV ) ) goto ERR_EXIT;

	if ( !confman_AddKeyInteger( pCM, DF_SECTION, DF_TopSpace, TopSpace ) ) goto ERR_EXIT;

	if ( !confman_AddKeyInteger( pCM, DF_SECTION, DF_BottomSpace, BottomSpace ) ) goto ERR_EXIT;

	if ( !confman_AddKeyInteger( pCM, DF_SECTION, DF_LeftSpace, LeftSpace ) ) goto ERR_EXIT;

	if ( !confman_AddKeyInteger( pCM, DF_SECTION, DF_RightSpace, RightSpace ) ) goto ERR_EXIT;

	if ( !confman_AddKeyInteger( pCM, DF_SECTION, DF_HeaderPosition, HeaderPosition ) ) goto ERR_EXIT;

	if ( !GlbFunc::MBStoWCS( HeaderLeft.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_HeaderLeft, wStr.c_str() ) ) goto ERR_EXIT;

	if ( !GlbFunc::MBStoWCS( HeaderCenter.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_HeaderCenter, wStr.c_str() ) ) goto ERR_EXIT;

	if ( !GlbFunc::MBStoWCS( HeaderRight.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_HeaderRight, wStr.c_str() ) ) goto ERR_EXIT;

	if ( !confman_AddKeyInteger( pCM, DF_SECTION, DF_FooterPosition, FooterPosition ) ) goto ERR_EXIT;

	if ( !GlbFunc::MBStoWCS( FooterLeft.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_FooterLeft, wStr.c_str() ) ) goto ERR_EXIT;

	if ( !GlbFunc::MBStoWCS( FooterCenter.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_FooterCenter, wStr.c_str() ) ) goto ERR_EXIT;

	if ( !GlbFunc::MBStoWCS( FooterRight.c_str(), &wStr ) ) goto ERR_EXIT;
	if ( !confman_AddKeyString( pCM, DF_SECTION, DF_FooterRight, wStr.c_str() ) ) goto ERR_EXIT;

	// ͤե¸
	confman_Save( pCM );

ERR_EXIT:
	confman_Delete( pCM );
	pCM = NULL;
}

// Ĥ
void CTaEditPrintDlg::OnClose( Widget argWgt, XtPointer user_data )
{

}

// 
void CTaEditPrintDlg::OnMap( Widget argWgt, XtPointer user_data )
{
	SetTab( 1 );
}

// OKܥβ
void CTaEditPrintDlg::OnOK( Widget argWgt, XtPointer user_data )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	int i;

	// ƥåȤϤ줿ͤ
	if ( !GetValuesToWidget() ) {
		// ͤѹԤ줿
		int r = m_TaEditShell->ShowQuestionMsgBox( pConf->RefPrintDlgWrongValueMsg(), true );
		switch ( r ) {
		case 1:	// Yes
			// ֤Ϥפξ³Ԥ
			break;
		case 2:	// No
			// ֤פξϡǤϤԤ
			return ;
			break;
		case 3:	// Cancel
			// ֥󥻥פξϥĤ
			m_ModalDlg.ExitModal();
			return ;
			break;
		}
	}

	// Ϥ줿ƤǥեͤȤ¸
	SaveDefaultValue();

	// OKܥ󤬲콪λ줿Ȥ¸
	IsOK = true;

	// ץ󥿤̾ǧ
	if ( !OutputFile ){
		// ץ̾ΰ椫顢Ϥ줿ͤ򸡺
		for ( i = 0; i < vPrinterName.size(); i++ ) {
			if ( vPrinterName[i] == TargetPrinter ) break;
		}
		// ĤʤХ顼Ȥ
		if ( i >= vPrinterName.size() ) {
			m_TaEditShell->ShowErrorMsgBox( pConf->RefTargetPrinterNameIsInvalidMsg() );
			return ;
		}
	}

	// ѻ極Ϥݤǧ
	for ( i = 0; i < vPaperSize.size() && vPaperSize[i].Name != Size; i++ );
	if ( i >= vPaperSize.size() ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefPaperSizeIsInvalidMsg() );
		return ;
	}

	// 
	Print();

	// ⡼νλ
	m_ModalDlg.ExitModal();
}

// 󥻥ܥβ
void CTaEditPrintDlg::OnCancel( Widget argWgt, XtPointer user_data )
{
	// ⡼νλ
	m_ModalDlg.ExitModal();
}

// ֥ץ󥿡ץܥβ
void CTaEditPrintDlg::OnTabPrinter( Widget argWgt, XtPointer user_data )
{
	SetTab( 1 );
}

// ѻץܥβ
void CTaEditPrintDlg::OnTabForm( Widget argWgt, XtPointer user_data )
{
	SetTab( 2 );
}

// ֥ƥȡץܥβ
void CTaEditPrintDlg::OnTabText( Widget argWgt, XtPointer user_data )
{
	SetTab( 3 );
}

// ;ץܥβ
void CTaEditPrintDlg::OnTabSpace( Widget argWgt, XtPointer user_data )
{
	SetTab( 4 );
}

// ֥إåץܥβ
void CTaEditPrintDlg::OnTabHeader( Widget argWgt, XtPointer user_data )
{
	SetTab( 5 );
}

// ֥եåץܥβ
void CTaEditPrintDlg::OnTabFooter( Widget argWgt, XtPointer user_data )
{
	SetTab( 6 );
}

// ڡѹ
void CTaEditPrintDlg::OnPageChange( Widget argWgt, XtPointer user_data )
{
	int ac = 0;
	Arg al[3];
	int cp;

	// 桼ˤʤڡѹǤСʤ
	if ( PageChangeByProg ) return ;

	// ߤΥڡ
	XtSetArg( al[ac], XmNcurrentPageNumber, &cp ); ac++;
	XtGetValues( m_PrintTabManager, al, ac );

	SetTab( cp );
}

// ꤵ줿֤򤹤
void CTaEditPrintDlg::SetTab( int idx )
{
	int ac = 0;
	Arg al[3];
	int i;
	Widget vwTabBtn[] = {
		m_PrintPrinterTabBtn, m_PrintFormTabBtn , m_PrintTextTabBtn,
		m_PrintSpaceTabBtn, m_PrintHeaderTabBtn, m_PrintFooterTabBtn
	};

	// ̤ڤؤ
	PageChangeByProg = true;	// OnPageChangeμ¹Ԥ޻ߤ
	XtSetArg( al[ac], XmNcurrentPageNumber, idx ); ac++;
	XtSetValues( m_PrintTabManager, al, ac );
	PageChangeByProg = false;

	// ܥαѤ
	for ( i = 0; i < TAB_BTN_CNT; i++ ) {
		ac = 0;
		if ( i != ( idx - 1 ) )
			XtSetArg(al[ac], XmNshadowThickness, TabBtnShadowTickness[i] );
		else
			XtSetArg(al[ac], XmNshadowThickness, 0 );
		ac++;
		XtSetValues( vwTabBtn[i], al, ac );
	}
}


// ѤΥܥανͤ
void CTaEditPrintDlg::GetDefaultShadowTickness()
{
	int ac = 0;
	Arg al[2];
	int i;
	int w;
	Widget vwTabBtn[] = {
		m_PrintPrinterTabBtn, m_PrintFormTabBtn , m_PrintTextTabBtn,
		m_PrintSpaceTabBtn, m_PrintHeaderTabBtn, m_PrintFooterTabBtn
	};

	for ( i = 0; i < TAB_BTN_CNT; i++ ) {
		ac = 0;
		XtSetArg( al[ac], XmNshadowThickness, TabBtnShadowTickness + i );
		ac++;
		XtGetValues( vwTabBtn[i], al, ac );
		printf( "%d : %d\n", i, TabBtnShadowTickness[i] );
	}
}

// ե̾ܥ...ˤβ
void CTaEditPrintDlg::OnPrintPrinterOptFNameIptBtn( Widget argWgt, XtPointer user_data )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	char *wp = NULL;

	// ե˥ȥꤹ
	m_FileSelectShell->SetDlgTitle( pConf->RefFileSaveDlgTitle(), false, false );

	// եΥ󥳡ɤꤹ
	// ʸ߳ƤեΥ󥳡ɤǥեͤȤ
	m_FileSelectShell->SetDefaultEncodeInfo( pDoc->GetEncodeInfo() );

	// եɽ
	if ( !m_FileSelectShell->ShowDlg() )
		return ;

	// ե̾ɽ륦åȤˡ
	// ե̾ꤹ
	wp = (char*)alloca( sizeof( char ) * ( m_FileSelectShell->GetSelectedFileName().length() + 3 ) );
	strcpy( wp, m_FileSelectShell->GetSelectedFileName().c_str() );
	XmTextFieldSetString( m_PrintPrinterOptFileFName, wp );
}

// ͤΤߤϤƥȥեɤϥå
void CTaEditPrintDlg::OnNumEditModifyVerify( Widget argWgt, XtPointer user_data )
{
	XmTextVerifyCallbackStruct *p = NULL;
	int i = 0;

	p = reinterpret_cast< XmTextVerifyCallbackStruct* >( user_data );

	// ʳʸϤƤʤȤǧ
	for ( i = 0; i < p->text->length; i++ ) {
		char c = p->text->ptr[i];
		if ( c < '0' || c > '9' ) break;
	}

	if ( i < p->text->length ) {
		// ʳʸϤƤ
		p->doit = False;
	}
}

// PostScript
bool CTaEditPrintDlg::Print() const
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CProcStart PS_PdlGen;	// TaEditPdlGen
	int i = 0;
	VClsPtr< CFilePtr > ppInputData;
	VClsPtr< CFilePtr > ppHFData;

	assert( NULL != this );

	// TaEditPdlGenؤϥǡ
	if ( !CreateIptData( &ppInputData, &ppHFData ) ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToGenPSMsg() );
		return false;
	}

	// TaEditPdlGenѤPS_PdlGenꤹ
	if ( !SetupPS_PdlGen( &PS_PdlGen, ppHFData ) ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToGenPSMsg() );
		return false;
	}

	if ( !OutputFile )
		return Print_OutputPrinter( &PS_PdlGen, ppInputData );
	else
		return Print_OutputFile( &PS_PdlGen, ppInputData );
}

// ץ󥿤˽Ϥ
bool CTaEditPrintDlg::Print_OutputPrinter( CProcStart *pPS_PdlGen, VClsPtr< CFilePtr > ppInputData ) const
{
	assert( NULL != this );
	assert( NULL != pPS_PdlGen );
	assert( !ppInputData.IsNull() );
	assert( !(*ppInputData).IsNull() );

	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	VClsPtr< CFilePtr > ppPipeIn;	// ѥѡʥѥפ¦
	VClsPtr< CFilePtr > ppPipeOut;	// ѥѡʥѥפؤν¦
	VClsPtr< CFilePtr > ppErrPipeIn;	// 顼åΥѥ
	VClsPtr< CFilePtr > ppErrPipeOut;	// 顼åΥѥ
	CProcStart PS_LprGen;	// lpr
	int PdlGenStatus;	// TaEditPdlGenμ¹Է
	int LprStatus;	// lprμ¹Է
	bool r = false;	// 

	// lprѤPS_LprGenꤹ
	if ( !SetupPS_Lpr( &PS_LprGen ) ) return false;

	// ѥפ
	if ( !GlbFunc::CreatePipeByFilePtr( &ppPipeIn, "rb", &ppPipeOut, "wb"  ) ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToGenPSMsg() );
		return false;
	}

	// 顼åѤΥѥפ
	if ( !GlbFunc::CreatePipeByFilePtr( &ppErrPipeIn, "rb", &ppErrPipeOut, "wb"  ) ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToGenPSMsg() );
		return false;
	}

	// TaEditPdlGenˤϡɸϤǡϤ
	pPS_PdlGen->AddAssignFile( stdin, (*ppInputData) );

	// TaEditPdlGenˤϡϥǡɸϤȤƥѥפν񤭹¦˽Ϥ롣
	pPS_PdlGen->AddAssignFile( stdout, (*ppPipeOut) );

	// PostScriptץư
	// ѥפդˤʤȽߤ뤿ᡢ
	// ץνλԤ碌뤳ȤϤǤʤ
	PdlGenStatus = pPS_PdlGen->Start();
	if ( PdlGenStatus < 0 ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToStartPdlGenMsg() );
		return false;
	}

	// ѥפؤν񤭹¦ĤĤʤlpλʤ
	ppPipeOut = NULL;

	// lprˤϡϥǡɸϤȤƥѥפɤ߹ޤ롣
	PS_LprGen.AddAssignFile( stdin, (*ppPipeIn) );

	// lprɸ२顼Ϥ˽Ϥ륨顼åϡѥפ˽񤭹ޤ롣
	PS_LprGen.AddAssignFile( stderr, (*ppErrPipeOut) );

	// lprޥɤư
	LprStatus = PS_LprGen.StartWait();
	if ( LprStatus < 0 ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToStartLprMsg() );
		return false;
	}

	if ( LprStatus != 0 ) {
		// ԤåȤɽ
		string err_msg;
		CCompoundStr msg;
		char c = 0;

		// ѥפؤν񤭹¦Ĥ
		ppErrPipeOut = NULL;

		// 顼åɤ߹
		c = fgetc( (*ppErrPipeIn) );
		while ( c != EOF && !ferror( (*ppErrPipeIn) ) && !feof( (*ppErrPipeIn) ) ) {
			err_msg += c;
			c = fgetc( (*ppErrPipeIn) );
		}

		// ˲ԥɤ硢ɽˤʤΤǼ
		err_msg = GlbFunc::Trim( err_msg, "\n", "\n" );

		// åɽ
		pConf->GetFailedToLprMsgWithStatus( &msg, LprStatus, err_msg.c_str() );
		m_TaEditShell->ShowErrorMsgBox( msg );
		return false;
	}

	return true;
}

// ե˽Ϥ
bool CTaEditPrintDlg::Print_OutputFile( CProcStart *pPS_PdlGen, VClsPtr< CFilePtr > ppInputData ) const
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	VClsPtr< CFilePtr > ppTargetFile;	// 
	int PdlGenStatus = 0;		// TaEditPdlgenμ¹Է
	bool r = false;				// 

	assert( NULL != this );
	assert( NULL != pPS_PdlGen );
	assert( !ppInputData.IsNull() );
	assert( !( (*ppInputData).IsNull() ) );

	// ե̾ϤƤ뤫ݤ
	if ( OptFileName.empty() ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFileNameIsNotInputtedErrorMsg() );
		return false;
	}

	// ե򳫤
	ppTargetFile = new CFilePtr( OptFileName.c_str(), "w" );
	if ( ppTargetFile.IsNull() || (*ppTargetFile).IsNull() ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFaultFileOpenMsg() );
		return false;
	}

	// TaEditPdlGenˤɸϤǡɤ߹ޤ
	pPS_PdlGen->AddAssignFile( stdin, (*ppInputData) );

	// TaEditPdlGenˤϽϥǡɸϤȤƽե˽Ϥ롣
	pPS_PdlGen->AddAssignFile( stdout, (*ppTargetFile) );

	// PostScriptץư
	PdlGenStatus = pPS_PdlGen->StartWait();
	if ( PdlGenStatus < 0 ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToStartPdlGenMsg() );
		return false;
	}

	// ۾ｪλ顢ߤ
	if ( PdlGenStatus != 0 ) {
		CCompoundStr msg;
		pConf->GetFailedToGenPSMsgWithStatus( &msg, PdlGenStatus );
		m_TaEditShell->ShowErrorMsgBox( msg );
		return false;
	}
	return true;
}

// TaEditPdlgenѤCProcStartꤹ
// pHFDataƬ6ԤˤϥإåեåȤƻѤʸ󤬵ҤƤ
bool CTaEditPrintDlg::SetupPS_PdlGen( CProcStart *pPS, VClsPtr< CFilePtr > ppHFData ) const
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const char *PdlGenPrg = NULL;
	double Width = 0.0;
	double Height = 0.0;
	string wHeaderLeft;
	string wHeaderCenter;
	string wHeaderRight;
	string wFooterLeft;
	string wFooterCenter;
	string wFooterRight;

	assert( NULL != this );
	assert( NULL != pPS );
	assert( !ppHFData.IsNull() );
	assert( !(*ppHFData).IsNull() );

	// ѻΥ
	if ( !GetPaperSize( &Width, &Height ) )
		return false;

	// PostScriptץΥѥ̾
	PdlGenPrg = getenv( SCEV_PDLGEN_PATH );
	if ( !PdlGenPrg ) {
		// TaEditPdlGenΥѥ̾Ǥʤ
		m_TaEditShell->ShowErrorMsgBox( pConf->RefPdlGenNameIsInvalidMsg() );
		return false;
	}

	// PostScriptץΥѥ̾ꤹ
	if ( !pPS->SpecifyCommand( PdlGenPrg ) ) {
		// ꤵ줿TaEditPdlGenϼ¹ԤǤʤ
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToStartPdlGenMsg() );
		return false;
	}

	// إåեåȤƻѤʸ
	if ( !GlbFunc::ReadLine( (*ppHFData), &wHeaderLeft ) ) return false;
	if ( !GlbFunc::ReadLine( (*ppHFData), &wHeaderCenter ) ) return false;
	if ( !GlbFunc::ReadLine( (*ppHFData), &wHeaderRight ) ) return false;
	if ( !GlbFunc::ReadLine( (*ppHFData), &wFooterLeft ) ) return false;
	if ( !GlbFunc::ReadLine( (*ppHFData), &wFooterCenter ) ) return false;
	if ( !GlbFunc::ReadLine( (*ppHFData), &wFooterRight ) ) return false;

	// PostScriptץΰꤹ
	pPS->AddArg( "-PageWidth" );
	pPS->AddArg( Width );
	pPS->AddArg( "-PageHeight" );
	pPS->AddArg( Height );
	pPS->AddArg( "-NUp" );
	pPS->AddArg( NUp );
	pPS->AddArg( "-HeaderPosition" );
	pPS->AddArg( HeaderPosition );
	pPS->AddArg( "-LeftHeader" );
	pPS->AddArg( wHeaderLeft );
	pPS->AddArg( "-CenterHeader" );
	pPS->AddArg( wHeaderCenter );
	pPS->AddArg( "-RightHeader" );
	pPS->AddArg( wHeaderRight );
	pPS->AddArg( "-FooterPosition" );
	pPS->AddArg( FooterPosition );
	pPS->AddArg( "-LeftFooter" );
	pPS->AddArg( wFooterLeft );
	pPS->AddArg( "-CenterFooter" );
	pPS->AddArg( wFooterCenter );
	pPS->AddArg( "-RightFooter" );
	pPS->AddArg( wFooterRight );
	pPS->AddArg( "-TopMargin" );
	pPS->AddArg( TopSpace );
	pPS->AddArg( "-LeftMargin" );
	pPS->AddArg( LeftSpace );
	pPS->AddArg( "-RightMargin" );
	pPS->AddArg( RightSpace );
	pPS->AddArg( "-BottomMargin" );
	pPS->AddArg( BottomSpace );
	pPS->AddArg( "-FontName" );
	pPS->AddArg( Font );
	pPS->AddArg( "-TextHeight" );
	pPS->AddArg( FontSize );
	pPS->AddArg( "-TextWidth" );
	pPS->AddArg( FontSize );
	pPS->AddArg( "-LineMargin" );
	pPS->AddArg( 0 );
	pPS->AddArg( "-TabWidth" );
	pPS->AddArg( pConf->RefTabWidth() );
	if ( !Direction )
		pPS->AddArg( "-Turn" );
	if ( PrintLineNumber )
		pPS->AddArg( "-ShowLineNumber" );
	if ( Duplex )
		pPS->AddArg( "-Duplex" );
	return true;
}

// lprѤCProcStartꤹ
bool CTaEditPrintDlg::SetupPS_Lpr( CProcStart *pPS ) const
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const char *LprPrg = NULL;
	vector< string > LprArgList;	// lprΰ
	int i = 0;

	// ޥɤΥѥ̾
	LprPrg = getenv( SCEV_LPR_PATH );
	if ( !LprPrg ) {
		// lprޥɤ
		m_TaEditShell->ShowErrorMsgBox( pConf->RefLprNameIsInvalidMsg() );
		return false;
	}

	// ޥɤΰ
	LprArgList = GetLprArg();

	// lprޥɤΥѥ̾ꤹ
	if ( !pPS->SpecifyCommand( LprPrg ) ) {
		// ꤵ줿lprϼ¹ԤǤʤ
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFailedToStartLprMsg() );
		return false;
	}

	// lprޥɤؤΰꤹ
	for ( i = 0; i < LprArgList.size(); i++ )
		pPS->AddArg( LprArgList[i] );

	return true;
}

// lprΰ
vector< string > CTaEditPrintDlg::GetLprArg() const
{
	assert( this );

	vector< string > v1;
	string w;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const string &rArg = pConf->RefPrintDlg_lpr_Args();
	int i, j;
	char PrintCount_str[17] = { 0 };

	// ʸ󲽤
	snprintf( PrintCount_str, 16, "%d", PrintCount );

	w = "";
	v1.clear();
	i = 0;
	while ( i < rArg.length() ) {
		if ( rArg[i] == '%' ) {
			if ( i == rArg.length() - 1 ) {
				// %ä%ʸϤ
				w += '%';
				break;
			}
			else {
				i++;
				switch ( rArg[i] ) {
				case '%':
					// %%%ʸִ
					w += '%';
					break;
				case '1':
					// %1ʸʬ䤷ǥץִ̾
					v1.push_back( GlbFunc::Trim( w, " \t", " \t" ) );
					w = "";
					v1.push_back( TargetPrinter );
					break;
				case '2':
					// %2ʸʬ䤷ǰִ
					v1.push_back( GlbFunc::Trim( w, " \t", " \t" ) );
					w = "";
					v1.push_back( PrintCount_str );
					break;
				default:
					// ʸפƤ顢Τޤ޽Ϥ
					w += '%';
					w += rArg[i];
					break;
				}
			}
		}
		else {
			w += rArg[i];
		}
		i++;
	}

	// wˤޤäƤĤʸv1ꤹ
	if ( !w.empty() )
		v1.push_back( GlbFunc::Trim( w, " \t", " \t" ) );

	return v1;
}

// ѻ極
bool CTaEditPrintDlg::GetPaperSize( double *pW, double *pH ) const
{
	assert( this && pW && pH );

	int i;

	// 򤵤줿ѻξ򸡺
	for ( i = 0; i < vPaperSize.size() && vPaperSize[i].Name != Size; i++ );
	if ( i >= vPaperSize.size() ) return false;

	// ѻθ˹碌Ʒ̤֤
	if ( Direction ) {
		(*pW) = vPaperSize[i].width;
		(*pH) = vPaperSize[i].height;
	}
	else {
		(*pW) = vPaperSize[i].height;
		(*pH) = vPaperSize[i].width;
	}

	return true;
}

// TaEditPdlGenϤǡݻե֤
// pppIptDataˤϡTaEditPdlGenɸϤɤ߹ǡꤹ롣
// pppHFStrˤϥإåեåǻѤʸꤹ롣
bool CTaEditPrintDlg::CreateIptData( VClsPtr< CFilePtr > *pppIptData, VClsPtr< CFilePtr > *pppHFStr ) const
{
	VClsPtr< CFilePtr > ppDataTmpFile;	// ƥΤǼƥݥΥե
	VClsPtr< CFilePtr > ppHFTmpFile;		// إåեåǼƥݥΥե
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	const T_LineData *pLD = NULL;
	T_LineDataItr_c itr;
	int i = 0;

	assert( pppIptData && pppHFStr );

	(*pppIptData) = NULL;
	(*pppHFStr) = NULL;

	// ƥݥΥե
	ppDataTmpFile = new CFilePtr();
	if ( ppDataTmpFile.IsNull() ) return false;
	if ( !(*ppDataTmpFile).OpenTmp() ) return false;
	ppHFTmpFile = new CFilePtr();
	if ( ppHFTmpFile.IsNull() ) return false;
	if ( !(*ppHFTmpFile).OpenTmp() ) return false;

	// ƥݥΥեˡإåեåʸ񤭹
	fprintf( (*ppHFTmpFile), "%s\n", CreateHFString( HeaderLeft ).c_str() );
	fprintf( (*ppHFTmpFile), "%s\n", CreateHFString( HeaderCenter ).c_str() );
	fprintf( (*ppHFTmpFile), "%s\n", CreateHFString( HeaderRight ).c_str() );
	fprintf( (*ppHFTmpFile), "%s\n", CreateHFString( FooterLeft ).c_str() );
	fprintf( (*ppHFTmpFile), "%s\n", CreateHFString( FooterCenter ).c_str() );
	fprintf( (*ppHFTmpFile), "%s\n", CreateHFString( FooterRight ).c_str() );
	if ( ferror( (*ppHFTmpFile) ) ) return false;

	// ƥΤƥݥΥե˽񤭹
	pLD = &( pDoc->RefData() );
	itr = pLD->begin();
	while ( itr != pLD->end() && !ferror( (*ppDataTmpFile) ) ) {
		// ʸϤ
		for ( i = 0; i < itr->length(); i++ ) {
			fputwc( (*itr)[i].moji, (*ppDataTmpFile) );
		}
		itr++;
		// ǸιԤǤʤϡԥɤϤ
		if ( itr != pLD->end() )
			fputwc( L'\n', (*ppDataTmpFile) );
	}
	if ( ferror( (*ppDataTmpFile) ) ) return false;

	// ݥ󥿤եƬ˰ư
	if ( fflush( (*ppHFTmpFile) ) ) return false;
	if ( fseek( (*ppHFTmpFile), 0, SEEK_SET ) ) return false;
	if ( fflush( (*ppDataTmpFile) ) ) return false;
	if ( fseek( (*ppDataTmpFile), 0, SEEK_SET ) ) return false;

	// 󥳡ɤѴ
	(*pppIptData) = TranseEncode( ppDataTmpFile );
	if ( (*pppIptData).IsNull() ) return false;

	(*pppHFStr) = TranseEncode( ppHFTmpFile );
	if ( (*pppHFStr).IsNull() ) return false;

	return true;
}

// ե뤫ǡϤ󥳡ѴԤä̤ݻե֤
VClsPtr< CFilePtr > CTaEditPrintDlg::TranseEncode( VClsPtr< CFilePtr > ppData ) const
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CProcStart ConvProc;	// ʸѴ
	string InputEncode;
	string OutputEncode;
	const char *pConvPath = NULL;
	VClsPtr< CFilePtr > ppPipeIn;	// TaEditConvνϤ˻Ѥѥס¦
	VClsPtr< CFilePtr > ppPipeOut;	// TaEditConvνϤ˻Ѥѥסʽ¦
	int i = 0;
	int pid = 0;
	int status = 0;

	// ʸѴץΥѥ
	// PostScriptǤϥեԹ塢ȥΥ󥳡ɤȤ
	// ۤʤʸɤѤǽ
	pConvPath = getenv( SCEV_CONVERTER_PATH );
	if ( NULL == pConvPath ) return NULL;

	// 󥳡̾
	InputEncode = nl_langinfo( CODESET );
	OutputEncode = pConf->RefPrintDlg_PostScriptEncode();

	// ѴѤΥޥɤ
	if ( !ConvProc.SpecifyCommand( pConvPath ) ) return NULL;
	ConvProc.AddArg( "-ifc" );
	ConvProc.AddArg( InputEncode );
	ConvProc.AddArg( "-ofc" );
	ConvProc.AddArg( OutputEncode );
	ConvProc.AddArg( "-c" );
	ConvProc.AddArg( "LF" );
	ConvProc.AddArg( "-t" );

	// ʸѴץ˥ǡϤ˻Ѥѥפ
	if ( !GlbFunc::CreatePipeByFilePtr( &ppPipeIn, "rb", &ppPipeOut, "wb"  ) )
		return NULL;

	// TaEditConvˤϡͿ줿ǡɸϤɤ߹ޤ롣
	ConvProc.AddAssignFile( stdin, (*ppData) );

	// TaEditConvˤϡϥǡɸϤȤƥѥפ˽񤭹ޤ롣
	ConvProc.AddAssignFile( stdout, (*ppPipeOut) );

	// ʸѴץư
	pid = ConvProc.Start();
	if ( pid < 0 ) return NULL;

	// ѥפɤ߹¦֤
	return ppPipeIn;
}

// إåեåʸ
// %f : ե̾
// %F : եѥΥե̾
// %Y : ǯ
// %M : 
// %D : 
// %h : 
// %m : ʬ
// %s : 
// %p : %p
// %% : %%
string CTaEditPrintDlg::CreateHFString( const string &r ) const
{
	map< char, string > dict;
	char buf[ 32 ] = { 0 };
	struct tm tm1;
	time_t t1 = time( NULL );
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	const string &rFileName = pDoc->GetFileName();
	string wstr;	// rԥɤʸ
	int i;

	// 
	localtime_r( &t1, &tm1 );

	// ʸ󲽤Ƽɲä
	snprintf( buf, sizeof( buf ), "%04d", tm1.tm_year + 1900 );
	dict.insert( pair< char, string >( 'Y', buf ) );
	snprintf( buf, sizeof( buf ), "%02d", tm1.tm_mon + 1 );
	dict.insert( pair< char, string >( 'M', buf ) );
	snprintf( buf, sizeof( buf ), "%02d", tm1.tm_mday );
	dict.insert( pair< char, string >( 'D', buf ) );
	snprintf( buf, sizeof( buf ), "%02d", tm1.tm_hour );
	dict.insert( pair< char, string >( 'h', buf ) );
	snprintf( buf, sizeof( buf ), "%02d", tm1.tm_min );
	dict.insert( pair< char, string >( 'm', buf ) );
	snprintf( buf, sizeof( buf ), "%02d", tm1.tm_sec );
	dict.insert( pair< char, string >( 's', buf ) );

	if ( rFileName.empty() ) {
		// ե̾ʤ
		const wstring& NewFileTitleStr = pConf->RefNewFileWndTitleStr();
		string NewFileTitleStr_mb;
		if ( GlbFunc::WCStoMBS( NewFileTitleStr.c_str(), &NewFileTitleStr_mb ) )
			dict.insert( pair< char, string >( 'f', NewFileTitleStr_mb ) );
	}
	else {
		// ե̾򼭽ɲ
		dict.insert( pair< char, string >( 'F', rFileName ) );
		dict.insert( pair< char, string >( 'f', GlbFunc::GetFileNameFromFullPathName( rFileName ) ) );
	}

	// %pϤΤޤ޽ϤPostScriptǷ׻뤿
	dict.insert( pair< char, string >( 'p', "%p" ) );

	// %%ϤΤޤ޽ϤPostScriptץब׽뤿
	dict.insert( pair< char, string >( '%', "%%" ) );

	// Ϥ줿ʸ˲ԥɤޤޤƤʤȤݾڤ
	wstr.reserve( r.length() );
	for ( i = 0; i < r.length(); i++ ) {
		if ( r[i] != '\n' )
			wstr += r[i];
	}

	// ʸѴԤ
	return GlbFunc::ExpandEscapedString( wstr, dict, '%' );
}

