///////////////////////////////////////////////////////////////////////////
// KeywordFinder.h
// ɤΥꥹȤ椫顢ɤθԤ
///////////////////////////////////////////////////////////////////////////

#if !defined( KEYWORDFINDER_H_INCLUDED_ )
#define KEYWORDFINDER_H_INCLUDED_

#include <assert.h>
#include <vector>
#include <string>

// ϤASCIIɤѤƤ뤫ݤ
#define LANGEXT_IS_ASCII 1

namespace NLangExt {

template < typename T_Char, bool IsSensitive = true >
class CKeywordFinder
{
public:
	CKeywordFinder( const std::vector< std::wstring > *argpVec )
		: pKeywordVec( argpVec ), CharCnt( 0 ), s( 0 ), e ( 0 )
	{
		if ( argpVec ) e = argpVec->size();
	};
private:
	// ʸӤ
	int CompareChar( T_Char c1, T_Char c2 ) const
	{
		if ( IsSensitive )
			return c1 - c2;
		else {

#if LANGEXT_IS_ASCII
			if ( c1 >= T_Char( 'a' ) && c1 <= T_Char( 'z' ) )
				c1 &= 0xDF;
			if ( c2 >= T_Char( 'a' ) && c2 <= T_Char( 'z' ) )
				c2 &= 0xDF;
			return c1 - c2;
#else
			const char *pLC = "abcdefghijklmnopqrstuvwxyz";
			const char *pBC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			int i;
			T_Char wc1, wc2;
			for ( i = 0; i < 26 && c1 != T_Char( pLC[i] ); i++ );
			if ( i >= 26 )
				wc1 = c1;
			else
				wc1 = T_Char( pBC[i] );
			for ( i = 0; i < 26 && c2 != T_Char( pLC[i] ); i++ );
			if ( i >= 26 )
				wc2 = c2;
			else
				wc2 = T_Char( pBC[i] );
			return wc1 == wc2;
#endif
		}
	}

	// ʸɲäˤ롢ɤθõ)
	int AddChar_Search( T_Char c ) const
	{
		int L = s;
		int H = e;
		int M;
		while ( L < H ){
			M = ( L + H ) / 2;
			int r = CompareChar( (*pKeywordVec)[M][CharCnt], c );
			if ( r == 0 ) return M;
			if ( r > 0 )
				H = M;
			else
				L = M + 1;
		}
		return -1;
	}

	// ʸɲäˤ롢ɤϰϤθʻ
	int AddChar_LowerBound( T_Char c ) const
	{
		int r = AddChar_Search( c );
		if ( r < 0 ) return -1;
		while ( r >= s && CompareChar( (*pKeywordVec)[r][CharCnt], c ) == 0 )
			r--;
		return r + 1;
	}

	// ʸɲäˤ롢ɤϰϤθʽ
	int AddChar_UpperBound( T_Char c ) const
	{
		int r = AddChar_Search( c );
		if ( r < 0 ) return -1;
		while ( r < e && CompareChar( (*pKeywordVec)[r][CharCnt], c ) == 0 )
			r++;
		return r;
	}
public:
	// ʸɲäɤϰϤꤹ
	void AddChar( T_Char c )
	{
		int sr, er;

		assert( NULL != this );
		if ( NULL == pKeywordVec ) return ;
		if ( pKeywordVec->empty() ) return ;

		if ( s >= 0 && e >= 0 && s < e ) {
			sr = AddChar_LowerBound( c );
			er = AddChar_UpperBound( c );
			if ( sr < 0 )
				s = -1;
			else
				s = sr;
			if ( er < 0 )
				e = -2;
			else
				e = er;
		}
/*
		// ʤ
		for (; s < e && s < pKeywordVec->size() && !CompareChar( (*pKeywordVec)[s][CharCnt], c ); s++ );
		// ʤ
		for ( e-- ; e > s && e > 0 && !CompareChar( (*pKeywordVec)[e][CharCnt], c ); e-- );
		e++;
*/
		CharCnt++;
	};

	// ɤĤäݤ
	bool IsFound() const
	{
		assert( NULL != this );

		// ꥹȤʤ鸫Ĥ褦ʤ
		if ( NULL == pKeywordVec ) return false;
		if ( pKeywordVec->empty() ) return false;

		// Τ̵ͭȽ
		if ( s >= e ) return false;

		// פΤĤäΤݤפǤϰפȤϤʤ
		assert( s >= 0 && s < pKeywordVec->size() );
		return CharCnt == (*pKeywordVec)[s].length();
		// return ( T_Char( (*pKeywordVec)[s].c_str()[CharCnt] ) == T_Char( '\0' ) );
	};

	// Ĥäʸ
	const std::wstring& GetFoundStr() const
	{
		assert( NULL != this );
		assert( NULL != pKeywordVec );
		assert( s >= 0 && s < pKeywordVec->size() );
		return (*pKeywordVec)[s];
	};

	// Ĥäʸ󤬻ꤵ줿ʸݤ
	bool IsSpecifiedStrFond( const std::wstring &rAStr ) const
	{
		assert( NULL != this );
		if ( NULL == pKeywordVec ) return false;
		if ( pKeywordVec->empty() ) return false;
		if ( !IsFound() ) return false;

		int i;
		const std::wstring &rFStr = GetFoundStr();	// 줿ʸ

		// ĹۤʤΤʤ顢פȤϤʤ
		if ( rFStr.length() != rAStr.length() ) return false;

		// ʸʸ̤ΤǤСñӤǽ
		if ( IsSensitive )
			return ( rFStr == rAStr );

		// ʸӤ
		for ( i = 0; i < rFStr.length() && !CompareChar( rFStr[i], rAStr[i] ); i++ );
		return ( i == rFStr.length() );
	};

protected:
	const std::vector< std::wstring > *pKeywordVec;
	int CharCnt;
	int s;
	int e;
};

};

#endif // KEYWORDFINDER_H_INCLUDED_

