////////////////////////////////////////////////////////////////////////////
// CTxtColorMgr_js 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "../../TaEdit_std.h"
#include "TxtColorMgr_js.h"

using namespace NLangExt;
using namespace NLangExt_js;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTxtColorMgr_js::CTxtColorMgr_js()
{
	int i;
	for ( i = 0; i < 78; i++ ) IndexTable[i] = 0;
	IndexTable[ NLangExt_cpp::CCT_ALPHANUMERIC ] = 0;
	IndexTable[ NLangExt_cpp::CCT_KEYWORD ] = 1;
	IndexTable[ NLangExt_cpp::CCT_COM1_LEFT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM1_RIGHT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM1_TEXT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM2_LEFT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM2_RIGHT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_COM2_TEXT ] = 2;
	IndexTable[ NLangExt_cpp::CCT_DQUOTE_LEFT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_DQUOTE_RIGHT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_DQUOTE_TEXT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_SQUOTE_LEFT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_SQUOTE_RIGHT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_SQUOTE_TEXT ] = 3;
	IndexTable[ NLangExt_cpp::CCT_OTHER ] = 0;
	IndexTable[ NLangExt_cpp::CCT_NULL ] = 0;
}

CTxtColorMgr_js::~CTxtColorMgr_js()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
CErrorBool CTxtColorMgr_js::Initialize( VClsPtr< CConfigInfo > pConf )
{
	vColor[0] = pConf->RefJS_NormalTextF_Color();
	vColor[1] = pConf->RefJS_KeywordF_Color();
	vColor[2] = pConf->RefJS_CommentF_Color();
	vColor[3] = pConf->RefJS_SringF_Color();
	if ( !m_HM.Initialize( pConf->RefJS_KeywordList().c_str() ) )
		return CErrorBool( pConf->RefFailedToReadKeywordListMsg() );
	return true;
}

// Ѥ뿧ο
int CTxtColorMgr_js::GetColorCount() const
{
	return 4;
}

// 
Pixel CTxtColorMgr_js::GetColor( int idx ) const
{
	assert( idx >= 0 && idx < 4 );
	return vColor[idx];
}

// 󤫤鿧ΥǥåѴ
int CTxtColorMgr_js::TranseToIdx( unsigned char c ) const
{
	assert( c >= 0 && c < 78 );
	return IndexTable[c];
}

// ֤ǹ
void CTxtColorMgr_js::InitiUpdate( T_LineData &rData ) const
{
	InitUpdateColorFunc( m_HM, rData );
}

// ʸιȼι
void CTxtColorMgr_js::Update( T_LineData &rData, const T_SelRange &range ) const
{
	UpdateColorFunc( m_HM, rData, range );
}
