/////////////////////////////////////////////////////////////////////////////
// HighlightMgr_bvs.h CHighlightMgr_bvs饹Υץơ
// 
/////////////////////////////////////////////////////////////////////////////

#if !defined( HIGHLIGHTMGR_VBS_H_INCLUDED_ )
#define HIGHLIGHTMGR_VBS_H_INCLUDED_

#include "../KeywordFinder.h"
#include "../KeywordList.h"

using namespace std;

namespace NLangExt {

namespace NLangExt_vbs {

///////////////////////////////////////////////////////////////////////////
// CProgPtr VBScriptץΥɤΥݥȡӹʸǤȽ

// ߥݥȤƤʸμ򼨤
enum CURCHARTYPE {
	VBSCT_ALPHANUMERIC	= 0x01,
	VBSCT_KEYWORD		= 0x11,
	VBSCT_COM1_LEFT		= 0x02,	// rem ˤ륳
	VBSCT_COM1_RIGHT	= 0x03,
	VBSCT_COM1_TEXT		= 0x04,
	VBSCT_COM2_LEFT		= 0x05,	// 'ˤ륳
	VBSCT_COM2_RIGHT	= 0x06,
	VBSCT_COM2_TEXT		= 0x07,
	VBSCT_DQUOTE_LEFT	= 0x28,
	VBSCT_DQUOTE_RIGHT	= 0x29,
	VBSCT_DQUOTE_TEXT	= 0x2A,
	VBSCT_OTHER			= 0x0E,
	VBSCT_NULL			= 0x0F,

	VBSCTM_KEYWORD_MASK	= 0x10,	// ѤΥޥ
	VBSCTM_DQUOTE_MASK	= 0x20
};

// cե٥åȤݤȽǤ
template< typename T_Char >
bool IsAlphaNumeric( T_Char c )
{
#if LANGEXT_IS_ASCII
	return (
		c >= T_Char( 'A' ) && c <= T_Char( 'Z' ) ||
		c >= T_Char( 'a' ) && c <= T_Char( 'z' ) ||
		c >= T_Char( '0' ) && c <= T_Char( '9' ) ||
		c == T_Char( '_' )
	);
#else
	const char *p = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_0123456789";
	while ( (*p) ) {
		if ( T_Char( (*p) ) == c ) return true;
		++p;
	}
	return false;
#endif
}

template < typename T_Char, typename T_Ptr >
class CProgPtr
{
public:
	// ƥȤκǽΰ֤ꤹ
	CProgPtr( T_Ptr args, T_Ptr arge ) :
		sptr( args ), eptr( arge ), CurCharCnt( 0 ), CurPtr( args ), CurType( VBSCT_OTHER )
	{
		next();
	};

	// λˡƥȤꤹ
	CProgPtr( T_Ptr args, T_Ptr arge, CURCHARTYPE argType ) :
		sptr( args ), eptr( arge ), CurCharCnt( 1 ), CurPtr( args ), CurType( argType )
	{
/*		const T_Char c = (*CurPtr);

		// Remʸν
		if ( argType == VBSCT_COM1_LEFT ) {
			if ( c == T_Char( 'R' ) || c == T_Char( 'r' ) )
				CurCharCnt = 3;
			else {
				if ( c == T_Char( 'E' ) || c == T_Char( 'e' ) )
					CurCharCnt = 2;
				else
					CurCharCnt = 1;
			}
		}
*/
	};

	CProgPtr( const CProgPtr &r ) :
		sptr( r.sptr ), eptr( r.eptr ), CurCharCnt( r.CurCharCnt ), CurPtr( r.CurPtr ), CurType( r.CurType )
	{};

	// ˿ʤ
	bool next()
	{
		CURCHARTYPE wType;
		int wCnt;
		T_Ptr p2;

		// ǤݥȤƤ顢ʾˤϿʤʤ
		if ( CurPtr == eptr ) return false;

		// ݥ󥿤ʤ
		for ( int i = 0; i < CurCharCnt; i++ )
			++CurPtr;

		if ( CurPtr == eptr ) {
			// ƥȤã
			CurType = VBSCT_NULL;
			CurCharCnt = 0;
			return true;
		}

		p2 = CurPtr;
		++p2;

		// ưʸȽ
		JdgCharType( (*CurPtr), (*p2), &wType, &wCnt );

		switch ( CurType & ~VBSCTM_KEYWORD_MASK ) {
		case VBSCT_ALPHANUMERIC:
		case VBSCT_OTHER:
		case VBSCT_COM1_RIGHT:
		case VBSCT_COM2_RIGHT:
		case VBSCT_DQUOTE_RIGHT:
			if ( (*CurPtr) == T_Char( '\"' ) && (*p2) == T_Char( '\"' ) ) {
				// ¦"ʸγϤΥ֥륯ơǤ
				CurType = VBSCT_DQUOTE_LEFT;
				CurCharCnt = 1;
			}
			else {
				CurType = wType;
				CurCharCnt = wCnt;
			}
			break;

		case VBSCT_COM1_LEFT:
		case VBSCT_COM1_TEXT:
			CurCharCnt = 1;
			if ( (*CurPtr) == T_Char( '\n' ) )
				CurType = VBSCT_COM1_RIGHT;
			else
				CurType = VBSCT_COM1_TEXT;
			break;

		case VBSCT_COM2_LEFT:
		case VBSCT_COM2_TEXT:
			CurCharCnt = 1;
			if ( (*CurPtr) == T_Char( '\n' ) )
				CurType = VBSCT_COM2_RIGHT;
			else
				CurType = VBSCT_COM2_TEXT;
			break;

		case VBSCT_DQUOTE_LEFT:
		case VBSCT_DQUOTE_TEXT:
			if ( wType == VBSCT_DQUOTE_LEFT ) {
				CurType = VBSCT_DQUOTE_RIGHT;
				CurCharCnt = 1;
			}
			else {
				CurType = VBSCT_DQUOTE_TEXT;
				CurCharCnt = wCnt;
			}
			break;
		}
		return true;
	}

	// ʸμ̤Ƚ
	void JdgCharType( T_Char c1, T_Char c2, CURCHARTYPE *pType, int *pCnt )
	{
		if ( c1 == T_Char( '\"' ) ) {
			if ( c2 == T_Char( '\"' ) ) {
				// Ϣ³Ĥ"ʸΥ֥륯ơ
				(*pType) = VBSCT_DQUOTE_TEXT;
				(*pCnt) = 2;
			}
			// ֥륯ơ
			(*pType) = VBSCT_DQUOTE_LEFT;
			(*pCnt) = 1;
			return ;
		}

		if ( c1 == T_Char( '\'' ) ) {
			(*pType) = VBSCT_COM2_LEFT;
			(*pCnt) = 1;
			return ;
		}

		if ( IsAlphaNumeric( c1 ) ) {
			(*pType) = VBSCT_ALPHANUMERIC;
			(*pCnt) = 1;
		}
		else {
			(*pType) = VBSCT_OTHER;
			(*pCnt) = 1;
		}
	}

	// ߤʸμ̤򼨤
	CURCHARTYPE GetCurType() const
	{
		return CurType;
	}
	// ݥ󥿤
	T_Ptr GetPtr() const
	{
		return CurPtr;
	};

	// ߥݥȤƤʸʸ
	int GetCurCharCnt() const
	{
		return CurCharCnt;
	};

	// 
	bool operator ==( const CProgPtr &r ) const {
		return ( sptr == r.sptr && eptr == r.eptr && CurPtr == r.CurPtr );
	};
	bool operator ==( const T_Ptr &r ) const {
		return ( CurPtr == r );
	};

	// Remˤ륳ȤäȤΤ
	void SetCurType_RemComment()
	{
		// ǤãƤä˲⤷ʤ
		if ( CurPtr == eptr ) return ;
		if ( (*CurPtr) == T_Char( '\n' ) )
			CurType = VBSCT_COM1_RIGHT;	// ߤΰ֤ԥɤǤСȤνλǤ
		else
			CurType = VBSCT_COM1_TEXT;	// ȤǤ
	}
private:
	T_Ptr sptr;
	T_Ptr eptr;
	T_Ptr CurPtr;
	CURCHARTYPE CurType;
	int CurCharCnt;	// ߥݥȤƤʸʸ鹽뤫
};


///////////////////////////////////////////////////////////////////////////
// CHighlightMgr VBScriptץιʸĴɽԤ

template < typename T_Char, typename T_TxtPtr, typename T_CBPtr >
class CHighlightMgr_vbs
{
public:
	CHighlightMgr_vbs(){};
	virtual ~CHighlightMgr_vbs(){};

	// 
	bool Initialize( const char *pKeywordListName )
	{
		return KeywordList.Initialize( pKeywordListName, false );
	};

	// Ƥο򹹿
	void FullUpdate( T_TxtPtr pSTxt, T_TxtPtr pETxt, T_CBPtr pSCB ) const
	{
		if ( pSTxt == pETxt ) return ;	// ƥĹ0ʤФϤʤ
		PartryUpdate( CProgPtr< T_Char, T_TxtPtr >( pSTxt, pETxt ), pSCB, true, pSTxt );
	};

	// ѹȼ
	void UpdateWidthChange(
		T_TxtPtr pSTxt,		// ƥȻü
		T_TxtPtr pETxt,		// ƥü
		T_TxtPtr pUpdateSPosTxt,	// ѹϰ
		T_CBPtr pUpdateSPosCB,		// ѹϰ֤Υ顼Хåե
		T_TxtPtr pUpdateEPosTxt		// ѹλ
		) const
	{
		// öäƤ顢ʤ
		// ɤޤ뤫->ѹսľʸʸ˰¸
		// ѿ	ѿʳʸޤ
		// 	ʳʸޤ
		// 11ʳʸޤ
		// 嵭ʳΥȡʸ
		// ʸ	ʸʳ⤷"ʳε
		// ɤޤǿʤफ->ʸѹʤʤޤ

		if ( pSTxt == pETxt ) return ;	// ƥĹ0ʤФϤʤ

		T_TxtPtr wTxtPtr = pUpdateSPosTxt;
		T_CBPtr wCBPtr = pUpdateSPosCB;
		if ( !( wTxtPtr == pSTxt ) ) {
			// 
			--wCBPtr;
			--wTxtPtr;
			switch ( (*wCBPtr) ) {
			case VBSCT_ALPHANUMERIC:
			case VBSCT_KEYWORD:
				while ( !( wTxtPtr == pSTxt ) && ( (*wCBPtr) & ~VBSCTM_KEYWORD_MASK ) == VBSCT_ALPHANUMERIC ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case VBSCT_COM1_LEFT:
				while ( !( wTxtPtr == pSTxt ) && (*wCBPtr) == VBSCT_COM1_LEFT ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case VBSCT_COM1_RIGHT:
			case VBSCT_COM1_TEXT:
			case VBSCT_COM2_LEFT:
			case VBSCT_COM2_RIGHT:
			case VBSCT_COM2_TEXT:
				if ( !( wTxtPtr == pSTxt ) ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case VBSCT_DQUOTE_LEFT:
			case VBSCT_DQUOTE_RIGHT:
			case VBSCT_DQUOTE_TEXT:
				while ( !( wTxtPtr == pSTxt ) && ( (*wCBPtr) & VBSCTM_DQUOTE_MASK ) && (*wTxtPtr) == '\"' ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case VBSCT_OTHER:
				while ( !( wTxtPtr == pSTxt ) && (*wCBPtr) == VBSCT_OTHER ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case VBSCT_NULL:
				return ;
			}
		}

		// ʤ
		unsigned char uc = (*wCBPtr);
		CProgPtr< T_Char, T_TxtPtr > ptr( wTxtPtr, pETxt, (CURCHARTYPE)uc );
		if ( wTxtPtr == pSTxt ) ptr = CProgPtr< T_Char, T_TxtPtr >( pSTxt, pETxt );	// ǽ餫鹹
		PartryUpdate( ptr, wCBPtr, false, pUpdateEPosTxt );	// ʸ郎
	};

private:
	// 򹹿
	// flg˿ꤷϡpETxtޤǹ롣
	// ꤷϡpOvTxtʸѹʤʤޤǹ
	void PartryUpdate( CProgPtr< T_Char, T_TxtPtr > ptr, T_CBPtr pSCB, bool flg, T_TxtPtr pOvTxt ) const
	{
		T_CBPtr pColorBuf = pSCB;
		int wType;
		int OldType;
		int i;
		bool OverFlg = flg;

		OldType = (*pSCB);
		wType = ~OldType;	// Ȥꤢ
		while ( ptr.GetCurType() != VBSCT_NULL && ( flg || OldType != wType || !OverFlg ) )
		{
			OldType = (*pColorBuf);	// ѹʸ

			if ( ptr.GetCurType() == VBSCT_ALPHANUMERIC )
				wType = LoopKeyword( &ptr, &pColorBuf );	// ѻͤξϡɤβǽ
			else {
				// pColorBufꤹͤꤹ
				wType = ptr.GetCurType();
				// pColorBufͤꤹ
				for ( i = 0 ; i < ptr.GetCurCharCnt(); i++ ) {
					(*pColorBuf) = wType;
					++pColorBuf;
				}
				ptr.next();
			}
			// ݥ󥿤pOvTxtۤݤ
			if ( ptr.GetPtr() > pOvTxt ) OverFlg = true;
		}
	};

	// ɤݤȽǤꤹ
	CURCHARTYPE LoopKeyword( CProgPtr< T_Char, T_TxtPtr > *pPtr, T_CBPtr *pColorBuf ) const
	{
		CKeywordFinder< T_Char, false > Finder( &( KeywordList.GetKeywordList() ) );
		int j;
		T_CBPtr hpCB = (*pColorBuf);
		CURCHARTYPE wType;
		CURCHARTYPE SetType;

		// ɤθʤĤġꤹϰϤꤹ
		wType = pPtr->GetCurType();
		while ( wType != VBSCT_NULL && wType == VBSCT_ALPHANUMERIC ) {

			// ǽ̵ɤ
			Finder.AddChar( *(pPtr->GetPtr()) );

			// ʸ
			for ( j = 0; j < pPtr->GetCurCharCnt(); j++ )
				++(*pColorBuf);
			pPtr->next();
			wType = pPtr->GetCurType();
		}

		// ꤹ뿧ꤹ
		if ( Finder.IsFound() ) {
			if ( Finder.IsSpecifiedStrFond( L"Rem" ) ) {
				SetType = VBSCT_COM1_LEFT;	// Remɤˤ륳ȤǤ
				pPtr->SetCurType_RemComment();
			}
			else
				SetType = VBSCT_KEYWORD;	// ɤǤ
		}
		else
			SetType = VBSCT_ALPHANUMERIC;	// ɤǤϤʤ

		// ꤷϰϤ˿ꤹ
		while ( !( hpCB == (*pColorBuf) ) ) {
			(*hpCB) = SetType;
			++hpCB;
		}
		return SetType;
	};

protected:
	CKeywordList KeywordList;
};

} // namespace NLangExt_vbs

} // namespace NLangExt

#endif // HIGHLIGHTMGR_VBS_H_INCLUDED_
