using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace genPatt
{
	public partial class Form1 : Form
	{
		public Form1()
		{
			InitializeComponent();
			
		}

		// y[XgꂽɐȊO܂܂Ă菜
		private void txtboxData_TextChanged( object sender, EventArgs e )
		{
			string str = txtboxData.Text;
			string dst = "";
			for ( int p = 0, n = str.Length; p < n; p++ )
			{
				char c = str[ p ];
				if ( c >= '0' && c <= '9' )
				{
					dst += c;
				}
			}
			if ( dst != str )
			{
				txtboxData.Text = dst;
				txtboxData.SelectAll();
				System.Media.SystemSounds.Beep.Play();
			}
		}
		// ȊOL[͂ꂽj~
		bool isEnteredNotNumber;
		bool isEnteredEnterKey;
		private void txtboxData_KeyDown( object sender, KeyEventArgs e )
		{
			isEnteredEnterKey = (e.KeyCode == Keys.Enter);
			isEnteredNotNumber = 
				 ( (e.KeyCode < Keys.D0 || e.KeyCode > Keys.D9)
				&& (e.KeyCode < Keys.NumPad0 || e.KeyCode > Keys.NumPad9)
				&& e.KeyCode != Keys.Enter
				&& e.KeyCode != Keys.Back
				&& e.KeyCode != Keys.Home
				&& e.KeyCode != Keys.End
				&& e.KeyCode != Keys.Delete
				&& e.KeyCode != Keys.Left
				&& e.KeyCode != Keys.Right );
		}
		private void txtboxData_KeyPress( object sender, KeyPressEventArgs e )
		{
			if ( isEnteredNotNumber )
			{
				e.Handled = true;	// L[͂VXeɉ񂳂Ȃ
				System.Media.SystemSounds.Beep.Play();	// x
			}
			
			if ( isEnteredEnterKey )
			{
				e.Handled = true;
				btnGo_Click( null, null );
			}
		}

		private void Form1_Load( object sender, EventArgs e )
		{
			PictureBox pb = picPatt;
			pb.Image = new Bitmap( pb.ClientRectangle.Width, pb.ClientRectangle.Height );
			Graphics g = Graphics.FromImage( pb.Image );
			g.FillRectangle( Brushes.White, pb.ClientRectangle );
			pb.Refresh();

			comboFormat.Sorted = false;
			comboFormat.Items.Add( "0" );
			comboFormat.Items.Add( "1" );
			comboFormat.SelectedIndex = 1;

			txtboxData.Text = "1";
			btnGo_Click( null, null );
		}

		private void btnGo_Click( object sender, EventArgs e )
		{
			Int64 code;
			try
			{
				code = System.Convert.ToInt64( txtboxData.Text );
				PictureBox pb = picPatt;
				mkimg mi = new mkimg( pb.Image );
				mi.draw( code, comboFormat.SelectedIndex );
				pb.Refresh();
			}
			catch 
			{
				MessageBox.Show( this, "l͈͊OłB", "G[", MessageBoxButtons.OK, MessageBoxIcon.Error );
				return;
			}
		}

		private void btnCopy_Click( object sender, EventArgs e )
		{
			Clipboard.SetImage( picPatt.Image );
		}

		private void btnSave_Click( object sender, EventArgs e )
		{
			SaveFileDialog dlg = new SaveFileDialog();
			dlg.Filter = "PNG File (*.png)|*.png||";
			if ( dlg.ShowDialog( this ) != DialogResult.OK )
				return;
			try
			{
				picPatt.Image.Save( dlg.OpenFile(), System.Drawing.Imaging.ImageFormat.Png );
			}
			catch
			{
				MessageBox.Show( this, "w̃pXŉ摜ۑł܂B", "G[", MessageBoxButtons.OK, MessageBoxIcon.Error );
			}
		}

		private void comboFormat_SelectedIndexChanged( object sender, EventArgs e )
		{
			if ( txtboxData.Text != "" )
				btnGo_Click( null, null );
		}

	}
}