/*
 * Decompiled with CFR 0.152.
 */
package samples;

import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VectorTest
extends TestCase {
    protected Vector fEmpty;
    protected Vector fFull;
    static /* synthetic */ Class class$samples$VectorTest;

    public VectorTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VectorTest.suite());
    }

    protected void setUp() {
        this.fEmpty = new Vector();
        this.fFull = new Vector();
        this.fFull.addElement(new Integer(1));
        this.fFull.addElement(new Integer(2));
        this.fFull.addElement(new Integer(3));
    }

    public static Test suite() {
        return new TestSuite(class$samples$VectorTest == null ? (class$samples$VectorTest = VectorTest.class$("samples.VectorTest")) : class$samples$VectorTest);
    }

    public void testCapacity() {
        int size = this.fFull.size();
        int i = 0;
        while (i < 100) {
            this.fFull.addElement(new Integer(i));
            ++i;
        }
        Assert.assertTrue((this.fFull.size() == 100 + size ? 1 : 0) != 0);
    }

    public void testClone() {
        Vector clone = (Vector)this.fFull.clone();
        Assert.assertTrue((clone.size() == this.fFull.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)clone.contains(new Integer(1)));
    }

    public void testContains() {
        Assert.assertTrue((boolean)this.fFull.contains(new Integer(1)));
        Assert.assertTrue((!this.fEmpty.contains(new Integer(1)) ? 1 : 0) != 0);
    }

    public void testElementAt() {
        Integer i = (Integer)this.fFull.elementAt(0);
        Assert.assertTrue((i == 1 ? 1 : 0) != 0);
        try {
            Integer j = (Integer)this.fFull.elementAt(this.fFull.size());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        Assert.fail((String)"Should raise an ArrayIndexOutOfBoundsException");
    }

    public void testRemoveAll() {
        this.fFull.removeAllElements();
        this.fEmpty.removeAllElements();
        Assert.assertTrue((boolean)this.fFull.isEmpty());
        Assert.assertTrue((boolean)this.fEmpty.isEmpty());
    }

    public void testRemoveElement() {
        this.fFull.removeElement(new Integer(3));
        Assert.assertTrue((!this.fFull.contains(new Integer(3)) ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

