package samples;

import junit.framework.*;
import java.util.Vector;

/**
 * A sample test case, testing <code>java.util.Vector</code>.
 *
 * @author ̾
 */
public class VectorTest extends TestCase {

	protected Vector fEmpty;
	protected Vector fFull;

	public VectorTest(String name) {
		super(name);
	}

	public static void main (String[] args) {
		junit.textui.TestRunner.run (suite());
	}

	protected void setUp() {
		fEmpty= new Vector();
		fFull= new Vector();
		fFull.addElement(new Integer(1));
		fFull.addElement(new Integer(2));
		fFull.addElement(new Integer(3));
	}

	public static Test suite() {
		return new TestSuite(VectorTest.class);
	}

	/**
	 * @target java.util.Vector
	 * @test capacity1 : ¿(100Ĥޤǳǧ)ɲäǤ뤫
	 * @test capacity2 : ¿(100Ĥޤǳǧ)ɲä˥Ŭڤ˳Ǥ뤫
	 */
	public void testCapacity() {

		int size= fFull.size();
		for (int i = 0; i < 100; i++) fFull.addElement(new Integer(i));
		assertTrue(fFull.size() == 100 + size);

	}

	/**
	 * @target java.util.Vector
	 * @test clone1 : ʣˤǿϥꥸʥǿƱǤ뤫
	 * @test clone2 : ʣˤϥꥸʥƱǤޤޤƤ뤫
	 */
	public void testClone() {

		Vector clone= (Vector)fFull.clone(); 
		assertTrue(clone.size() == fFull.size());
		assertTrue(clone.contains(new Integer(1)));

	}

	/**
	 * @target java.util.Vector
	 * @test contains1 : ɲä֥ȤƱͤΤΤޤޤƤȽǤ뤫
	 * @test contains2 : Υ֥ȤλȽǤ뤫
	 */
	public void testContains() {

		assertTrue(fFull.contains(new Integer(1)));
		assertTrue(!fEmpty.contains(new Integer(1)));

	}

	/**
	 * @target java.util.Vector
	 * @test elementAt1 : ǽǼ줿֥ȤФ뤫
	 * @test elementAt2 : ǥå 0 Ϥޤꥵ - 1 н
	 */
	public void testElementAt() {

		Integer i = (Integer)fFull.elementAt(0);
		assertTrue(i.intValue() == 1);

		try {

			Integer j= (Integer)fFull.elementAt(fFull.size());

		} catch (ArrayIndexOutOfBoundsException e) {

			return;

		}
		fail("Should raise an ArrayIndexOutOfBoundsException");

	}

	/**
	 * @target java.util.Vector
	 * @test removeAll1 : ƤǤ뤳ȤǤθ϶ȽǤ뤫
	 * @test removeAll2 : Υ֥ȤФƤ removeAll() ƤǤư뤫
	 */
	public void testRemoveAll() {

		fFull.removeAllElements();
		fEmpty.removeAllElements();
		assertTrue(fFull.isEmpty());
		assertTrue(fEmpty.isEmpty()); 

	}

	/**
	 * @test removeElement : ͤꤷƺˡƱͤȽǤ줿֥Ȥ
	 *                       뤫
	 */
	public void testRemoveElement() {

		fFull.removeElement(new Integer(3));
		assertTrue(!fFull.contains(new Integer(3)) ); 

	}

}

