/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ForwardConfig;

import jp.ossc.tstruts.config.CacheKeyConfig;
import jp.ossc.tstruts.config.SelectForwardConfig;

/**
 * gActionMappingB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 * 
 */
public class ExtendActionMapping extends ActionMapping {
	private static final Log log = LogFactory.getLog(ExtendActionMapping.class);

	public static final String[] CACHE_TYPE_STR = {
		"nocache",
		"global",
		"session" 
	};
	public static final int CACHE_TYPE_NOCACHE = 0;
	public static final int CACHE_TYPE_GLOBAL = 1;
	public static final int CACHE_TYPE_SESSION = 2;

	protected ArrayList forwardList = new ArrayList();
	protected SelectForwardConfig selectForwardConfig = null;
	protected int cacheType = CACHE_TYPE_NOCACHE;
	protected CacheKeyConfig[] cacheKeys = new CacheKeyConfig[0];
	protected String interceptor = null;
    
	public void addCacheKeyConfig(CacheKeyConfig param) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		CacheKeyConfig[] newParams =
			new CacheKeyConfig[cacheKeys.length + 1];
		System.arraycopy(cacheKeys, 0, newParams, 0, cacheKeys.length);
		newParams[cacheKeys.length] = param;
		cacheKeys = newParams;
	}

	public CacheKeyConfig[] getCacheKeyConfigs() {
		return cacheKeys;
	}

	/**
	 * @return
	 */
	
	public ExtendActionMapping(){
		super();
		setScope("request");
	}

	
	
	public SelectForwardConfig getSelectForwardConfig() {
		return selectForwardConfig;
	}

	/**
	 * @param config
	 */
	public void setSelectForwardConfig(SelectForwardConfig config) {
		selectForwardConfig = config;
	}

	/**
	 * dM}~邩
	 */
	protected boolean transacted = false;

	public boolean getTransacted() {
		return (this.transacted);
	}

	public void setTransacted(boolean transacted) {
		this.transacted = transacted;
	}
	
	/**
	 * @return
	 */
	public String getCache() {
		return CACHE_TYPE_STR[cacheType];
	}

	/**
	 * @param string
	 */
	public void setCache(String string) {
		for (int i = 0; i < CACHE_TYPE_STR.length; ++i) {
			if (CACHE_TYPE_STR[i].equalsIgnoreCase(string)) {
				cacheType = i;
				return;
			}
		}
		log.warn("Invalid cache type '" + string + "'. Set 'nocache'.");
		cacheType = CACHE_TYPE_NOCACHE;
	}

	public int getCacheType() {
		return cacheType;
	}
	/**
	 * @return
	 */
	public String getInterceptor() {
		return interceptor;
	}

	/**
	 * @param string
	 */
	public void setInterceptor(String string) {
		interceptor = string;
	}


	/* (non-Javadoc)
	 * @see org.apache.struts.config.ActionConfig#addForwardConfig(org.apache.struts.config.ForwardConfig)
	 */
	public void addForwardConfig(ForwardConfig forwardConfig) {
		forwardList.add(forwardConfig);
		super.addForwardConfig(forwardConfig);
	}
	
	public ForwardConfig[] getForwardConfigs() {
		ForwardConfig[] forwards = new ForwardConfig[forwardList.size()];
		forwardList.toArray(forwards);
		return forwards;
	}

}

