/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb;

/**
 * ƖOB<p>
 * ƖĂяoɁAƖsłȂ肪ꍇthrow܂B<br>
 * <p>
 * OƖAO̎ʁAbZ[WǍƂȂO擾ł܂BO̎ʂɂ́A{@link #UNKNOWN}A{@link #SYSTEM}A{@link #APPLICATION}܂B<br>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class BusinessException extends Exception{
    
    /**
     * O̎ʂsł鎖OʁB<p>
     * {@link #SYSTEM}A{@link #APPLICATION}ȊO̗Oʂݒ肳ꂽӖBʒutƂẮA{@link #SYSTEM}ƓlłB
     */
    public static final int UNKNOWN = -1;
    
    /**
     * O̎ʂVXeOł鎖OʁB<p>
     * t[[NAAvP[VT[oŏׂO\B
     */
    public static final int SYSTEM = 0;
    
    /**
     * O̎ʂAvP[VOł鎖OʁB<p>
     * ĂяõNCAgŏׂO\B
     */
    public static final int APPLICATION = 1;
    
    /**
     * OƖO[vB<p>
     */
    private final String group;
    
    /**
     * OƖB<p>
     */
    private final String business;
    
    /**
     * OʁB<p>
     */
    private final int type;
    
    /**
     * OƖOIuWFNg𐶐B<p>
     * Oʂ́A{@link #SYSTEM}ɂȂB<br>
     *
     * @param group OƖO[v
     * @param business OƖ
     */
    public BusinessException(String group, String business){
        this(group, business, null, SYSTEM);
    }
    
    /**
     * OƖAbZ[WOIuWFNg𐶐B<p>
     * Oʂ́A{@link #SYSTEM}ɂȂB<br>
     *
     * @param group OƖO[v
     * @param business OƖ
     * @param message bZ[W
     */
    public BusinessException(String group, String business, String message){
        this(group, business, message, SYSTEM);
    }
    
    /**
     * OƖAOʂOIuWFNg𐶐B<p>
     *
     * @param group OƖO[v
     * @param business OƖ
     * @param type O
     * @see #SYSTEM
     * @see #APPLICATION
     */
    public BusinessException(String group, String business, int type){
        this(group, business, null, type);
    }
    
    /**
     * OƖAOʂOIuWFNg𐶐B<p>
     * Oʂ́A{@link #SYSTEM}ɂȂB<br>
     *
     * @param group OƖO[v
     * @param business OƖ
     * @param cause ̌ƂȂO
     */
    public BusinessException(String group, String business, Throwable cause){
        super(cause);
        this.group = group;
        this.business = business;
        this.type = SYSTEM;
    }
    
    /**
     * OƖAbZ[WAOʂOIuWFNg𐶐B<p>
     *
     * @param group OƖO[v
     * @param business OƖ
     * @param message bZ[W
     * @param type O
     * @see #SYSTEM
     * @see #APPLICATION
     */
    public BusinessException(
        String group,
        String business,
        String message,
        int type
    ){
        super(message);
        this.group = group;
        this.business = business;
        this.type = type;
    }
    
    /**
     * OƖO[v擾B<p>
     *
     * @return OƖO[v
     */
    public String getBusinessGroupName(){
        return group;
    }
    
    /**
     * OƖ擾B<p>
     *
     * @return OƖ
     */
    public String getBusinessName(){
        return business;
    }
    
    /**
     * Oʂ擾B<p>
     *
     * @return O
     * @see #SYSTEM
     * @see #APPLICATION
     * @see #UNKNOWN
     */
    public int getType(){
        switch(type){
        case SYSTEM:
        case APPLICATION:
            break;
        default:
            return UNKNOWN;
        }
        return type;
    }
}