/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb;

import java.util.*;
import java.io.Serializable;

import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.*;

/**
 * T[rXQƁB<p>
 * {@link jp.ossc.tstruts.action.ejb.facade.BusinessGroup}ŃO[sOꂽ{@link jp.ossc.tstruts.action.ejb.business.Business}At[[ÑNXT[rXȂǂÃT[rXQƂۂɁA\[XɃT[rX𒼐ڏ댯邽߂ɁAۂ̃T[rXɑΉT[rXQƖ`T[rXłB<br>
 * ̃T[rXAT[rXQƖɑΉT[rX擾邽߂ɂ́ÃT[rX̃T[rXAŒ肵ĂA炩ߒmĂKvB̂߁ÃT[rX̖O͕K"ServiceNameRef"i{@link #SERVICE_NAME}jƂāÃT[rXgpT[rXƓ&lt;manager&gt;vfɒ`Ȃ΂ȂȂB<br>
 * ȉɁAT[rX`t@C̗B<br>
 * <pre>
 *   &lt;manager name="Group1"&gt;
 *     &lt;service name="ServiceNameRef" code="jp.ossc.tstruts.action.ejb.ServiceNameReference"&gt;
 *       &lt;attribute name="Service1" type="jp.ossc.nimbus.core.ServiceName"&gt;
 *         Group2#Service1
 *       &lt;/attribute&gt;
 *       &lt;attribute name="Service2"&gt;Group2#Service2&lt;/attribute&gt;
 *     &lt;/service&gt;
 *   &lt;/manager&gt;
 * </pre>
 * &lt;attribute&gt;vfnameɃT[rXQƖ`āAɑΉT[rX&lt;attribute&gt;vf̓eɒ`Beɒ`T[rX̒`@́A{@link ServiceNameEditor}̎dlɏB<br>
 * ܂Atypeɂ́A{@link ServiceName}NXw肷邪Aȗ鎖\łBȗꍇ́AT[rXJnɁAServiceNameEditorɂāAStringServiceNameւƕϊB<br>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class ServiceNameReference extends ServiceBase
 implements Map, Serializable{
    
    /**
     * ̃T[rX̃T[rXB<p>
     * ̃T[rXAT[rXQƖɑΉT[rX擾邽߂ɂ́ÃT[rX̃T[rXAŒ肵ĂA炩ߒmĂKvB̂߁ÃT[rX̖O͕K̒萔̒lƂāÃT[rXgpT[rXƓ&lt;manager&gt;vfɒ`Ȃ΂ȂȂB<br>
     */
    public static final String SERVICE_NAME = "ServiceNameRef";
    
    private ServiceNameEditor editor;
    private Map refNameMap = Collections.synchronizedMap(new HashMap());
    private Map refNameCacheMap;
    
    /**
     * T[rXQƖɑΉT[rX擾B<p>
     *
     * @param refName T[rXQƖ
     * @return T[rX
     */
    public ServiceName getServiceName(String refName){
        return (ServiceName)refNameCacheMap.get(refName);
    }
    
    /**
     * T[rX̐sB<p>
     * ł́Aȉ̏sB<br>
     * <ol>
     *   <li>{@link ServiceName}^̃vpeBҏWs{@link ServiceNameEditor}{@link java.beans.PropertyEditorManager}擾B</li>
     *   <li>&lt;attribute&gt;vftypeȗĂꍇ́AT[rXJnɁAStringServiceNameւ̕ϊsA̕ϊPxsȂ悤ɁAϊLbV邽߂Map𐶐B</li>
     * </ol>
     */
    public void createService() throws Exception{
        editor = new ServiceNameEditor();
        editor.setServiceManagerName(getServiceManagerName());
        refNameCacheMap = new HashMap();
    }
    
    /**
     * T[rX̊JnsB<p>
     * ł́Aȉ̏sB<br>
     * <ol>
     *   <li>&lt;attribute&gt;vftypeȗĂꍇ́AT[rXNɁAStringServiceNameւ̕ϊsB</li>
     * </ol>
     */
    public void startService() throws Exception{
        final Iterator keys = keySet().iterator();
        while(keys.hasNext()){
            final Object key = keys.next();
            final Object value = get(key);
            ServiceName serviceName = null;
            if(value == null){
                continue;
            }else if(value instanceof ServiceName){
                serviceName = (ServiceName)value;
            }else if(editor != null){
                final String name = (String)value.toString();
                editor.setAsText(name);
                serviceName = (ServiceName)editor.getValue();
            }
            if(serviceName != null){
                refNameCacheMap.put(key, serviceName);
            }
        }
    }
    
    /**
     * T[rX̒~sB<p>
     * ł́Aȉ̏sB<br>
     * <ol>
     *   <li>&lt;attribute&gt;vftypeȗĂꍇ́A{@link #getServiceName(String)}ĂяoꂽɁAStringServiceNameւ̕ϊsA̕ϊPxsȂ悤ɁAϊLbV邽߂MapĂ邪AMapNAB</li>
     * </ol>
     */
    public void stopService(){
        if(refNameCacheMap != null){
            refNameCacheMap.clear();
        }
    }
    
    /**
     * T[rX̔jsB<p>
     * ł́Aȉ̏sB<br>
     * <ol>
     *   <li>{@link ServiceName}^̃vpeBҏWs{@link ServiceNameEditor}jB</li>
     *   <li>&lt;attribute&gt;vftypeȗĂꍇ́A{@link #getServiceName(String)}ĂяoꂽɁAStringServiceNameւ̕ϊsA̕ϊPxsȂ悤ɁAϊLbV邽߂MapĂ邪AMapjB</li>
     * </ol>
     */
    public void destroyService(){
        editor = null;
        refNameCacheMap = null;
        refNameMap = null;
    }
    
    /**
     * ̃IuWFNgɐݒ肳ꂽT[rXQƂ̐擾B<p>
     *
     * @return T[rXQƂ̐
     */
    public int size(){
        return refNameMap.size();
    }
    
    /**
     * ̃IuWFNgɃT[rXQƂݒ肳ĂȂ𒲂ׂB<p>
     *
     * @return T[rXQƂPݒ肳ĂȂꍇAtrue
     */
    public boolean isEmpty(){
        return refNameMap.isEmpty();
    }
    
    /**
     * w肳ꂽT[rXQƖÃIuWFNg̑ɐݒ肳Ă邩𒲂ׂB<p>
     *
     * @param refName T[rXQƖ
     * @return T[rXQƂݒ肳ĂꍇAtrue
     */
    public boolean containsKey(Object refName){
        return refNameMap.containsKey(refName);
    }
    
    /**
     * w肳ꂽT[rXɑΉT[rXQƂݒ肳Ă邩𒲂ׂB<p>
     *
     * @param serviceName T[rX
     * @return T[rXQƂݒ肳ĂꍇAtrue
     */
    public boolean containsValue(Object serviceName){
        return refNameMap.containsValue(serviceName);
    }
    
    /**
     * w肳ꂽT[rXQƖɑΉT[rX擾B<p>
     *
     * @param name T[rXQ
     * @return T[rX
     */
    public Object get(Object refName){
        return refNameMap.get(refName);
    }
    
    /**
     * w肳ꂽT[rXQƖɑΉT[rXݒ肷B<p>
     *
     * @param refName T[rXQƖ
     * @param serviceName T[rX
     * @return w肳ꂽT[rXQƖɊ֘AȑO̒lBrefNameɃ}bsOȂꍇnullB
     */
    public Object put(Object refName, Object serviceName){
        return refNameMap.put(refName, serviceName);
    }
    
    /**
     * w肳ꂽT[rXQƖɑΉT[rX폜B<p>
     *
     * @param name T[rXQƖ
     * @return 폜ꂽT[rX
     */
    public Object remove(Object refName){
        return refNameMap.remove(name);
    }
    
    /**
     * w肳ꂽ}bv̑SẴGgÃIuWFNg̃T[rXQƂƂĐݒ肷B<p>
     *
     * @param map T[rXQƃ}bv
     */
    public void putAll(Map map){
        refNameMap.putAll(map);
    }
    
    /**
     * ̃IuWFNg̃T[rXQƂSč폜B<p>
     */
    public void clear(){
        refNameMap.clear();
    }
    
    /**
     * ̃IuWFNg̃T[rXQƖ̏W擾B<p>
     *
     * @return T[rXQƖ̏W
     */
    public Set keySet(){
        return refNameMap.keySet();
    }
    
    /**
     * ̃IuWFNg̃T[rX̏W擾B<p>
     *
     * @return T[rX̏W
     */
    public Collection values(){
        return refNameMap.values();
    }
    
    /**
     * ̃IuWFNg̃T[rXQƃGg̏W擾B<p>
     *
     * @return T[rXQƃGg
     */
    public Set entrySet(){
        return refNameMap.entrySet();
    }
}
