/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editor.*;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

import jp.ossc.tstruts.action.ejb.*;
import jp.ossc.tstruts.common.InvocationContext;

/**
 * ƖW[iC^Zv^T[rXB<p>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class BusinessJournalInterceptor extends BusinessInterceptorServiceBase
 implements BusinessJournalInterceptorMBean{
    
    private static final String BUSINESS_METHOD_NAME = "work";
    private static final String GROUP = "BusinessGroup = ";
    private static final String SEPARATOR = ", ";
    private static final String BUSINESS = "Business = ";
    private static final String DEFAULT_REQUEST_JOURNAL_KEY = "Request";
    private static final String DEFAULT_METHOD_CALL_JOURNAL_KEY
         = "MethodCall";
    private static final String DEFAULT_METHOD_RETURN_JOURNAL_KEY
         = "MethodReturn";
    
    private ServiceName journalName;
    private Journal journal;
    
    private ServiceName editorFinderName;
    private EditorFinder editorFinder;
    
    private String requestJournalKey = DEFAULT_REQUEST_JOURNAL_KEY;
    private String methodCallJournalKey = DEFAULT_METHOD_CALL_JOURNAL_KEY;
    private String methodReturnJournalKey = DEFAULT_METHOD_RETURN_JOURNAL_KEY;
    private String message;
    
    public void setJournal(ServiceName name){
        journalName = name;
    }
    
    public ServiceName getJournal(){
        return journalName;
    }
    
    public void setEditorFinder(ServiceName name){
        editorFinderName = name;
    }
    
    public ServiceName getEditorFinder(){
        return editorFinderName;
    }
    
    /**
     * ŏo͂W[ĩ[gvf̃L[ݒ肷B<p>
     * Ŏw肳ꂽL[́A{@link jp.ossc.nimbus.service.journal.Journal#startJournal(String)}̈ƂĎgpB<br>
     * ܂Aw肵Ȃꍇ́A"Request"gpB<br>
     *
     * @param key ŏo͂W[ĩ[gvf̃L[
     * @see #getRequestJournalKey()
     */
    public void setRequestJournalKey(String key){
        requestJournalKey = key;
    }
    
    public String getRequestJournalKey(){
        return requestJournalKey;
    }
        
    /**
     * ŏo͂W[ĩ\bhĂяovf̃L[ݒ肷B<p>
     * Ŏw肳ꂽL[́A{@link jp.ossc.nimbus.service.journal.Journal#addInfo(String, Object)}̑ƂĎgpB<br>
     * ܂Aw肵Ȃꍇ́A"MethodCall"gpB<br>
     *
     * @param key ŏo͂W[ĩ\bhĂяovf̃L[
     * @see #getMethodCallJournalKey()
     */
    public void setMethodCallJournalKey(String key){
        methodCallJournalKey = key;
    }
    
    public String getMethodCallJournalKey(){
        return methodCallJournalKey;
    }
    
    /**
     * ŏo͂W[ĩ\bh߂vf̃L[ݒ肷B<p>
     * Ŏw肳ꂽL[́A{@link jp.ossc.nimbus.service.journal.Journal#addInfo(String, Object)}̑ƂĎgpB<br>
     * ܂Aw肵Ȃꍇ́A"MethodReturn"gpB<br>
     *
     * @param key ŏo͂W[ĩ\bh߂vf̃L[
     * @see #getMethodReturnJournalKey()
     */
    public void setMethodReturnJournalKey(String key){
        methodReturnJournalKey = key;
    }
    
    public String getMethodReturnJournalKey(){
        return methodReturnJournalKey;
    }
    
    public void startService() throws Exception{
        if(journalName != null){
            journal = (Journal)ServiceManagerFactory.getServiceObject(journalName);
        }
        if(editorFinderName != null){
            editorFinder = (EditorFinder)ServiceManagerFactory
                .getServiceObject(editorFinderName);
        }
    }
    
    public void destroyService(){
        journal = null;
        editorFinder = null;
    }
    
    public InvocationContext preNext(InvocationContext context)
     throws BusinessException{
        if(journal == null){
            return context;
        }
        journal.startJournal(requestJournalKey, editorFinder);
        if(context != null){
            journal.setRequestId(context.getRequestID());
        }
        final Object interceptBusiness = ServiceManagerFactory
            .getServiceObject(getInterceptBusinessName());
        final MethodCallJournalData data = new MethodCallJournalData(
            interceptBusiness.getClass(),
            BUSINESS_METHOD_NAME
        );
        data.addParamaterType(InvocationContext.class);
        data.addParamater(context);
        data.setMessage(getMessage());
        journal.addInfo(methodCallJournalKey, data, editorFinder);
        
        return context;
    }
    
    /**
     * BusinessInterceptorĂяo㏈sB<p>
     * Ă̂ŁATuNXŕKvȏ邱ƁB<br>
     *
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception BusinessException ƖɗOꍇ
     */
    public InvocationContext postNext(InvocationContext context)
     throws BusinessException{
        if(journal == null){
            return context;
        }
        
        final Object interceptBusiness = ServiceManagerFactory
            .getServiceObject(getInterceptBusinessName());
        final MethodReturnJournalData data = new MethodReturnJournalData(
            interceptBusiness.getClass(),
            BUSINESS_METHOD_NAME,
            new Class[]{InvocationContext.class},
            context
        );
        data.setMessage(getMessage());
        journal.addInfo(methodReturnJournalKey, data, editorFinder);
        return context;
    }
    
    public BusinessException throwBusinessException(
        InvocationContext context,
        BusinessException e
    ) throws BusinessException{
        if(journal == null){
            return e;
        }
        final Object interceptBusiness = ServiceManagerFactory
            .getServiceObject(getInterceptBusinessName());
        final MethodThrowJournalData data = new MethodThrowJournalData(
            interceptBusiness.getClass(),
            BUSINESS_METHOD_NAME,
            new Class[]{InvocationContext.class},
            e
        );
        data.setMessage(getMessage());
        journal.addInfo(methodReturnJournalKey, data, editorFinder);
        return e;
    }
    
    public RuntimeException throwRuntimeException(
        InvocationContext context,
        RuntimeException e
    ) throws BusinessException{
        if(journal == null){
            return e;
        }
        final Object interceptBusiness = ServiceManagerFactory
            .getServiceObject(getInterceptBusinessName());
        final MethodThrowJournalData data = new MethodThrowJournalData(
            interceptBusiness.getClass(),
            BUSINESS_METHOD_NAME,
            new Class[]{InvocationContext.class},
            e
        );
        data.setMessage(getMessage());
        journal.addInfo(methodReturnJournalKey, data, editorFinder);
        return e;
    }
    
    public Error throwError(
        InvocationContext context,
        Error error
    ) throws BusinessException{
        if(journal == null){
            return error;
        }
        final Object interceptBusiness = ServiceManagerFactory
            .getServiceObject(getInterceptBusinessName());
        final MethodThrowJournalData data = new MethodThrowJournalData(
            interceptBusiness.getClass(),
            BUSINESS_METHOD_NAME,
            new Class[]{InvocationContext.class},
            error
        );
        data.setMessage(getMessage());
        journal.addInfo(methodReturnJournalKey, data, editorFinder);
        return error;
    }
    
    public InvocationContext finallyNext(InvocationContext context)
     throws BusinessException{
        if(journal == null){
            return context;
        }
        
        journal.endJournal();
        return context;
    }
    
    private String getMessage(){
        if(message == null){
            final ServiceName interceptBusiness = getInterceptBusinessName();
            message = GROUP + interceptBusiness.getServiceManagerName()
                + SEPARATOR + BUSINESS + interceptBusiness.getServiceName();
        }
        return message;
    }
}