/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * ƖW[iC^Zv^T[rXt@NgB<p>
 * {@link BusinessJournalInterceptor}𐶐t@NgT[rXłB<br>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 * @see BusinessJournalInterceptor
 */
public class BusinessJournalInterceptorFactory extends FactoryServiceBase
 implements BusinessJournalInterceptorFactoryMBean{
    
    private final BusinessJournalInterceptor template
         = new BusinessJournalInterceptor();
    
    /**
     * {@link BusinessJournalInterceptor}T[rX𐶐B<p>
     *
     * @return BusinessJournalInterceptorT[rX
     * @exception Exception BusinessJournalInterceptor̐ENɎsꍇ
     * @see BusinessJournalInterceptor
     */
    protected Object createInstance() throws Exception{
        final BusinessJournalInterceptor interceptor
             = new BusinessJournalInterceptor();
        interceptor.setJournal(template.getJournal());
        interceptor.setEditorFinder(template.getEditorFinder());
        interceptor.setRequestJournalKey(template.getRequestJournalKey());
        interceptor.setMethodCallJournalKey(template.getMethodCallJournalKey());
        interceptor.setMethodReturnJournalKey(
            template.getMethodReturnJournalKey()
        );
        interceptor.setNextBusinessInterceptorName(
            template.getNextBusinessInterceptorName()
        );
        interceptor.create();
        interceptor.start();
        return interceptor;
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public void setJournal(ServiceName name){
        template.setJournal(name);
        final Set instanceSet = getManagedInstanceSet();
        final Iterator instances = instanceSet.iterator();
        while(instances.hasNext()){
            final BusinessJournalInterceptor interceptor
                 = (BusinessJournalInterceptor)instances.next();
            interceptor.setJournal(name);
        }
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public ServiceName getJournal(){
        return template.getJournal();
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public void setEditorFinder(ServiceName name){
        template.setEditorFinder(name);
        final Set instanceSet = getManagedInstanceSet();
        final Iterator instances = instanceSet.iterator();
        while(instances.hasNext()){
            final BusinessJournalInterceptor interceptor
                 = (BusinessJournalInterceptor)instances.next();
            interceptor.setEditorFinder(name);
        }
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public ServiceName getEditorFinder(){
        return template.getEditorFinder();
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public void setRequestJournalKey(String key){
        template.setRequestJournalKey(key);
        final Set instanceSet = getManagedInstanceSet();
        final Iterator instances = instanceSet.iterator();
        while(instances.hasNext()){
            final BusinessJournalInterceptor interceptor
                 = (BusinessJournalInterceptor)instances.next();
            interceptor.setRequestJournalKey(key);
        }
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public String getRequestJournalKey(){
        return template.getRequestJournalKey();
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public void setMethodCallJournalKey(String key){
        template.setMethodCallJournalKey(key);
        final Set instanceSet = getManagedInstanceSet();
        final Iterator instances = instanceSet.iterator();
        while(instances.hasNext()){
            final BusinessJournalInterceptor interceptor
                 = (BusinessJournalInterceptor)instances.next();
            interceptor.setMethodCallJournalKey(key);
        }
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public String getMethodCallJournalKey(){
        return template.getMethodCallJournalKey();
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public void setMethodReturnJournalKey(String key){
        template.setMethodReturnJournalKey(key);
        final Set instanceSet = getManagedInstanceSet();
        final Iterator instances = instanceSet.iterator();
        while(instances.hasNext()){
            final BusinessJournalInterceptor interceptor
                 = (BusinessJournalInterceptor)instances.next();
            interceptor.setMethodReturnJournalKey(key);
        }
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public String getMethodReturnJournalKey(){
        return template.getMethodReturnJournalKey();
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public void setNextBusinessInterceptorName(ServiceName intereptor){
        template.setNextBusinessInterceptorName(intereptor);
        final Set instanceSet = getManagedInstanceSet();
        final Iterator instances = instanceSet.iterator();
        while(instances.hasNext()){
            final BusinessJournalInterceptor interceptor
                 = (BusinessJournalInterceptor)instances.next();
            interceptor.setNextBusinessInterceptorName(intereptor);
        }
    }
    
    // BusinessJournalInterceptorFactoryMBeanJavaDoc
    public ServiceName getNextBusinessInterceptorName(){
        return template.getNextBusinessInterceptorName();
    }
}
