/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import java.io.Serializable;
import java.util.*;

import jp.ossc.nimbus.service.journal.editor.CSVJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

import jp.ossc.tstruts.common.InvocationContext;

/**
 * InvocationContextIuWFNgCSV`ŃtH[}bgGfB^B<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class InvocationContextCSVJournalEditor
 extends CSVJournalEditorServiceBase
 implements InvocationContextCSVJournalEditorMBean, Serializable{
    
    private static final String DEFAULT_SECRET_STRING = "******";
    private static final String ATTRIBUTE_VALUE_SEPARATOR = "=";
    private static final String ATTRIBUTE_SEPARATOR = ",";
    
    private String secretString = DEFAULT_SECRET_STRING;
    private String[] secretAttributes;
    protected Set secretAttributeSet;
    private String[] enabledAttributes;
    protected Set enabledAttributeSet;
    
    private final Map outputElements = new HashMap();
    
    private String[] outputElementKeys = {
        REQUEST_ID_KEY,
        USER_PROFILE_KEY,
        ACTION_FORM_KEY,
        ATTRIBUTES_KEY
    };
    
    public InvocationContextCSVJournalEditor(){
        defineElements();
    }
    
    protected void defineElements(){
        defineElementMaker(
            REQUEST_ID_KEY,
            new ElementMaker(){
                public Object make(
                    EditorFinder finder,
                    Object key,
                    InvocationContext context
                ){
                    return context.getRequestID();
                }
            }
        );
        defineElementMaker(
            USER_PROFILE_KEY,
            new ElementMaker(){
                public Object make(
                    EditorFinder finder,
                    Object key,
                    InvocationContext context
                ){
                    return context.getUserProfile();
                }
            }
        );
        defineElementMaker(
            ACTION_FORM_KEY,
            new ElementMaker(){
                public Object make(
                    EditorFinder finder,
                    Object key,
                    InvocationContext context
                ){
                    return context.getActionForm();
                }
            }
        );
        defineElementMaker(
            ATTRIBUTES_KEY,
            new ElementMaker(){
                public Object make(
                    EditorFinder finder,
                    Object key,
                    InvocationContext context
                ){
                    return makeAttributesFormat(
                        finder,
                        key,
                        context,
                        new StringBuffer()
                    ).toString();
                }
            }
        );
    }
    
    protected interface ElementMaker{
        public Object make(
            EditorFinder finder,
            Object key,
            InvocationContext context
        );
    }
    
    protected void defineElementMaker(String key, ElementMaker maker){
        outputElements.put(key, maker);
    }
    
    protected ElementMaker findElementMaker(String key){
        return (ElementMaker)outputElements.get(key);
    }
    
    public void setOutputElementKeys(String[] keys)
     throws IllegalArgumentException{
        if(keys != null && keys.length != 0){
            for(int i = 0; i < keys.length; i++){
                final String key = keys[i];
                if(!outputElements.containsKey(key)){
                    throw new IllegalArgumentException(
                        key + " is undefined."
                    );
                }
            }
            outputElementKeys = keys;
        }
    }
    
    public String[] getOutputElementKeys(){
        return outputElementKeys;
    }
    
    public void setSecretString(String str){
        secretString = str;
    }
    
    public String getSecretString(){
        return secretString;
    }
    
    public void setSecretAttributes(String[] names){
        secretAttributes = names;
    }
    
    public String[] getSecretAttributes(){
        return secretAttributes;
    }
    
    public void setEnabledAttributes(String[] names){
        enabledAttributes = names;
    }
    
    public String[] getEnabledAttributes(){
        return enabledAttributes;
    }
    
    public void createService(){
        secretAttributeSet = new HashSet();
        enabledAttributeSet = new HashSet();
    }
    
    public void startService(){
        if(secretAttributes != null){
            for(int i = 0; i < secretAttributes.length; i++){
                secretAttributeSet.add(secretAttributes[i]);
            }
        }
        if(enabledAttributes != null){
            for(int i = 0; i < enabledAttributes.length; i++){
                enabledAttributeSet.add(enabledAttributes[i]);
            }
        }
    }
    
    public void stopService(){
        secretAttributeSet.clear();
        enabledAttributeSet.clear();
    }
    
    public void destroyService(){
        secretAttributeSet = null;
        enabledAttributeSet = null;
    }
    
    protected void processCSV(
        EditorFinder finder,
        Object key,
        Object value
    ){
        for(int i = 0; i < outputElementKeys.length; i++){
            final ElementMaker maker
                 = findElementMaker(outputElementKeys[i]);
            addElement(maker.make(finder, key, (InvocationContext)value));
        }
    }
    
    protected StringBuffer makeAttributesFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        StringBuffer buf
    ){
        final Iterator attrNames = context.getAttributeNames();
        if(!attrNames.hasNext()){
            buf.append(NULL_STRING);
            return buf;
        }
        while(attrNames.hasNext()){
            final String name = (String)attrNames.next();
            if(!enabledAttributeSet.isEmpty()
                 && !enabledAttributeSet.contains(name)){
                continue;
            }
            buf.append(name);
            buf.append(ATTRIBUTE_VALUE_SEPARATOR);
            if(secretAttributeSet.contains(name)){
                buf.append(getSecretString());
            }else{
                makeObjectFormat(
                    finder,
                    key,
                    context.getAttribute(name),
                    buf
                );
            }
            if(attrNames.hasNext()){
                buf.append(ATTRIBUTE_SEPARATOR);
            }
        }
        return buf;
    }
}
