/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import java.util.*;
import java.io.Serializable;

import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

import jp.ossc.tstruts.common.InvocationContext;

/**
 * {@link InvocationContext}tH[}bgGfB^B<p>
 * 
 * @author M.Takata
 */
public class InvocationContextJournalEditor
 extends BlockJournalEditorServiceBase
 implements InvocationContextJournalEditorMBean, Serializable{
    
    private static final String DEFAULT_SECRET_STRING = "******";
    private static final String ATTRIBUTE_SEPARATOR = " = ";
    
    private static final String HEADER = "[InvocationContext]";
    private static final String REQUEST_ID_HEADER = "Request ID : ";
    private static final String USER_PROFILE_HEADER = "UserProfile : ";
    private static final String ACTION_FORM_HEADER = "ActionForm : ";
    private static final String ATTRIBUTES_HEADER = "Attributes : ";
    private static final String ERRORS_HEADER = "Errors : ";
    private static final String FORWARD_NAME_HEADER = "Forward Name : ";
    
    private boolean isOutputRequestId = true;
    private boolean isOutputUserProfile = true;
    private boolean isOutputActionForm = true;
    private boolean isOutputAttributes = true;
    private boolean isOutputErrors = true;
    private boolean isOutputForwardName = true;
    
    private String secretString = DEFAULT_SECRET_STRING;
    private String[] secretAttributes;
    protected Set secretAttributeSet;
    private String[] enabledAttributes;
    protected Set enabledAttributeSet;
    
    public InvocationContextJournalEditor(){
        super();
        setHeader(HEADER);
    }
    
    public void setSecretString(String str){
        secretString = str;
    }
    
    public String getSecretString(){
        return secretString;
    }
    
    public void setSecretAttributes(String[] names){
        secretAttributes = names;
    }
    
    public String[] getSecretAttributes(){
        return secretAttributes;
    }
    
    public void setOutputRequestId(boolean isOutput){
        isOutputRequestId = isOutput;
    }
    
    public boolean isOutputRequestId(){
        return isOutputRequestId;
    }
    
    public void setOutputUserProfile(boolean isOutput){
        isOutputUserProfile = isOutput;
    }
    
    public boolean isOutputUserProfile(){
        return isOutputUserProfile;
    }
    
    public void setOutputActionForm(boolean isOutput){
        isOutputActionForm = isOutput;
    }
    
    public boolean isOutputActionForm(){
        return isOutputActionForm;
    }
    
    public void setOutputAttributes(boolean isOutput){
        isOutputAttributes = isOutput;
    }
    
    public boolean isOutputAttributes(){
        return isOutputAttributes;
    }
    
    public void setOutputErrors(boolean isOutput){
        isOutputErrors = isOutput;
    }
    
    public boolean isOutputErrors(){
        return isOutputErrors;
    }
    
    public void setOutputForwardName(boolean isOutput){
        isOutputForwardName = isOutput;
    }
    
    public boolean isOutputForwardName(){
        return isOutputForwardName;
    }
    
    public void setEnabledAttributes(String[] names){
        enabledAttributes = names;
    }
    
    public String[] getEnabledAttributes(){
        return enabledAttributes;
    }
    
    public void createService(){
        secretAttributeSet = new HashSet();
        enabledAttributeSet = new HashSet();
    }
    
    public void startService(){
        if(secretAttributes != null){
            for(int i = 0; i < secretAttributes.length; i++){
                secretAttributeSet.add(secretAttributes[i]);
            }
        }
        if(enabledAttributes != null){
            for(int i = 0; i < enabledAttributes.length; i++){
                enabledAttributeSet.add(enabledAttributes[i]);
            }
        }
    }
    
    public void stopService(){
        secretAttributeSet.clear();
        enabledAttributeSet.clear();
    }
    
    public void destroyService(){
        secretAttributeSet = null;
        enabledAttributeSet = null;
    }
    
    protected boolean processBlock(
        EditorFinder finder,
        Object key,
        Object value,
        StringBuffer buf
    ){
        final InvocationContext context = (InvocationContext)value;
        boolean isMake = false;
        if(isOutputRequestId()){
            makeRequestIdFormat(finder, key, context, buf);
            isMake = true;
        }
        if(isOutputUserProfile()){
            if(isMake){
                buf.append(getLineSeparator());
            }
            makeUserProfileFormat(finder, key, context, buf);
            isMake = true;
        }
        if(isOutputActionForm()){
            if(isMake){
                buf.append(getLineSeparator());
            }
            makeActionFormFormat(finder, key, context, buf);
            isMake = true;
        }
        if(isOutputAttributes()){
            if(isMake){
                buf.append(getLineSeparator());
            }
            makeAttributesFormat(finder, key, context, buf);
            isMake = true;
        }
        if(isOutputErrors()){
            if(isMake){
                buf.append(getLineSeparator());
            }
            makeErrorsFormat(finder, key, context, buf);
            isMake = true;
        }
        if(isOutputForwardName()){
            if(isMake){
                buf.append(getLineSeparator());
            }
            makeForwardNameFormat(finder, key, context, buf);
            isMake = true;
        }
        return isMake;
    }
    
    protected StringBuffer makeRequestIdFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        StringBuffer buf
    ){
        return buf.append(REQUEST_ID_HEADER).append(context.getRequestID());
    }
    
    protected StringBuffer makeUserProfileFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        StringBuffer buf
    ){
        buf.append(USER_PROFILE_HEADER);
        return makeObjectFormat(finder, key, context.getUserProfile(), buf);
    }
    
    protected StringBuffer makeActionFormFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        StringBuffer buf
    ){
        buf.append(ACTION_FORM_HEADER);
        return makeObjectFormat(finder, key, context.getActionForm(), buf);
    }
    
    protected StringBuffer makeAttributesFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        StringBuffer buf
    ){
        buf.append(ATTRIBUTES_HEADER);
        final Iterator attrNames = context.getAttributeNames();
        if(attrNames.hasNext()){
            buf.append(getLineSeparator());
        }else{
            buf.append(NULL_STRING);
            return buf;
        }
        final StringBuffer subBuf = new StringBuffer();
        while(attrNames.hasNext()){
            final String name = (String)attrNames.next();
            if(!enabledAttributeSet.isEmpty()
                 && !enabledAttributeSet.contains(name)){
                continue;
            }
            subBuf.append(name);
            subBuf.append(ATTRIBUTE_SEPARATOR);
            if(secretAttributeSet.contains(name)){
                subBuf.append(getSecretString());
            }else{
                makeObjectFormat(
                    finder,
                    key,
                    context.getAttribute(name),
                    subBuf
                );
            }
            if(attrNames.hasNext()){
                subBuf.append(getLineSeparator());
            }
        }
        addIndent(subBuf);
        return buf.append(subBuf);
    }
    
    protected StringBuffer makeErrorsFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        StringBuffer buf
    ){
        buf.append(ERRORS_HEADER);
        final String[] errorKeys = context.getErrorKeys();
        if(errorKeys != null && errorKeys.length != 0){
            buf.append(getLineSeparator());
        }else{
            buf.append(NULL_STRING);
            return buf;
        }
        final StringBuffer subBuf = new StringBuffer();
        for(int i = 0, max = errorKeys.length; i < max; i++){
            makeObjectFormat(
                finder,
                key,
                context.getError(errorKeys[i]),
                subBuf
            );
            if(i != max - 1){
                subBuf.append(getLineSeparator());
            }
        }
        addIndent(subBuf);
        return buf.append(subBuf);
    }
    
    protected StringBuffer makeForwardNameFormat(
        EditorFinder finder,
        Object key,
        InvocationContext context,
        StringBuffer buf
    ){
        return buf.append(FORWARD_NAME_HEADER).append(context.getForwardName());
    }
}