/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.business;

import jp.ossc.nimbus.service.journal.editor.MapJournalEditorServiceBaseMBean;

/**
 * {@link InvocationContextMapJournalEditor}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see InvocationContextMapJournalEditor
 */
public interface InvocationContextMapJournalEditorMBean
 extends MapJournalEditorServiceBaseMBean{
    
    public static final String REQUEST_ID_KEY = "RequestID";
    public static final String USER_PROFILE_KEY = "UserProfile";
    public static final String ACTION_FORM_KEY = "ActionForm";
    public static final String ATTRIBUTES_KEY = "Attributes";
    public static final String ERRORS_KEY = "Errors";
    public static final String FORWARD_NAME_KEY = "ForwardName";
    
    /**
     * {@link jp.ossc.tstruts.common.InvocationContext InvocationContext}̑W[iɏo͂鎞ɁAlB̖Ozݒ肷B<p>
     *
     * @param names lB̖Oz
     * @see #getSecretString()
     */
    public void setSecretAttributes(String[] names);
    
    /**
     * {@link jp.ossc.tstruts.common.InvocationContext InvocationContext}̑W[iɏo͂鎞ɁAlB̖Oz擾B<p>
     *
     * @return lB̖Oz
     * @see #setSecretAttributes(String[])
     */
    public String[] getSecretAttributes();
    
    /**
     * {@link jp.ossc.tstruts.common.InvocationContext InvocationContext}̑W[iɏo͂鎞ɁAlo͂鑮̖Ozݒ肷B<p>
     *
     * @param names lo͂鑮̖Oz
     * @see #getSecretString()
     */
    public void setEnabledAttributes(String[] names);
    
    /**
     * {@link jp.ossc.tstruts.common.InvocationContext InvocationContext}̑W[iɏo͂鎞ɁAlo͂鑮̖Oz擾B<p>
     *
     * @return lo͂鑮̖Oz
     * @see #setSecretAttributes(String[])
     */
    public String[] getEnabledAttributes();
    
    /**
     * NGXgIDo͂邩ǂݒ肷B<p>
     *
     * @param isOutput o͂ꍇtrue
     * @see #isOutputRequestId()
     */
    public void setOutputRequestId(boolean isOutput);
    
    /**
     * NGXgIDo͂邩ǂ𒲂ׂB<p>
     *
     * @param isOutput truȅꍇAo͂
     * @see #setOutputRequestId(boolean)
     */
    public boolean isOutputRequestId();
    
    /**
     * [Uvt@Co͂邩ǂݒ肷B<p>
     *
     * @param isOutput o͂ꍇtrue
     * @see #isOutputUserProfile()
     */
    public void setOutputUserProfile(boolean isOutput);
    
    /**
     * [Uvt@Co͂邩ǂ𒲂ׂB<p>
     *
     * @param isOutput truȅꍇAo͂
     * @see #setOutputUserProfile(boolean)
     */
    public boolean isOutputUserProfile();
    
    /**
     * {@link org.apache.struts.action.ActionForm ActionForm}o͂邩ǂݒ肷B<p>
     *
     * @param isOutput o͂ꍇtrue
     * @see #isOutputActionForm()
     */
    public void setOutputActionForm(boolean isOutput);
    
    /**
     * {@link org.apache.struts.action.ActionForm ActionForm}o͂邩ǂ𒲂ׂB<p>
     *
     * @param isOutput truȅꍇAo͂
     * @see #setOutputActionForm(boolean)
     */
    public boolean isOutputActionForm();
    
    /**
     * o͂邩ǂݒ肷B<p>
     *
     * @param isOutput o͂ꍇtrue
     * @see #isOutputAttributes()
     */
    public void setOutputAttributes(boolean isOutput);
    
    /**
     * o͂邩ǂ𒲂ׂB<p>
     *
     * @param isOutput truȅꍇAo͂
     * @see #setOutputAttributes(boolean)
     */
    public boolean isOutputAttributes();
    
    /**
     * ActionErroro͂邩ǂݒ肷B<p>
     *
     * @param isOutput o͂ꍇtrue
     * @see #isOutputErrors()
     */
    public void setOutputErrors(boolean isOutput);
    
    /**
     * ActionErroro͂邩ǂ𒲂ׂB<p>
     *
     * @param isOutput truȅꍇAo͂
     * @see #setOutputErrors(boolean)
     */
    public boolean isOutputErrors();
    
    /**
     * tH[ho͂邩ǂݒ肷B<p>
     *
     * @param isOutput o͂ꍇtrue
     * @see #isOutputForwardName()
     */
    public void setOutputForwardName(boolean isOutput);
    
    /**
     * tH[ho͂邩ǂ𒲂ׂB<p>
     *
     * @param isOutput truȅꍇAo͂
     * @see #setOutputForwardName(boolean)
     */
    public boolean isOutputForwardName();
}