/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
 package jp.ossc.tstruts.action.ejb.business;

/**
 * gUNV𐧌䂷邽߂̃C^tF[XB<p>
 * EJBReiɂgUNVAƖNXPʂŎgpł悤ɂ̂łB{@link #setTransactionAttribute(String)}̈ŁAgUNV^Cvw肷BgUNV^Cvɂ́A{@link #REQUIRED}A{@link #REQUIRESNEW}A{@link #SUPPORTS}A{@link #MANDATORY}A{@link #NEVER}A{@link #NOT_SUPPORTED}̂UނB<br>
 * ܂AgUNṼ^CAEgƖNXɎw肷鎖łB<br>
 * <p>
 * TStrutst[[Nł́ANimbusvWFNg̃T[rXՂgpāAƖNX̃T[rXƂĎB̂߁AƖO[v`t@CɁAeƖNXT[rXƂĒ`AƖNX̑ݒ肷鎖łBgUNV^Cv́A"TransactionAttribute"ƂāAgUNV^CAEǵA"TransactionTimeout"ƂāAƖO[v`t@C&lt;attribute&gt;vfŐݒ肷B<br>
 * <pre>
 *   &lt;server&gt;
 *     &lt;manager name="Group1"&gt;
 *              :
 *       &lt;service code="test.Business1" name="Business1"&gt;
 *         &lt;attribute name="TransactionAttribute"&gt;NotSupported&lt;/attribute&gt;
 *         &lt;attribute name="TransactionTimeout"&gt;10&lt;/attribute&gt;
 *       &lt;/service&gt;
 *              :
 * </pre>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 * @see <a href="doc-files/business-group1.xml">ƖO[v`t@CTv</a>
 */
public interface TransactionSupport{
    
    /**
     * gUNV^Cv RequiredB<p>
     * gUNVȂΐVJnBΉȂB
     */
    public static final String REQUIRED = "Required";
    
    /**
     * gUNV^Cv RequiresNewB<p>
     * gUNVȂΐVJnBsuspendĐVJnB
     */
    public static final String REQUIRESNEW = "RequiresNew";
    
    /**
     * gUNV^Cv NotSupportedB<p>
     * gUNVĂAȂĂȂB
     */
    public static final String SUPPORTS = "Supports";
    
    /**
     * gUNV^Cv MandatoryB<p>
     * gUNVȂ΃G[BΉȂB
     */
    public static final String MANDATORY = "Mandatory";
    
    /**
     * gUNV^Cv NeverB<p>
     * gUNVȂΉȂB΃G[B
     */
    public static final String NEVER = "Never";
    
    /**
     * gUNV^Cv SupportsB<p>
     * gUNVȂΉȂBΒ~B
     */
    public static final String NOT_SUPPORTED = "NotSupported";
    
    /**
     * gUNV^Cvݒ肷B<p>
     * TStrutst[[Nł́AƖO[v`t@C&lt;attribute&gt;vfŐݒ肷B
     *
     * @param type gUNV^Cv
     * @see #REQUIRED
     * @see #REQUIRESNEW
     * @see #SUPPORTS
     * @see #MANDATORY
     * @see #NEVER
     * @see #NOT_SUPPORTED
     * @see <a href="doc-files/business-group1.xml">ƖO[v`t@CTv</a>
     * @see #getTransactionAttribute()
     */
    public void setTransactionAttribute(String type);
    
    /**
     * gUNV^Cv擾B<p>
     *
     * @return gUNV^Cv
     * @see #REQUIRED
     * @see #REQUIRESNEW
     * @see #SUPPORTS
     * @see #MANDATORY
     * @see #NEVER
     * @see #NOT_SUPPORTED
     * @see #setTransactionAttribute(String)
     */
    public String getTransactionAttribute();
    
    /**
     * gUNV^CAEgݒ肷B<p>
     * ƖNXɃgUNV^CAEgݒłBAAgUNV^CvA{@link #REQUIRED}A{@link #REQUIRESNEW}̏ꍇAgUNVVJnꂽꍇɂAgUNVɐݒ肳B<br>
     * <p>
     * TStrutst[[Nł́AƖO[v`t@C&lt;attribute&gt;vfŐݒ肷BPʂ͕błB<br>
     *
     * @param type gUNV^CAEg[s]
     * @see <a href="doc-files/business-group1.xml">ƖO[v`t@CTv</a>
     * @see #getTransactionTimeout()
     */
    public void setTransactionTimeout(int seconds);
    
    /**
     * gUNV^CAEg擾B<p>
     * Pʂ͕błB<br>
     *
     * @return gUNV^CAEg[s]
     * @see #setTransactionTimeout(int)
     */
    public int getTransactionTimeout();
}