/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.ejb.facade;

import javax.ejb.EJBObject;

import jp.ossc.tstruts.action.ejb.*;
import jp.ossc.tstruts.common.InvocationContext;

/**
 * ƖO[vEJB[gC^tF[XB<p>
 * ƖO[vFacadeƂȂStateless Session Beañ[gC^tF[XłB<br>
 * EJB[gC^tF[XgpꍇAEJB̃fvCgLqqejb-jar.xml&lt;remote&gt;vfɁÃNX̃NXw肷KvB<br>
 * <pre>
 *   &lt;ejb-jar&gt;
 *     &lt;enterprise-beans&gt;
 *       &lt;session&gt;
 *         &lt;ejb-name&gt;BusinessGroup1&lt;/ejb-name&gt;
 *               :
 *         &lt;remote&gt;jp.ossc.tstruts.action.ejb.facade.BusinessGroup&lt;/remote&gt;
 *               :
 * </pre>
 * EJB́AStateless Session EJBȂ̂ŁA&lt;session-type&gt;vfŁA"Stateless"w肷KvB܂AgUNV̐EJBReił͂ȂÃt[[NōŝŁA&lt;transaction-type&gt;vfŁA"Bean"w肷KvB
 * <pre>
 *               :
 *         &lt;session-type&gt;Stateless&lt;/session-type&gt;
 *         &lt;transaction-type&gt;Bean&lt;/transaction-type&gt;
 *               :
 * </pre>
 * ̋ƖO[vEJBɂăO[sOƖ̋ƖO[vA&lt;env-entry&gt;vfŎw肷B&lt;env-entry-name&gt;vf"group-name"A&lt;env-entry-type&gt;vf"java.lang.String"A&lt;env-entry-value&gt;vfɔCӂ̃O[vw肷B<br>
 * <pre>
 *               :
 *         &lt;env-entry&gt;
 *           &lt;env-entry-name&gt;group-name&lt;/env-entry-name&gt;
 *           &lt;env-entry-type&gt;java.lang.String&lt;/env-entry-type&gt;
 *           &lt;env-entry-value&gt;Group1&lt;/env-entry-value&gt;
 *         &lt;/env-entry&gt;
 *               :
 * </pre>
 * AAŎw肷ƖO[v́AΉƖO[v`t@CŎw肷&lt;manager&gt;name̒lƈvȂ΂ȂȂB
 * <pre>
 *   &lt;server&gt;
 *     &lt;manager name="Group1"&gt;
 *               :
 * </pre>
 * ̃NX́AƖNXFacadeƂȂEJBŁA{@link #doBusiness(String, InvocationContext)}\bhŋƖw肷鎖ŁÃNXɂăO[sOĂƖNXĂяołB̃NXŃO[sOƖNX̒`́ALŏqׂejb-jar.xml&lt;env-entry&gt;vfŎw肵"group-name"ƓO[vAƖO[v`t@C&lt;manager&gt;vf̎qvf&lt;service&gt;Œ`B<br>
 * <pre>
 *               :
 *       &lt;service code="test.Business1" name="Business1"&gt;
 *         &lt;attribute name="TransactionAttribute"&gt;NotSupported&lt;/attribute&gt;
 *         &lt;attribute name="TransactionTimeout"&gt;10&lt;/attribute&gt;
 *       &lt;/service&gt;
 *               :
 *     &lt;/manager&gt;
 *   &lt;/server&gt;
 * </pre>
 * ̋ƖO[v̋Ɩ瑼̋ƖO[v̋ƖĂяoꍇɂ́AĂяoƖO[v&lt;ejb-ref&gt;vfŎw肷KvB
 * <pre>
 *   &lt;ejb-jar&gt;
 *     &lt;enterprise-beans&gt;
 *       &lt;session&gt;
 *               :
 *         &lt;ejb-ref&gt;
 *           &lt;ejb-ref-name&gt;Group2&lt;/ejb-ref-name&gt;
 *           &lt;ejb-ref-type&gt;Session&lt;/ejb-ref-type&gt;
 *           &lt;home&gt;jp.ossc.tstruts.action.ejb.facade.BusinessGroupHome&lt;/home&gt;
 *           &lt;remote&gt;jp.ossc.tstruts.action.ejb.facade.BusinessGroup&lt;/remote&gt;
 *         &lt;/ejb-ref&gt;
 *               :
 * </pre>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 * @see BusinessGroupHome
 * @see BusinessGroupBean
 * @see <a href="doc-files/ejb-jar.xml">ejb-jar.xmlTv</a>
 * @see <a href="../business/doc-files/business-group1.xml">ƖO[v`t@CTv</a>
 * @see <a href="../business/doc-files/nimbus-service.dtd.txt">ƖO[v`t@CDTDiNimbusT[rX`t@Cj</a>
 */
public interface BusinessGroup extends EJBObject{
    
    /**
     * ƖO[v擾B<p>
     * EJB̃fvCgLqqejb-jar.xml&lt;env-entry&gt;vfŎw肵"group-name"擾łB<br>
     * &lt;env-entry&gt;vf̎ẃAȉ̂悤ɍsB
     * <pre>
     *               :
     *         &lt;env-entry&gt;
     *           &lt;env-entry-name&gt;group-name&lt;/env-entry-name&gt;
     *           &lt;env-entry-type&gt;java.lang.String&lt;/env-entry-type&gt;
     *           &lt;env-entry-value&gt;Group1&lt;/env-entry-value&gt;
     *         &lt;/env-entry&gt;
     *               :
     * </pre>
     * AA&lt;env-entry-value&gt;vfŎw肷ƖO[v́AΉƖO[v`t@CŎw肷&lt;manager&gt;name̒lƈvȂ΂ȂȂB
     * 
     * @return ƖO[v
     * @exception java.rmi.RemoteException
     * @see <a href="doc-files/ejb-jar.xml">ejb-jar.xmlTv</a>
     * @see <a href="../business/doc-files/business-group1.xml">ƖO[v`t@CTv</a>
     */
    public String getGroupName() throws java.rmi.RemoteException;
    
    /**
     * ̋ƖO[v́Aw肳ꂽƖ̋ƖsB<p>
     * Ŏw肷Ɩ́AƖO[v`t@C&lt;service&gt;vfnameŎw肳ꂽOłB<br>
     *
     * @param name Ɩ
     * @param context sɕKvȂ̂i[ReLXg
     * @return sʂi[ReLXg
     * @exception java.rmi.RemoteException
     * @exception BusinessException ƖsɗOꍇ
     * @exception BusinessSystemException EJBt[[NŗOꍇ
     * @see jp.ossc.tstruts.action.ejb.BusinessGroupNotFoundException
     * @see jp.ossc.tstruts.action.ejb.BusinessNotFoundException
     * @see jp.ossc.tstruts.action.ejb.BusinessTransactionManagerException
     * @see jp.ossc.tstruts.action.ejb.IllegalBusinessStateException
     */
    public InvocationContext doBusiness(String name, InvocationContext context)
     throws java.rmi.RemoteException, BusinessException,
            BusinessSystemException;
}