/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.forward;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.jexl.JexlContext;

/**
 * 
 * @author kurosawa
 * @version $Revision: 1.1 $
 */
public class ForwardContext implements JexlContext, Map {
	
	protected HttpServletRequest request;
	protected HttpSession session;
	protected ServletContext context;
	
	public ForwardContext(HttpServletRequest request, ServletContext context) {
		this.request = request;
		session = request.getSession(false);
		this.context = context;
	}

	/* (non-Javadoc)
	 * @see org.apache.commons.jexl.JexlContext#setVars(java.util.Map)
	 */
	public void setVars(Map arg0) {
		throw new UnsupportedOperationException("setVars");
	}

	/* (non-Javadoc)
	 * @see org.apache.commons.jexl.JexlContext#getVars()
	 */
	public Map getVars() {
		return this;
	}

	/**
	 * ̃\bh͌Ăł
	 */
	public void clear() {
		// don't anything
	}

	/* (non-Javadoc)
	 * @see java.util.Map#containsKey(java.lang.Object)
	 */
	public boolean containsKey(Object key) {
		Object value = get(key);
		return value != null;
	}

	/* (non-Javadoc)
	 * @see java.util.Map#containsValue(java.lang.Object)
	 */
	public boolean containsValue(Object arg0) {
		throw new UnsupportedOperationException("containsValue");
	}

	/* (non-Javadoc)
	 * @see java.util.Map#entrySet()
	 */
	public Set entrySet() {
		throw new UnsupportedOperationException("entrySet");
	}

	/* (non-Javadoc)
	 * @see java.util.Map#get(java.lang.Object)
	 */
	public Object get(Object keyObj) {
		String key = keyObj.toString();
		if (key.equals("REQUEST")) {
			return request;
		}
		if (key.equals("SESSION")) {
			return session;
		}
		if (key.equals("APPLICATION")) {
			return context;
		}
		Object value = request.getAttribute(key);
		if (value != null) {
			return value;
		}
		if (session != null) {
			value = session.getAttribute(key);
			if (value != null) {
				return value;
			}
		}
		value = context.getAttribute(key);
		if (value != null) {
			return value;
		}

		return null;
	}

	/* (non-Javadoc)
	 * @see java.util.Map#isEmpty()
	 */
	public boolean isEmpty() {
		throw new UnsupportedOperationException("isEmpty");
	}

	/* (non-Javadoc)
	 * @see java.util.Map#keySet()
	 */
	public Set keySet() {
		throw new UnsupportedOperationException("keySet");
	}

	/* (non-Javadoc)
	 * @see java.util.Map#put(java.lang.Object, java.lang.Object)
	 */
	public Object put(Object arg0, Object arg1) {
		throw new UnsupportedOperationException("put");
	}

	/* (non-Javadoc)
	 * @see java.util.Map#putAll(java.util.Map)
	 */
	public void putAll(Map arg0) {
		throw new UnsupportedOperationException("putAll");
	}

	/* (non-Javadoc)
	 * @see java.util.Map#remove(java.lang.Object)
	 */
	public Object remove(Object arg0) {
		throw new UnsupportedOperationException("remove");
	}

	/* (non-Javadoc)
	 * @see java.util.Map#size()
	 */
	public int size() {
		throw new UnsupportedOperationException("size");
	}

	/* (non-Javadoc)
	 * @see java.util.Map#values()
	 */
	public Collection values() {
		throw new UnsupportedOperationException("values");
	}
}
