/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.transaction;

import java.util.Vector;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.action.transaction.IllegalTrStateException;

/**
 * dMh~@\gpɁALbṼNGXg𔻒肷NXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author sakata
 * @since 1.0
 */

public class TransactionControl{

	/**
	 * TransactionControlNXŎgpłorg.apache.commons.logging.Log̎łB
	 */
	protected static final Log log = LogFactory.getLog(TransactionControl.class);

	/** dMh~p̃L[ */
	private String transactionId = null;
	
	/** T[ubgpX */
	private String servletPath=null; 
	
	/** TransactionIdi[̈ */	
	private Vector transactedList = null;
	
    public TransactionControl(){
    }
    
	/**
	 * dMh~@\gpɁALbṼNGXg𔻒肷郁\bhB<p>
	 * SessionɊi[ĂTransactionId+ServletURLƁAHiddenTransactionTokenőML[ł邩肷B<br>
	 * SessionɊi[ĂTransactionTokenHiddenڂőML[ꍇALbVƔfIllegalTrStateException()Throw܂B<br>
	 * HiddenڂTransactionTokenNGXgɓĂȂꍇiAhXo[̒ړ͂ȂǁjAIllegalTrStateException()Throw܂B<br>
	 * @param request HTTPNGXg
	 * @param action &lt;action&gt;vf\ActionIuWFNg
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @exception IOException
	 * @exception ServletException
	 * @exception IllegalTrStateException@dMh~ThrowException
	 */    
	public void checkTransactionId(
		HttpServletRequest request,
		Action action,
		ActionMapping mapping
		) throws IOException, ServletException {
			log.debug("checkTransactedId() start");
			//NGXgオĂTransactedId擾
			transactionId =(String) request.getParameter(MyGlobals.TRANSACTION_TOKEN_KEY);
			log.debug("transactionId value in request : " + transactionId);

			if(transactionId==null){
				log.debug("There is no tstruts tag.");
				throw new IllegalTrStateException();
			}
			
			//ServletPath擾
			String servletPath =(String) request.getServletPath();
			log.debug("servletPath value in request : " + servletPath);
				
			//ServletPathtransactedIdKey𐶐
			String key = servletPath + transactionId;
			log.debug("key in session : " + key);
				
			HttpSession session =  request.getSession();
			synchronized (session){
				log.debug("synchrnized start");
				//ZbVTransacted擾
				transactedList = (Vector)session.getAttribute("TransactedList");

				if(transactedList != null){
					int existKey = transactedList.indexOf(key);
					log.debug("existKey : " + existKey);
					if(existKey != -1){
						log.debug("It is the request which came from the cashe page.(deter Request)");
						throw new IllegalTrStateException();							
					}
				}
			}						
		}	

	public void saveTransactionId(
		HttpServletRequest request,
		int transactedMax
		) throws IOException, ServletException {

		//ServletPath擾
		servletPath =(String) request.getServletPath();
		log.debug("servletPath value in request : " + servletPath);
		
		//NGXgオĂtransactionId擾
		String reqtransactionId =(String) request.getParameter(MyGlobals.TRANSACTION_TOKEN_KEY);
		log.debug("reqTransactionId value in request "+ reqtransactionId);

		//ServletPathtransactionIdKey𐶐
		String key = servletPath + reqtransactionId;
		log.debug("key:" + key);
		log.debug("transactedMax:" + transactedMax);												

		HttpSession session =  request.getSession();
		log.debug("session: " + session);												
		synchronized (session){
			log.debug("session synchrnized start");
			//ZbVTransacted擾
			transactedList = (Vector)session.getAttribute("TransactedList");

			if(transactedList != null){
				//L[gp
				if( transactedList.size() < transactedMax ) {
					transactedList.add( key );
				} else {
					transactedList.remove( transactedList.firstElement() );
					transactedList.add( key );
				}
			}else{
				transactedList = new Vector(transactedMax);
				transactedList.add(key);
			}

			session.setAttribute("TransactedList",transactedList);
		}								
	}
}