/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.transaction;

import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.action.transaction.TransactionCreateId;

/**
 * dMh~@\gpɁATransactionId𐶐SessionRequestɊi[NXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author sakata
 * @since 1.0
 */
public class TransactionCreateToken{

	/**
	 * TransactionCreateTokenNXŎgpłorg.apache.commons.logging.Log̎łB
	 */
	protected static final Log log = LogFactory.getLog(TransactionCreateToken.class);

	/** dM}~̃L[JE^ől (ftHgF50)*/
	private int transactedCounterMax = 50;
    
	/** dMh~p̃L[ */
	private String transactionId = null;
	
	/** T[ubgpX */
	private String servletPath=null; 
	
	/** TransactionIdi[̈ */	
	private Vector transactedList = null;

    
    public TransactionCreateToken(){
    }
    
	/**
	 * dMh~@\gpɁATransactionId𐶐SessionRequestɊi[郁\bhB<p>
	 * TransactionId𐶐ASessionRequestɊi[B<br>
	 * RequestɊi[TransactionIdHiddenTransacitonTokenƂExtendFormTagNXœWJ܂B<br>
	 * SessionɊi[TransactionIdtransactedMaxzƎn߂Ɋi[ꂽtransactionId폜܂B<br>
	 * 	 * @param request HTTPNGXg
	 * @param action &lt;action&gt;vf\ActionIuWFNg
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param transactedMax@SessionɊi[łTransactionId̍ől 
	 */ 
	 public void createTransactionId(
		HttpServletRequest request)
	 {

			TransactionCreateId tcounter= new TransactionCreateId();
			transactionId = tcounter.createTransactionId();
			log.debug("transactionId value in TransactedCounter : " + transactionId);

			//NGXgtransactionIdi[
			request.setAttribute(MyGlobals.TRANSACTION_TOKEN_KEY,transactionId);

	}	
}