/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.web;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;

import jp.ossc.nimbus.service.ejb.EJBFactory;
import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.action.ExtendActionMapping;
import jp.ossc.tstruts.action.ejb.BusinessException;
import jp.ossc.tstruts.action.ejb.BusinessGroupNotFoundException;
import jp.ossc.tstruts.action.ejb.facade.BusinessGroup;
import jp.ossc.tstruts.action.ejb.facade.BusinessGroupHome;
import jp.ossc.tstruts.common.InvocationContext;
import jp.ossc.tstruts.config.InterceptorConfig;
import jp.ossc.tstruts.config.SubModuleConfigImpl;
import jp.ossc.tstruts.util.MyServiceUtil;
/**
 * ƖFacadeƂȂEJBĂяoActionNXB<p>
 * &lt;action&gt;vfparameterŌĂяoƖO[vƋƖw肳āA{@link EJBFactory}gāAƖO[vEJB擾āAƖ̌ĂяosB<br>
 * EJBFactorýANimbus̃T[rXgp邽߁AOɃT[rX̒`sĂKvBNimbus̃T[rX`ł́AT[rXǗ}l[W̖OƂŊǗT[rX̖O`B̃NXŎgpEJBFactoryT[rX̃T[rX́A{@link #EJB_FACTORY_NAME}ł̂ŁAT[rX`t@CEJBFactory&lt;service&gt;vfnameɓOw肷KvB<br>
 * ܂ÃT[rXǗ}l[W̖ÓAstruts-config.xmlɃvOCƂĐݒ肷{@link SystemConfig}̑SystemServiceManagerNameŐݒ肷鎖ł̂ŁAT[rX`t@C&lt;manager&gt;vf̖OƈvKvB<br>
 * <p>
 * Ɩ̌ĂяoIƁAĂяoʂ{@link InvocationContext}{@link DynaActionForm}oāA&lt;select-forward&gt;vfpropertyŎw肳ꂽvpeB擾B̃vpeB̒l&lt;forward-value&gt;vfvalue̒lƈv&lt;forward-value&gt;vfnameɎw肳ꂽtH[htH[hɃtH[hBY&lt;forward-value&gt;vfȂꍇ́A&lt;forward-default&gt;vfnameɎw肳ꂽtH[htH[hɃtH[hB<br>
 *
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 * @see InvocationContext
 * @see BusinessGroup
 * @see <a href="../doc-files/tstruts-client-service.xml">NCAgpT[rX`t@CiNimbusT[rX`j</a>
 */
public class EJBAction extends Action {

	/**
	 * EJBFactorỹT[rXB<p>
	 */
	protected static final String EJB_FACTORY_NAME = "BusinessGroupFactory";

	/**
	 * &lt;action&gt;vfparameterœnĂяoƖO[vƋƖ̃Zp[^B<p>
	 */
	protected static final char PARAM_SEPARATOR = '#';

	/**
	 * OóB<p>
	 */
	protected static final Log log = LogFactory.getLog(EJBAction.class);

	/**
	 * Ɩ̌ĂяoƁǍʂɂtH[hsB<p>
	 * ł́Aȉ̃\bhԂɌĂяoB<br>
	 * <ol>
	 *   <li>{@link #findBusinessGroup(ActionMapping, HttpServletRequest)}</li>
	 *   <li>{@link #createInvocationContext(ActionMapping, ActionForm, HttpServletRequest)}</li>
	 *   <li>{@link #preCallBusiness(ActionMapping, InvocationContext, HttpServletRequest, HttpServletResponse)}</li>
	 *   <li>{@link #callBusiness(BusinessGroup, ActionMapping, HttpServletRequest, InvocationContext)}</li>
	 *   <li>{@link #postCallBusiness(ActionMapping, InvocationContext, HttpServletRequest, HttpServletResponse)}</li>
	 *   <li>{@link #forward(ActionMapping, InvocationContext)}</li>
	 * </ol>
	 *
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param form &lt;action&gt;vfɑΉActionFormIuWFNg
	 * @param request HTTPNGXg
	 * @param responce HTTPX|X
	 * @return tH[hActionForwardIuWFNg
	 * @exception Exception ɏps\Ȗ肪ꍇ
	 * @see #findBusinessGroup(ActionMapping, HttpServletRequest)
	 * @see #createInvocationContext(ActionMapping, ActionForm, HttpServletRequest)
	 * @see #preCallBusiness(ActionMapping, InvocationContext, HttpServletRequest, HttpServletResponse)
	 * @see #callBusiness(BusinessGroup, ActionMapping, HttpServletRequest, InvocationContext)
	 * @see #postCallBusiness(ActionMapping, InvocationContext, HttpServletRequest, HttpServletResponse)
	 * @see #forward(ActionMapping, InvocationContext)
	 */
	public ActionForward execute(
		ActionMapping mapping,
		ActionForm form,
		HttpServletRequest request,
		HttpServletResponse response)
		throws Exception {

		InvocationContext context =
			createInvocationContext(mapping, form, request);

		preCallBusiness(mapping, context, request, response);

		CallBusinessInterceptor first = null;
		String interceptor = ((ExtendActionMapping) mapping).getInterceptor();
		ModuleConfig config = ((ExtendActionMapping) mapping).getModuleConfig();

		if (interceptor == null) {
			InterceptorConfig interceptorConfig =
			((SubModuleConfigImpl)config).getInterceptorConfigs()
				.getDefaultInterceptorConfig();
			
			if (interceptorConfig != null) {
				first =	interceptorConfig.getFirstCallBusinessInterceptor();
			}
		} else {
			InterceptorConfig interceptorConfig =
			((SubModuleConfigImpl)config).getInterceptorConfigs()
				.getInterceptorConfig(interceptor);

			first = interceptorConfig.getFirstCallBusinessInterceptor();
		}

		final BusinessGroup group = null;
        if (first != null) {
            context = first.next(group, mapping, request, context, this);
		} else {
            context = callBusiness(group, mapping, request, context);
		}
		
		postCallBusiness(mapping, context, request, response);

		return forward(mapping, context);
	}

	/**
	 * ƖFacadeƂȂƖO[vEJB擾B<p>
	 * {@link EJBFactory}ɁA{@link #getBusinessGroupName(ActionMapping, HttpServletRequest)}Ŏ擾ƖO[vAEJBƂēnA{@link BusinessGroup}擾B<br>
	 * BusinessGrouplookupJNDÍAEJBFactory̑prefixɎw肳ꂽJNDIvtBNXƁAgetBusinessGroupName(ActionMapping, HttpServletRequest)Ŏ擾ƖO[vÂłB<br>
	 *
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param request HTTPNGXg
	 * @return ƖFacadeƂȂƖO[vEJB
	 * @exception Exception ƖO[vEJB̎擾ɗOꍇ
	 * @see #execute(ActionMapping, ActionForm, HttpServletRequest, HttpServletResponse)
	 * @see #getBusinessGroupName(ActionMapping, HttpServletRequest)
	 */
	protected BusinessGroup findBusinessGroup(
		ActionMapping mapping,
		HttpServletRequest request)
		throws Exception {
		final EJBFactory factory =
			(EJBFactory) MyServiceUtil.getServiceObjectBySystemConfigProperty(EJB_FACTORY_NAME);

		final String groupName = getBusinessGroupName(mapping, request);

		BusinessGroup group = null;
		try {
			group =
				(BusinessGroup) factory.get(
					groupName,
					BusinessGroupHome.class,
					BusinessGroup.class,
					null,
					null);
		} catch (NamingException e) {
			throw new BusinessGroupNotFoundException(groupName,e) ;
		} catch (CreateException e) {
			throw new BusinessGroupNotFoundException(groupName,e) ;
		} catch (NoSuchMethodException e) {
			throw new BusinessGroupNotFoundException(groupName,e) ;
		} catch (IllegalAccessException e) {
			throw new BusinessGroupNotFoundException(groupName,e) ;
		} catch (InvocationTargetException e) {
			throw new BusinessGroupNotFoundException(groupName,e) ;
		}
		return group;
	}

	/**
	 * ĂяoƖo^ĂƖO[v擾B<p>
	 * &lt;action&gt;vfparameterŎw肳ꂽ[ƖO[v]#[Ɩ]Ƃăp[XāAƖO[vԂB<br>
	 * parameter̎w蕶񂪏L̃p[XWbNɓKȂꍇ́AOthrowB<br>
	 * Ŏ擾ꂽƖO[v{@link EJBFactory}ɁAEJBƂēnāAƖFacadeƂȂEJBł{@link BusinessGroup}擾B  <br>
	 * 
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param request HTTPNGXg
	 * @return ƖO[v
	 * @exception Exception &lt;action&gt;vfparameter̎w蕶̃p[XɎsꍇ
	 * @see #findBusinessGroup(ActionMapping, HttpServletRequest)
	 */
	protected String getBusinessGroupName(
		ActionMapping mapping,
		HttpServletRequest request)
		throws Exception {
		final String parameter = mapping.getParameter();
		final int index = parameter.indexOf(PARAM_SEPARATOR);
		if (index == -1 || index == 0 || parameter.length() < index + 1) {
			throw new IllegalArgumentException(
				"Parameter is illegal : " + parameter);
		}
		return parameter.substring(0, index);
	}

	/**
	 * Ɩ̌ĂяoɁAƖsp[^i[{@link InvocationContext}IuWFNg𐶐B<p>
	 * ł́Aȉ̏sB<br>
	 * <ol>
	 *   <li>HTTPNGXgɐݒ肳ꂽInvocationContextIuWFNg擾B</li>
	 *   <li>{@link InvocationContext#setActionForm(ActionForm)}ŁAformݒ肷B</li>
	 *   <li>{@link InvocationContext#bridgeFromServletRequest(HttpServletRequest)}ŁArequest̏ݒ肷B</li>
	 * </ol>
	 * 
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param form &lt;action&gt;vfɑΉActionFormIuWFNg
	 * @param request HTTPNGXg
	 * @return Ɩsp[^i[InvocationContextIuWFNg
	 * @exception Exception ɏps\Ȗ肪ꍇ
	 * @see #execute(ActionMapping, ActionForm, HttpServletRequest, HttpServletResponse)
	 */
	protected InvocationContext createInvocationContext(
		ActionMapping mapping,
		ActionForm form,
		HttpServletRequest request)
		throws Exception {
		final InvocationContext context =
			(InvocationContext) request.getAttribute(
				MyGlobals.INVOCATION_CONTEXT_KEY);
		context.reset();
		context.setActionForm(form);
		context.bridgeFromServletRequest(request);
		return context;
	}

	/**
	 * ƖĂяoOsB<p>
	 * Ă̂ŁAKvȏꍇ́AI[o[Ch邱ƁB<br>
	 * 
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param context Ɩɓnsp[^i[InvocationContextIuWFNg
	 * @param request HTTPNGXg
	 * @param responce HTTPX|X
	 * @exception Exception ɏps\Ȗ肪ꍇ
	 * @see #execute(ActionMapping, ActionForm, HttpServletRequest, HttpServletResponse)
	 */
	protected void preCallBusiness(
		ActionMapping mapping,
		InvocationContext context,
		HttpServletRequest request,
		HttpServletResponse response)
		throws Exception {
	}

	/**
	 * ƖĂяoB<p>
	 * ł́Aȉ̏sB<br>
	 * <ol>
	 *   <li>{@link #getBusinessName(ActionMapping, HttpServletRequest)}Ŏ擾B</li>
	 *   <li>擾Ɩw肵āA{@link BusinessGroup#doBusiness(String, InvocationContext)}ĂяoB</li>
	 *   <li>{@link InvocationContext#bridgeToServletRequest(HttpServletRequest)}ŁArequestɏݒ肷B</li>
	 *   <li>ƖĂяosʂInvocationContextIuWFNgԂB</li>
	 * </ol>
	 *
	 * @param group ƖO[vEJB
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param request HTTPNGXg
	 * @param context Ɩsp[^i[InvocationContextIuWFNg
	 * @return Ɩsʂi[InvocationContextIuWFNg
	 * @exception Exception Ɩ̌ĂяoŗOꍇ
	 * @see #execute(ActionMapping, ActionForm, HttpServletRequest, HttpServletResponse)
	 * @see #getBusinessName(ActionMapping, HttpServletRequest)
	 */
	protected InvocationContext callBusiness(
		BusinessGroup group,
		ActionMapping mapping,
		HttpServletRequest request,
		InvocationContext context)
		throws Exception {
			
		if (group == null) {
			return null;
		}

		final String businessName = getBusinessName(mapping, request);
		InvocationContext ctx = null;
		try {
			// BLs
			ctx = group.doBusiness(businessName, context);
		} catch (RemoteException e) {
			throw e;
		} catch (BusinessException e) {
			throw e;
		}
		
		// BL߂ĂInvocationContextattributerequestɖ߂B
		ctx.bridgeToServletRequest(request);

		// BL߂ĂInvocationContext̂requestɖ߂B
		request.setAttribute(
			MyGlobals.INVOCATION_CONTEXT_KEY,
			ctx
		);
		
		// ߂ĂActionFormēxrequest/sessionɃZbgB
		// BLVMœ삵ĂƂ́ABLĂяoɓnActionForm
		// ߂ĂActionFormʐlȂ߁B
		ActionForm form = ctx.getActionForm();
		if (form != null) {
			if ("request".equals(mapping.getScope())) {
				request.setAttribute(mapping.getAttribute(), form);
			} else {
				HttpSession session = request.getSession();
				session.setAttribute(mapping.getAttribute(), form);
			}
		}

		// BLŔG[requestɃZbgB
		final String[] keys = ctx.getErrorKeys();
		if (keys != null && keys.length != 0) {
			ActionErrors errors = (ActionErrors)request.getAttribute(Globals.ERROR_KEY);
			if (errors == null) {
				errors = new ActionErrors();
			} 
			for (int i = 0; i < keys.length; i++) {
				errors.add(keys[i], ctx.getError(keys[i]));
			}
			request.setAttribute(Globals.ERROR_KEY, errors);
		}

		return ctx;
	}

	/**
	 * ĂяoƖ̋Ɩ擾B<p>
	 * &lt;action&gt;vfparameterŎw肳ꂽ[ƖO[v]#[Ɩ]Ƃăp[XāAƖԂB<br>
	 * parameter̎w蕶񂪏L̃p[XWbNɓKȂꍇ́AOthrowB<br>
	 * Ŏ擾ꂽƖ{@link BusinessGroup}ɁAƖƂēnāAƖ̎s˗B  <br>
	 * 
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param request HTTPNGXg
	 * @return Ɩ
	 * @exception Exception &lt;action&gt;vfparameter̎w蕶̃p[XɎsꍇ
	 * @see #callBusiness(BusinessGroup, ActionMapping, HttpServletRequest, InvocationContext)
	 */
	protected String getBusinessName(
		ActionMapping mapping,
		HttpServletRequest request)
		throws Exception {
		final String parameter = mapping.getParameter();
		final int index = parameter.indexOf(PARAM_SEPARATOR);
		if (index == -1 || index == 0 || parameter.length() < index + 1) {
			throw new IllegalArgumentException(
				"Parameter is illegal : " + parameter);
		}
		return parameter.substring(index + 1);
	}

	/**
	 * ƖĂяo㏈sB<p>
	 * Ă̂ŁAKvȏꍇ́AI[o[Ch邱ƁB<br>
	 * 
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param context Ɩɓnsp[^i[InvocationContextIuWFNg
	 * @param request HTTPNGXg
	 * @param responce HTTPX|X
	 * @exception Exception ɏps\Ȗ肪ꍇ
	 * @see #execute(ActionMapping, ActionForm, HttpServletRequest, HttpServletResponse)
	 */
	protected void postCallBusiness(
		ActionMapping mapping,
		InvocationContext context,
		HttpServletRequest request,
		HttpServletResponse response)
		throws Exception {
	}

	/**
	 * ƖĂяoʂtH[h肷B<p>
	 * {@link InvocationContext#getForwardName()}Ŏw肳ꂽtH[hɃtH[hBw肳ĂȂꍇ́ARequestProcessorɏϏ邽߁AnullԂB<br>
	 *
	 * @param mapping &lt;action&gt;vf\ActionMappingIuWFNg
	 * @param context ƖĂяoʂi[InvocationContextIuWFNg
	 * @return tH[hActionForwardIuWFNg
	 * @exception Exception ɏps\Ȗ肪ꍇ
	 */
	protected ActionForward forward(
		ActionMapping mapping,
		InvocationContext context)
		throws Exception {
		
		final String forwardName = context.getForwardName();
		if(forwardName != null){
			return mapping.findForward(forwardName);
		}
		return null;
	}

}