/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.auth;

import java.security.Principal;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.util.MessageResources;

import jp.ossc.tstruts.config.UserProfileConfig;
import jp.ossc.tstruts.config.UserProfilePropertyConfig;

/**
 * F؏̏NXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0aplha
 */
public class DefaultInitializer implements UserProfileInitializer {
	private static final Log log = LogFactory.getLog(DefaultInitializer.class);

	private UserProfileConfig config;

	/**
	 * InitializerNX̏
	 * @param config UserProfileConfig [Uvt@C̐ݒێNX
	 */
	public void initialize(UserProfileConfig config) throws Exception {
		this.config = config;
	}

	/**
	 * ftHglł̏
	 */
	public void initializeDefault(Object userProfile, HttpServletRequest request) {

		MessageResources resource = (MessageResources)request.getAttribute(Globals.MESSAGES_KEY);
		HttpSession session = request.getSession(false);
		Locale locale = null;
		// Only check session if sessions are enabled
		if (session != null) {
			locale = (Locale) session.getAttribute(Globals.LOCALE_KEY);
		}
		if (locale == null) {
			// Returns Locale based on Accept-Language header or the server default
			locale = request.getLocale();
		}
		
		UserProfilePropertyConfig properties[] = config.getProperties();
		for (int i = 0; i < properties.length; ++i) {
			setProperty(userProfile, resource, locale, properties[i]);
		}
		try {
			BeanUtils.setProperty(userProfile, PROFILEKEY_AUTHENTICATED, "false");
		} catch (Exception e) {
			String msg = "Cannot set default value to profile." +
			" [columnName:authenticated, type:String, value:false]";
			log.fatal(msg, e);
			return;
		}
	}

	protected void setProperty(
		Object userProfile,
		MessageResources resource,
		Locale locale,
		UserProfilePropertyConfig config){

		String valueString = null;
		String key = config.getDefaultFromResource();
		if (key != null) {
			if (resource == null) {
				String msg = "Failed to get MessageResource to initialize UserProfile.";
				log.fatal(msg);
			} else {
				valueString = resource.getMessage(locale, key);
			}
		} else {
			valueString = config.getDefault();
		}

		Object value = null;
		try {
			value = config.convertInitialValue(valueString);
		} catch (ClassNotFoundException e) {
			String msg = "Cannot convert default value to profile columns's type." +
				" [columnName:" + config.getName() +
				", type:" + config.getType() + 
				", value:" + valueString + "]";
			log.fatal(msg, e);
			return;
		}
					
		try {
			BeanUtils.setProperty(userProfile, config.getName(), value);
		} catch (Exception e) {
			String msg = "Cannot set default value to profile." +
			" [columnName:" + config.getName() +
			", type:" + config.getType() + 
			", value:" + valueString + "]";
			log.fatal(msg, e);
			return;
		}
	}

	/**
	 *	F؏ɂ鏉(ÃNXł̓ftHglŏ)
	 */
	public void initializeAuthorized(Object userProfile, Principal principal, HttpServletRequest request) {
		initializeDefault(userProfile, request);
	}

	//========== protected/private methods ==============================
	
	protected UserProfileConfig getConfig() {
		return config;
	}
}
