/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.cache;

import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameRef;

/**
 * ActionCachẽftHgMBeanC^[tF[X
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public interface DefaultActionCacheServiceMBean {
	
	public void setDefaultCacheServiceName(ServiceName name);

	public ServiceName getDefaultCacheServiceName();

	/**
	 * LbVt@NgT[rX̐ݒ
	 * @param serviceName T[rX
	 */
	public void setCacheFactoryServiceName(ServiceName serviceName);

	/**
	 * LbVt@NgT[rX̎擾
	 * @return T[rX
	 */
	public ServiceName getCacheFactoryServiceName();

	/**
	 * ActionURIɑ΂č\ς݃LbVT[rX֘At邽߂
	 * ServiceNameRefݒ
	 * @param refs
	 */
	public void setCacheServiceNameReferences(ServiceNameRef[] refs);
	
	/**
	 * ActionURIɑ΂č\ς݃LbVT[rX֘At邽߂
	 * ServiceNameRef擾
	 * @return
	 */
	public ServiceNameRef[] getCacheServiceNameReferences();

	/**
	 * LbVꂽRec擾B
	 * @param key LbṼL[
	 * @return LbVꂽRec
	 */
	public CacheEntry get(CacheKey key);

	/**
	 * ActionURIw肵ALbVꂽRec폜
	 * @param path
	 */
	public void remove(String path);

	/**
	 * SẴLbVNAB
	 */
	public void removeAll();
}
