/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;

/**
 * select-forwardvpeBpݒNXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class SelectForwardConfig implements Serializable{

	transient protected static final Log log = LogFactory.getLog(SelectForwardConfig.class);
	protected String property = null;
	
	/**
	 * @return
	 */
	public String getProperty() {
		return property;
	}

	/**
	 * @param string
	 */
	public void setProperty(String string) {
		property = string;
	}

	protected HashMap forwardValueConfigs = new HashMap();
	

	public void addForwardValueConfig(ForwardValueConfig config) {
		forwardValueConfigs.put(config.getValue(), config);	
	}

	public ForwardValueConfig findForwardValueConfig(String value) {
		if (value == null) {
			return (new ForwardValueConfig(this.defaultForwardName));
		}
		ForwardValueConfig config = (ForwardValueConfig) forwardValueConfigs.get(value);
		
		if(config != null) {
			return config;
		}
		
		return (new ForwardValueConfig(this.defaultForwardName));
	}
	
	public ForwardValueConfig findForwardValueConfig(
		String value,
		MessageResources resources,
		Locale locale) {
		if (value == null) {
			return (new ForwardValueConfig(this.defaultForwardName));
		}
		ForwardValueConfig config = (ForwardValueConfig) forwardValueConfigs.get(value);
		
		if(config != null) {
			return config;
		}
		
		// bZ[WvpeB猟
		Set message_keys = forwardValueConfigs.keySet();
		for (Iterator i = message_keys.iterator(); i.hasNext(); ) {
			String message_key = (String) i.next();
			String message_value = resources.getMessage(locale, message_key);
			if (message_value != null && message_value.equals(value)) {
				return (ForwardValueConfig) forwardValueConfigs.get(message_key);				
			}
		}
		
		return null;
	}

	/**
	 * @return
	 */
	public ForwardValueConfig getForwardDefaultConfig() {
		return (new ForwardValueConfig(this.defaultForwardName));
	}

	protected String defaultForwardName = null;

	/**
	 * @return
	 */
	public String getForwardDefault() {
		return defaultForwardName;
	}

	/**
	 * @param string
	 */
	public void setForwardDefault(String name) {
		defaultForwardName = name;
	}

}
