/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.*;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * JSP̃^C\Sێ`
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class TileDefinitionConfig extends TilePutListConfig implements Serializable {
	private String path;
	private String extend;
	
	private String errorControl;

	/** sɏ]PutIuWFNg̃Xg */
	private List putCallList;
	/** ˑς݃tO */
	private boolean isResolved = false;

	private static final Log log = LogFactory.getLog(TileDefinitionConfig.class);

	/**
	 * CAEgpJSPURIݒ
	 * @param string ReLXg[g̃pXB"/"n߂ȂĂ͂ȂȂB
	 */
	public void setPath(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		path = string;
	}

	/* ( Javadoc)
	 * @see jp.ossc.tstruts.config.TilePutConfigBase#freeze()
	 */
	public void freeze() {
		super.freeze();
	}

	/**
	 * ˑ֌W
	 *
	 */
	public void resolveDependence() {
		if (this.isResolved) {
			return;
		}
		// ^CSvf̃Xg쐬
		traverse(null);
		if (log.isDebugEnabled()) {
			log.debug("all " + this.allTileList);
		}
		// ˑXgč\
		remakeDepend();
		
		this.putCallList = new ArrayList();

		// ^CSvfXg̒JԂ
		for (int cnt = 0; cnt < this.allTileList.size(); cnt++) {
			Iterator iter = this.allIterator();
			while (iter.hasNext()) {
				TilePutConfigBase put = (TilePutConfigBase)iter.next();
				// ˑς݂łȂꍇAˑs
				if (!this.putCallList.contains(put)) {
					List dependList = put.getDependsList();
					// ˑ惊XgȂꍇ
					if (dependList == null || dependList.size() == 0) {
						// sXgɒǉ
						putCallList.add(put);
						if (log.isDebugEnabled()) {
							log.debug("[" + cnt + "]set " + put.getName() + ":" + put.getValue());
						}
					}
					else { // ˑ惊Xg݂ꍇ
						if (log.isDebugEnabled()) {
							log.debug("[" + cnt + "]" + put.getName() + " depends " + dependList);
						}
						Iterator iterDepList = dependList.iterator();
						boolean findFlg = true;
						// ˑ悪ׂĈˑςׂ݂
						while (iterDepList.hasNext()) {
							String putName = (String)iterDepList.next();
							TilePutConfigBase putDep = (TilePutConfigBase)this.allTileMap.get(putName);
							if (!putCallList.contains(putDep)) {
								findFlg = false;
								break;
							}
						}
						// ˑ悪ˑς݂̏ꍇAsXgɒǉ
						if (findFlg) {
							putCallList.add(put);
							if (log.isDebugEnabled()) {
								log.debug("[" + cnt + "]set " + put.getName() + ":" + put.getValue());
							}
						}
					}
				}
			}
			// 肷
			if (this.allTileList.size() == putCallList.size()) {
				break;
			}
		}
		// ˑ֌WɎs(struts-config`~Xɂ)
		if (this.allTileList.size() != putCallList.size()) {
			throw new RuntimeException("^C[" + this.getName() +"]̈ˑ֌Wł܂łB");
		}
		isResolved = true;
		if (log.isDebugEnabled()) {
			log.debug("callList " + this.putCallList);
		}
	}

	/**
	 * ˑXgč\ 
	 */
	protected void remakeDepend() {
		for (Iterator iter = this.allIterator(); iter.hasNext();) {
			TilePutConfigBase put = (TilePutConfigBase)iter.next();

			List dependList = put.getDependsList();
			List tmpDependList = new ArrayList();
			if (dependList == null) {
				continue;
			}
			Iterator iterDepList = dependList.iterator();
			while (iterDepList.hasNext()) {
				String putName = (String)iterDepList.next();
				TilePutConfigBase putChild = (TilePutConfigBase)this.allTileMap.get(putName);
				// ˑ於`ĂȂꍇAO𔭐				
				if (putChild == null) {
					throw new RuntimeException("^C[" + this.getName() +"]̈ˑ`[" + putName+ "]͕słB");
				}
				// ˑIuWFNgPutList̏ꍇ
				if (putChild instanceof TilePutListConfig) {
					TilePutListConfig putList = (TilePutListConfig)putChild;
					tmpDependList.addAll(putList.getMap().keySet());
				}
				else {
					tmpDependList.add(putName);
				}
			}
			put.setDependsList(tmpDependList);
		}
	}

	/**
	 * CAEgpJSPURI擾
	 * @return
	 */	
	public String getPath() {
		return path;
	}

	public void setExtend(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}

		this.extend = string;
	}

	public String getExtend() {
		return extend;
	}

	public void setErrorControl(String string) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}

		this.errorControl = string;
	}

	public String getErrorControl() {
		return errorControl;
	}
		
	/**
	 * @param tilesConfig
	 * @param extendStack
	 * @throws UnavailableException
	 */
	public void processTileExtention(TilesDefinitionsConfig tilesConfig, LinkedList extendStack)
	throws UnavailableException {
		if (configured) {
			return;
		}
		if (getExtend() == null) {
			freeze();
			return;
		}
		
		TileDefinitionConfig prototype = tilesConfig.findTileConfig(getExtend());

		extendStack.add(this);

		assertCyclicExtention(extendStack, prototype);
		prototype.processTileExtention(tilesConfig, extendStack);
		
		if (path == null) {
			path = prototype.getPath();
		}
		extend(prototype);		

		extendStack.removeLast();
		freeze();
	}

	/**
	 * @param extendStack
	 * @param prototype
	 * @throws UnavailableException
	 */
	public void assertCyclicExtention(List extendStack, TileDefinitionConfig prototype)
	throws UnavailableException {
		for (Iterator iter = extendStack.iterator(); iter.hasNext();) {
			TileDefinitionConfig item = (TileDefinitionConfig)iter.next();
			if (item == prototype) {
				throw new UnavailableException("Cyclic tile extention has detected!");
			}
		}
	}
	
	/**
	 * s䂵ȂۗLSqIuWFNgmakeResponseĂяo
	 * @param request
	 * @param response
	 */
	public void makeResponse(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException, IOException {
		resolveDependence();
		// sXg擪瑖
		for (Iterator iterator = this.putCallList.iterator(); iterator.hasNext();) {
			TilePutConfigBase tilePutConfig = (TilePutConfigBase)iterator.next();
			// qIuWFNgmakeResponseĂяo
			tilePutConfig.makeResponse(request, response, servletContext);
		}
	}
}
