/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ^CƂHTTPX|X擾邽߂putݒ
 * @author kurosawa
 * @version $Revision: 1.3 $
 */
public class TilePutHttpConfig extends TilePutConfigBase {
	private static final Log log = LogFactory.getLog(TilePutHttpConfig.class);

	/* ( Javadoc)
	 * @see jp.ossc.tstruts.config.TilePutConfigBase#doRequest(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.ServletContext)
	 */
	protected String doRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException, IOException {
		// ^OsAʕԂlƂ
		return createContent(request, response, servletContext);
	}

	/**
	 * createContentǂ݌p
	 * 
	 * @param request
	 * @param response
	 * @param context
	 * @return ^O
	 * @throws ServletException
	 * @throws IOException
	 */	
	protected String createContent(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws HttpException, IOException, ServletException {
		StringBuffer buf = new StringBuffer();

		// XL[̌
		TilePropertyConfig propertyConfig = findPropertyConfig("scheme");
		if (propertyConfig == null) {
			// w肪Ȃ΃ftHg"http"
			buf.append("http");
		} else {
			buf.append(propertyConfig.eval(context, request).toString());
		}
		buf.append("://");

		// zXǧ		
		propertyConfig = findPropertyConfig("host");
		if (propertyConfig != null) {
			buf.append(propertyConfig.eval(context, request).toString());
		}

		// |[gԍ̌
		propertyConfig = findPropertyConfig("port");
		if (propertyConfig != null) {
			buf.append(';');
			buf.append(propertyConfig.eval(context, request).toString());
		}
		
		buf.append('/');

		// pX̌
		propertyConfig = findPropertyConfig("path");
		if (propertyConfig != null) {
			String path = "";
			path = propertyConfig.eval(context, request).toString();
			if (path.indexOf("..") != -1) {
				// pX".."gĂ͂ȂȂ
				log.warn("Cannot use '..'.");
				return "";
			}
			buf.append(path);
		}

		// HTTP\bȟ
		String url = buf.toString();
		propertyConfig = findPropertyConfig("method");
		HttpMethod method = null;
		if (propertyConfig == null) {
			method = new GetMethod(url);
		} else {
			String methodStr = "";
			methodStr = propertyConfig.eval(context, request).toString();
			if ("get".equalsIgnoreCase(methodStr)) {
				method = new GetMethod(url);
			} else if ("post".equalsIgnoreCase(methodStr)) {
				method = new PostMethod(url);
			} else {
				throw new ServletException(methodStr + " is not supported. URL:" + url);
			}
		}

		// HTTPClient̍쐬		
		HttpClient client = new HttpClient();
		
		// ^CAEgԂ̐ݒ
		propertyConfig = findPropertyConfig("timeoutMillis");
		if (propertyConfig != null) {
			String str = "";
			str = propertyConfig.eval(context, request).toString();
			int timeout = Integer.parseInt(str);
			client.setTimeout(timeout);
		}

		// NGXgs		
		int statusCode = client.executeMethod(method);
		if (statusCode == 200) {
			// Xe[^X200ȂRecԂ
			String body = method.getResponseBodyAsString();
			if (body != null) {
				return body;
			}
			log.warn("Content is null. URL:" + url);
		} else {
			log.warn("Failed to get content with status code " + statusCode + ", URL:" + url);
			return "";
		}
		
		return "";
	}
}
