/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

import javax.servlet.UnavailableException;

/**
 * Tiles`ݒNXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class TilesDefinitionsConfig implements Serializable {
	
	private TileDefinitionConfig[] definitions = new TileDefinitionConfig[0];
	private Map defMap = new HashMap();
	private boolean configured = false;

	public void addDefinition(TileDefinitionConfig def) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		TileDefinitionConfig[] newArray = new TileDefinitionConfig[definitions.length + 1];
		System.arraycopy(definitions, 0, newArray, 0, definitions.length);
		newArray[definitions.length] = def;
		definitions = newArray;
		
		defMap.put(def.getName(), def);
	}
	
	public void addAll(TilesDefinitionsConfig another) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		TileDefinitionConfig[] newArray = new TileDefinitionConfig[definitions.length + another.definitions.length];
		System.arraycopy(definitions, 0, newArray, 0, definitions.length);
		System.arraycopy(another.definitions, 0, newArray, definitions.length, another.definitions.length);
		definitions = newArray;
		defMap.putAll(another.defMap);
	}

	public TileDefinitionConfig[] getDefinitions() {
		return definitions;	
	}

	public void freeze() {
		configured = true;
	}

	public void processTilesExtentions() throws UnavailableException {
		for (int i = 0; i < definitions.length; ++i) {
			definitions[i].processTileExtention(this, new LinkedList());
		}
	}

	public TileDefinitionConfig findTileConfig(String name) {
		return (TileDefinitionConfig)defMap.get(name);
	}
}
