/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.lang.reflect.Array;
import java.security.Principal;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.RequestUtils;
import jp.ossc.tstruts.auth.UserProfileInitializer;
import jp.ossc.tstruts.common.DynaUserProfile;
import jp.ossc.tstruts.common.DynaUserProfileClass;


/**
 * UserProfilepݒNXB<p>
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class UserProfileConfig {
	private static final Log log = LogFactory.getLog(UserProfileConfig.class);

	private UserProfilePropertyConfig properties[] = new UserProfilePropertyConfig[0];
	private String className = "jp.ossc.tstruts.common.DynaUserProfile";
	private String factoryClassName = "jp.ossc.tstruts.config.UserProfileFactoryImpl";
	private Class userProfileClass = null;
	private DynaUserProfileClass dynaClass = null;
	private boolean dynamic = true;
	private String initializerClassName = "jp.ossc.tstruts.auth.DefaultJDBCInitializer";
	private JDBCInitializerConfig jdbcInitializerConfig = null;
	private UserProfileInitializer initializer = null;
	private boolean initializerInitialized = false;
	private boolean configured = false;
	
	public UserProfileConfig() {
	}
	
	public UserProfileConfig(String className, String initializerClassName)
	throws InstantiationException, IllegalAccessException, ClassNotFoundException {
		setClassName(className);
		setInitializerClassName(initializerClassName);
	}

	/**
	 * [Uvt@C̍ڐݒǉp\bhBDigesterĂ΂B
	 * @param property
	 */
	public void addProperty(UserProfilePropertyConfig property) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		for (int i = 0; i < properties.length; ++i) {
			if (properties[i].getName().equals(property.getName())) {
				throw new IllegalArgumentException(
				"Property " + property.getName() + "already defined");
			}
		}
		
		UserProfilePropertyConfig newProperties[] =
			new UserProfilePropertyConfig[properties.length + 1];
		System.arraycopy(properties, 0, newProperties, 0, properties.length);
		newProperties[properties.length] = property;
		properties = newProperties;
	}

	/**
	 * [Uvt@C̍ڐݒ擾B
	 * @return	UserProfilePropertyConfig̔z
	 */	
	public UserProfilePropertyConfig[] getProperties() {
		return properties;
	}

	/**
	 * ̍ڐݒ擾B
	 * @param name ږ
	 * @return ڐݒBȂnull
	 */
	public UserProfilePropertyConfig findProperty(String name) {
		for (int i = 0; i < properties.length; ++i) {
			if (properties[i].getName().equals(name)) {
				return properties[i];
			}
		}
		return null;
	}

	/**
	 * [Uvt@C̃NXݒ肷BDigesterĂ΂B
	 * @param string	[Uvt@C̃NX
	 */
	public void setClassName(String className) throws ClassNotFoundException {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		this.className = className;
		userProfileClass = Class.forName(className);
		dynamic = DynaUserProfile.class.isAssignableFrom(userProfileClass);
	}

	/**
	 * [Uvt@C̃NX擾B
	 * @return	[Uvt@C̃NX
	 */
	public String getClassName() {
		return className;
	}

	/**
	 * [Uvt@C𐶐t@NgNX擾B
	 * @return [Uvt@C𐶐t@NgNX
	 */
	public String getFactoryClassName() {
		return factoryClassName;
	}

	/**
	 * [Uvt@C𐶐t@NgNXw肷B
	 * @param string	[Uvt@C𐶐t@NgNXB
	 */
	public void setFactoryClassName(String string) {
		factoryClassName = string;
	}

	/**
	 * [Uvt@CpNX̃NXݒ肷BDigesterĂ΂B
	 * @param string	[Uvt@CNX
	 */
	public void setInitializerClassName(String initializerClassName)
	throws InstantiationException, IllegalAccessException, ClassNotFoundException {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		this.initializerClassName = initializerClassName;
		UserProfileInitializer temp = (UserProfileInitializer)RequestUtils.applicationInstance(getInitializerClassName());
	}

	/**
	 * [Uvt@CpNX̃NX擾B
	 * @return	[Uvt@CNX
	 */
	public String getInitializerClassName() {
		return initializerClassName;
	}

	/**
	 * [Uvt@CpNẌłJDBCInitializerConfigNXݒ肷BDigesterĂ΂B
	 * @param config	JDBCInitializerConfig
	 */
	public void setJDBCInitializerConfig(JDBCInitializerConfig config) {
		if (configured) {
			throw new IllegalStateException("Configuration is frozen");
		}
		jdbcInitializerConfig = config;
	}

	/**
	 * JDBCInitializerConfig擾B
	 * @return
	 */
	public JDBCInitializerConfig getJDBCInitializerConfig() {
		return jdbcInitializerConfig;
	}

	/**
	 * @return	[Uvt@C̃NXDynaBeanC^[tF[XĂꍇtrue
	 */
	public boolean isDynamic() throws ClassNotFoundException {
		if (userProfileClass == null)
			setClassName(className);
		return dynamic;
	}

	/**
	 * ftHglŏꂽ[Uvt@C쐬B
	 * @return łȂƂnullB
	 */
	public Object createDefaultUserProfile(HttpServletRequest request) {
		Object profile;
		profile = createUserProfile();
		if (profile == null)
			return null;
		UserProfileInitializer initializer = getInitializer();
		if (initializer == null)
			return null;
		initializer.initializeDefault(profile, request);
		return profile;
	}
	
	/**
	 * F؏񂩂珉ꂽ[Uvt@C쐬B
	 * @param principal	[UʂPrincipal
	 * @return łȂƂnull
	 */
	public Object createAuthenticatedUserProfile(Principal principal, HttpServletRequest request) {
		Object profile;
		profile = createUserProfile();
		if (profile == null)
			return null;
		UserProfileInitializer initializer = getInitializer();
		if (initializer == null)
			return null;
		initializer.initializeAuthorized(profile, principal, request);
		return profile;
	}

	public UserProfileInitializer getInitializer() {
		
		try {
			if (initializer == null) {
				initializer = (UserProfileInitializer)RequestUtils.applicationInstance(getInitializerClassName());
				initializer.initialize(this);
			}
		} catch (Exception e) {
			String msg = "Failed to initialize UserProfile initializer[" + getInitializerClassName() + "].";
			log.fatal(msg, e);
			return null;
		}

		return initializer;
	}

	/**
	 * RtBONXQ̏BRtBONXQ̎QƊ֌WB
	 * RootModuleConfigImplɂċNB
	 */
	public void initialize() {
		if (jdbcInitializerConfig != null) {
			jdbcInitializerConfig.initialize(this);
		}
	}

	//========== protected/private methods ==============================

	/**
	 * [Uvt@C̃CX^X쐬B
	 * <p>
	 * etB[hϐnullɐݒ肳ĂBv~eBu^̃tB[hnullɂȂĂ邽߁ACX^XƂĂ͕sȏԂłB
	 * @return [Uvt@CCX^XBłȂƂnullB
	 */
	protected Object createUserProfile() {
		try {
			if (isDynamic()) {
				DynaUserProfileClass dynaClass = getDynaClass();
				if (dynaClass == null)
					return null;
				DynaUserProfile instance = (DynaUserProfile) dynaClass.newInstance();
				UserProfilePropertyConfig properties[] = getProperties();
				for (int i = 0; i < properties.length; ++i) {
					if (!properties[i].isIndexed())
						continue;
					Object array = Array.newInstance(properties[i].getIndexedComponentTypeClass(), properties[i].getSize());
					instance.set(properties[i].getName(), array);
				}
				return instance;
			}

//			return RequestUtils.applicationInstance(getClassName());
			UserProfileFactory factory = (UserProfileFactory)
				Class.forName(getFactoryClassName()).newInstance();
			return factory.createUserProfile(getClassName());

		} catch (Exception e) {
			String msg = "Specified UserProfile class is not instantiated.";
			log.fatal(msg, e);
			return null;
		}
	}

	/**
	 * DynaUserProfile\DynaClass쐬E擾B
	 * @return ڂ̃f[^^[hłȂƂnullB
	 */
	protected DynaUserProfileClass getDynaClass() {
		if (dynaClass != null)
			return dynaClass;
		try {
			dynaClass = new DynaUserProfileClass(this);
		} catch (ClassNotFoundException e) {
			String msg = "Failed to load UserProfile's property class.";
			log.fatal(msg, e);
			return null;
		}
		return dynaClass;
	}
	
	public void freeze() {
		configured = true;
		if (jdbcInitializerConfig != null)
			jdbcInitializerConfig.freeze();
		for (int i = 0; i < properties.length; ++i)
			properties[i].freeze();
	}

}
