/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.taglib.env;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.apache.struts.util.ResponseUtils;

import jp.ossc.nimbus.service.context.Context;
import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.config.SystemConfig;
import jp.ossc.tstruts.util.MyServiceUtil;

/**
 * ˑ萔ێT[rXAw肳ꂽO̒l擾^OB
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class EnvTag extends BodyTagSupport {

	/**
	 * ˑ萔ێT[rX擾ϐ
	 */
	private String property = null;
	
	/**
	 * ˑ萔ێT[rXւ̎Q
	 */
	private Context contextService = null; 

	/**
	 * @return ˑ萔ێT[rX擾ϐ
	 */
	public String getProperty() {
		return property;
	}

	/**
	 * @param string ˑ萔ێT[rX擾ϐ
	 */
	public void setProperty(String string) {
		property = string;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#doEndTag()
	 */
	public int doEndTag() throws JspException {
		if (bodyContent != null) {
			String body = bodyContent.getString();
			if (body != null) {
				body = body.trim();
				if (body.length() != 0)
					property = body;
			}
		}
		
		if (property == null)
			throw new JspException(
				"<env> tag must be specified 'property' attribute.");
		property = property.trim();
		if (property.length() == 0)
			throw new JspException(
				"<env> tag must be specified 'property' attribute.");
		Context context = getContextService();
		Object value = context.get(property.trim());
		if (value == null)
			return EVAL_PAGE;
		
		ResponseUtils.write(pageContext, value.toString());
		
		return EVAL_PAGE;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#release()
	 */
	public void release() {
		property = null;
		super.release();
	}

	/**
	 * SystemConfigvOCˑ萔ێT[rX̃T[rX擾A
	 * T[rX擾ĕԂB
	 * @return
	 * @throws JspException
	 */
	protected Context getContextService() throws JspException {
		if (contextService != null)
			return contextService;
		SystemConfig config = SystemConfig.getConfig();
		if (config == null)
			throw new JspException(
				"SystemConfig instance is not set to thread local.");
		contextService = (Context)MyServiceUtil.getServiceObjectBySystemConfigProperty(MyGlobals.ENVIRONMENT_VARIABLE_HOLDER_PROPERTY);
		if (contextService == null)
			throw new JspException(
				"Specified EnvironmentVariableHolder service is not found.");
		return contextService;
	}
}
