/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.taglib.tiles;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ResponseUtils;

import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.config.TilePutConfigBase;
import jp.ossc.tstruts.config.TilePutListConfig;

/**
 * ^C̖ߍ݃^OB
 * ̃^O̎srequestIuWFNgɃZbgĂTilePutConfigɂāA
 * <ul>
 *   <li>nameݒ肳ĂƂTilePutConfigTilePutListConfigłƂ݂ȂA
 *     ̃Xgow肳ꂽname^C`sčށB</li>
 *   <li>nameݒ肳ĂȂƂ́ATilePutConfig݉\(XgłȂ)`łƂ݂ȂAsčށB</li>
 * </ul>
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class InsertTag extends BodyTagSupport {

	/**
	 * Xg<put>vfޏꍇɎw肷閼O
	 */
	private String name;
	
	/**
	 * Xg<put>vfޏꍇɎw肷閼Osetter
	 * @param name ^C
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Xg<put>vfޏꍇɎw肷閼Ogetter
	 * @return
	 */	
	public String getName() {
		return name;
	}

	/**
	 * ^OInhB
	 * name邢̓{fBReg݂ꍇ́A
	 * requestIuWFNgɐݒ肳ꂽ^C`TilePutListConfigłƂ݂ȂA
	 * Xgo̒w肳ꂽÕ^C`oĎsAށB
	 * nameA{fBReĝǂw肳ĂȂꍇ́A
	 * requestIuWFNgɐݒ肳ꂽ^C`݉\ȃ^C`ł
	 * (XgłȂ)Ƃ݂ȂAsčށB
	 */	
	public int doEndTag() throws JspException {
		// {fBReg̎擾
		if (bodyContent != null) {
			String body = bodyContent.getString();
			if (body != null) {
				body = body.trim();
				if (body.length() != 0)
					name = body;
			}
		}

		// requestIuWFNg^C`擾
		TilePutConfigBase config = (TilePutConfigBase)pageContext.getAttribute(MyGlobals.TILES_CONFIG_KEY, PageContext.REQUEST_SCOPE);
		TilePutConfigBase oldConfig = config;

		// ^C`Ȃꍇ̓G[B
		if (config == null) {
			JspException e = new JspException("Current page is not in tiles context");
			RequestUtils.saveException(pageContext, e);
			throw e;
		}

		// namew肳ĂA邢̓{fBReg݂ꍇ
		if (name != null) {
			if (!(config instanceof TilePutListConfig)) {
				// requestIuWFNg擾^C`TilePutListConfigłȂ΃G[B
				JspException e = new JspException("Current tiles context is not putList. Cannot use name attribute.");
				RequestUtils.saveException(pageContext, e);
				throw e;
			}
			// w肳ꂽÕ^C`擾
			config = ((TilePutListConfig)config).get(name);
			if (config == null) {
				// 擾łȂ΃G[
				JspException e = new JspException("Specified tile def name '" + name + "' is not found.");
				RequestUtils.saveException(pageContext, e);
				throw e;
			}
		}

		try {

			// requestIuWFNgɁAꂩs^C`ZbgB
			// requestIuWFNgێ^C`͏Ɂuݏ̃^C`vłȂ΂ȂȂ߁B
			pageContext.setAttribute(MyGlobals.TILES_CONFIG_KEY, config, PageContext.REQUEST_SCOPE);
			
			// ^C`̎s
			Object content = config.createContent(pageContext);
			
			// sʂ̍
			if (content != null) {
				if (content instanceof String) {
					ResponseUtils.write(pageContext, (String)content);
				} else {
					ResponseUtils.write(pageContext, content.toString());
				}
			}
		} catch (ServletException e) {
			throw new JspException(e);
		} catch (IOException e) {
			throw new JspException(e);
		} finally {
			// requestIuWFNgɌ̃^C`ĐݒB
			// requestIuWFNgێ^C`͏Ɂuݏ̃^C`vłȂ΂ȂȂ߁B
			pageContext.setAttribute(MyGlobals.TILES_CONFIG_KEY, oldConfig, PageContext.REQUEST_SCOPE);
		}
		
		return EVAL_PAGE;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.Tag#release()
	 */
	public void release() {
		name = null;
		super.release();
	}

}
