/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.taglib.tiles;

import java.util.Iterator;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;

import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.config.TilePutConfigBase;
import jp.ossc.tstruts.config.TilePutListConfig;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ResponseUtils;

/**
  * tileListCe[g^OB
  * <p>
  * namew肳ĂꍇArequestIuWFNgɐݒ肳ꂽ^C`TilePutListConfigŁA
  * w肳ꂽOŎo`TilePutListConfigƂ݂ȂăCe[gsB
  * </p>
  * <p>
  * namew肳ĂȂꍇArequestIuWFNgɐݒ肳ꂽ^C`TilePutListConfigłƂ݂ȂA
  * ̃oɂăCe[gsB
  * </p>
  *
  * @version $Revision: 1.3 $
  * @author H.Matsuno
  * @since 1.0
  */
public class IterateTag extends BodyTagSupport {
	protected static final Log log = LogFactory.getLog(IterateTag.class);

	/**
	 * Ce[^
	 */
	protected Iterator iterator = null;
	
	/**
	 * Ce[gõXgindex
	 */
	protected int lengthCount = 0;
	
	/**
	 * Ce[g钷
	 */
	protected int lengthValue = 0;
	
	/**
	 * Ce[gJnʒu
	 */
	protected int offsetValue = 0;

	/**
	 * Ce[goindexlpageContextɐݒ肳Ƃ̖O
	 */
	protected String indexId = null;

	/**
	 * Ce[g̃Xg̒w肷鑮l
	 */
	protected String length = null;

	/**
	 * ^C`̃Xg
	 */
	protected String name = null;
	
	/**
	 * Ce[gJnʒuw肷鑮l
	 */
	protected String offset = null;

	/**
	 * Ce[gJnOrequestIuWFNgɐݒ肳Ă^C`ێ郁o
	 */
	protected TilePutConfigBase oldConfig = null;

	/**
	 * ϐ̏
	 */
	public void release() {

		super.release();

		iterator = null;
		lengthCount = 0;
		lengthValue = 0;
		offsetValue = 0;

		indexId = null;
		length = null;
		name = null;
		offset = null;
		oldConfig = null;

	}

	public String getIndexId() {
		return (this.indexId);
	}

	public void setIndexId(String indexId) {
		this.indexId = indexId;
	}

	public String getLength() {
		return (this.length);
	}

	public void setLength(String length) {
		this.length = length;
	}

	public String getName() {
		return (this.name);
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOffset() {
		return (this.offset);
	}

	public void setOffset(String offset) {
		this.offset = offset;
	}

	protected int getIndex() {
		return (offsetValue + lengthCount - 1);
	}

	/**
	 * ^O̊JnnhB
	 * ^CXg擾ACe[^B
	 */
	public int doStartTag() throws JspException {

		// ^C`̎擾
		Object collection =
			pageContext.getAttribute(
				MyGlobals.TILES_CONFIG_KEY,
				PageContext.REQUEST_SCOPE);
		if (collection == null) {
			JspException e =
				new JspException("Current page is not in tiles context.");
			RequestUtils.saveException(pageContext, e);
			throw e;
		}

		// 擾ꂽ^C`XgłȂꍇ̓G[B
		if (!(collection instanceof TilePutListConfig)) {
			JspException e =
				new JspException("Current tiles context is not putList.");
			RequestUtils.saveException(pageContext, e);
			throw e;
		}

		// ݂̃^C`ۑ(requestIuWFNgɖ߂)B
		oldConfig = (TilePutConfigBase) collection;

		TilePutListConfig listConfig = (TilePutListConfig) collection;
		// namew肳ĂƂ́Aw肳ꂽÕ^C`XgoB
		if (name != null) {
			collection = listConfig.get(name);
			if (collection == null) {
				// 擾łȂƂ̓G[B
				JspException e =
					new JspException("Specified tile def name '" + name + "' is not found.");
				RequestUtils.saveException(pageContext, e);
				throw e;
			}

			// o^C`XgłȂ΃G[
			if (!(collection instanceof TilePutListConfig)) {
				JspException e =
					new JspException("Specified tile def name '" + name + "' is not putList.");
				RequestUtils.saveException(pageContext, e);
				throw e;
			}
			listConfig = (TilePutListConfig) collection;
		}

		// Ce[^擾B
		iterator = listConfig.iterator();

		// Ce[gJnʒǔ
		if (offset == null) {
			offsetValue = 0;
		} else {
			try {
				offsetValue = Integer.parseInt(offset);
			} catch (NumberFormatException e) {
				Integer offsetObject =
					(Integer) RequestUtils.lookup(pageContext, offset, null);
				if (offsetObject == null) {
					offsetValue = 0;
				} else {
					offsetValue = offsetObject.intValue();
				}
			}
		}
		if (offsetValue < 0) {
			offsetValue = 0;
		}

		// Ce[g钷̌
		if (length == null) {
			lengthValue = 0;
		} else {
			try {
				lengthValue = Integer.parseInt(length);
			} catch (NumberFormatException e) {
				Integer lengthObject =
					(Integer) RequestUtils.lookup(pageContext, length, null);
				if (lengthObject == null) {
					lengthValue = 0;
				} else {
					lengthValue = lengthObject.intValue();
				}
			}
		}
		if (lengthValue < 0) {
			lengthValue = 0;
		}
		lengthCount = 0;

		// Ce[gJnʒu܂ŃXLbv
		for (int i = 0; i < offsetValue; i++) {
			if (iterator.hasNext()) {
				iterator.next();
			}
		}

		// Ce[^̐擪GgrequestIuWFNgɐݒB
		if (iterator.hasNext()) {
			Object element = iterator.next();

			pageContext.setAttribute(
				MyGlobals.TILES_CONFIG_KEY,
				element,
				PageContext.REQUEST_SCOPE);
			lengthCount++;
			if (indexId != null) {
				pageContext.setAttribute(indexId, new Integer(getIndex()));
			}
			return (EVAL_BODY_BUFFERED);
		} else {
			return (SKIP_BODY);
		}

	}

	/**
	 * {fBInhB
	 * Ce[^i߂B
	 *
	 * @exception JspException if a JSP exception has occurred
	 */
	public int doAfterBody() throws JspException {

		// Render the output from this iteration to the output stream
		if (bodyContent != null) {
			ResponseUtils.writePrevious(pageContext, bodyContent.getString());
			bodyContent.clearBody();
		}

		// Decide whether to iterate or quit
		if ((lengthValue > 0) && (lengthCount >= lengthValue)) {
			return (SKIP_BODY);
		}

		if (iterator.hasNext()) {
			Object element = iterator.next();
			pageContext.setAttribute(
				MyGlobals.TILES_CONFIG_KEY,
				element,
				PageContext.REQUEST_SCOPE);
			lengthCount++;
			if (indexId != null) {
				pageContext.setAttribute(indexId, new Integer(getIndex()));
			}
			return (EVAL_BODY_AGAIN);
		} else {
			return (SKIP_BODY);
		}

	}

	/**
	 * Clean up after processing this enumeration.
	 *
	 * @exception JspException if a JSP exception has occurred
	 */
	public int doEndTag() throws JspException {

		// Clean up our started state
		iterator = null;
		pageContext.setAttribute(
			MyGlobals.TILES_CONFIG_KEY,
			oldConfig,
			PageContext.REQUEST_SCOPE);

		// Continue processing this page
		return (EVAL_PAGE);

	}

}
