/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.util;

import java.io.IOException;
import javax.servlet.*;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.*;

import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editor.JournalServletResponseWrapper;

import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.config.SystemConfig;
import jp.ossc.tstruts.common.InvocationContext;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class AccessJournalFilter implements Filter{
    
    /**
     * OóB<p>
     */
    protected static final Log log
         = LogFactory.getLog(AccessJournalFilter.class);
    
    /**
     * Journal̃T[rXB<p>
     */
    protected static final String JOURNAL_NAME = "AccessJournal";
    
    /**
     * ServletResponsebv邩ǂtÕtB^p[^B<p>
     */
    protected static final String PARAM_NAME_WRAPPED_RESPONSE
         = "wrappedResponse";
    
    /**
     * bvServletResponseւ̏o͂obt@O邩tÕtB^p[^B<p>
     */
    protected static final String PARAM_NAME_BUFFERED_OUTPUT
         = "bufferedOutput";
    
    protected static final String ACCESS_JOURNAL_KEY = "Access";
    protected static final String REQUEST_JOURNAL_KEY = "Request";
    protected static final String RESPONSE_JOURNAL_KEY = "Response";
    protected static final String SERVLET_REQUEST_JOURNAL_KEY
         = "ServletRequest";
    protected static final String SERVLET_RESPONSE_JOURNAL_KEY
         = "ServletResponse";
    
    protected ServletContext context;
    
    protected boolean isResponseWrapped;
    protected boolean isBufferedOutput;
    
    public static final String ACCESS_JOURNAL_RECORDED = "jp.ossc.tstruts.util.AccessJournal.Recorded";

    public void init(FilterConfig filterConfig)throws ServletException{
        context = filterConfig.getServletContext();
        final String isResponseWrappedStr = filterConfig.getInitParameter(
            PARAM_NAME_WRAPPED_RESPONSE
        );
        isResponseWrapped = Boolean.valueOf(isResponseWrappedStr)
            .booleanValue();
        final String isBufferedOutputStr = filterConfig.getInitParameter(
            PARAM_NAME_BUFFERED_OUTPUT
        );
        isBufferedOutput = Boolean.valueOf(isBufferedOutputStr)
            .booleanValue();
    }
    
    public void doFilter(
        ServletRequest request,
        ServletResponse response,
        FilterChain chain
    ) throws IOException, ServletException{
        final SystemConfig config = (SystemConfig)context
            .getAttribute(MyGlobals.SYSTEM_CONFIG_KEY);
        config.setLocal();
        
        InvocationContext invokeContext = (InvocationContext)request
            .getAttribute(MyGlobals.INVOCATION_CONTEXT_KEY);
        if(invokeContext == null){
            try{
                invokeContext = config.createInvocationContext();
                request.setAttribute(
                    MyGlobals.INVOCATION_CONTEXT_KEY,
                    invokeContext
                );
            }catch(Exception e){
                log.fatal("Failed to create InvocationContext", e);
            }
        }
        
        String recorded = (String)request.getAttribute(ACCESS_JOURNAL_RECORDED);
        if (recorded != null) {
        	// W[iL^ς݂Ȃ̂ł̂܂܌㑱s
        	chain.doFilter(request, response);
        	return;
        }
        
        request.setAttribute(ACCESS_JOURNAL_RECORDED, "recorded");
        
        final Journal journal
             = (Journal)MyServiceUtil.getServiceObjectBySystemConfigProperty(JOURNAL_NAME);
		String requestId = "none";
        if(journal != null){
            journal.startJournal(ACCESS_JOURNAL_KEY);
            if(invokeContext != null){
            	requestId = invokeContext.getRequestID();
                journal.setRequestId(requestId);
            }
            if (log.isDebugEnabled()) {
	            log.debug("StartJournal. RequestId:" + requestId);
            }
            journal.addStartStep(REQUEST_JOURNAL_KEY);
            journal.addInfo(SERVLET_REQUEST_JOURNAL_KEY, request);
        }
        
        ServletResponse res = null;
        if(isResponseWrapped){
            if(response instanceof HttpServletResponse){
                final HttpServletResponse httpResponse
                     = (HttpServletResponse)response;
                final JournalHttpServletResponseWrapper responsew
                     = new JournalHttpServletResponseWrapper(httpResponse);
                responsew.setBufferedOutput(isBufferedOutput);
                res = responsew;
            }else{
                final JournalServletResponseWrapper responsew
                     = new JournalServletResponseWrapper(response);
                responsew.setBufferedOutput(isBufferedOutput);
                res = responsew;
            }
        }else{
            res = response;
        }
        try{
            chain.doFilter(request, res);
        }finally{
            if(journal != null){
                journal.addEndStep();
                
                journal.addStartStep(RESPONSE_JOURNAL_KEY);
                journal.addInfo(SERVLET_RESPONSE_JOURNAL_KEY, res);
            }
            try {
				if(isResponseWrapped && isBufferedOutput){
					if(res instanceof JournalHttpServletResponseWrapper){
						final JournalHttpServletResponseWrapper responsew
							 = (JournalHttpServletResponseWrapper)res;
						responsew.flush();
					}else{
						final JournalServletResponseWrapper responsew
							 = (JournalServletResponseWrapper)res;
						responsew.flush();
					}
				}
            } finally {
				if(journal != null){
					journal.addEndStep();
					journal.endJournal();
					if (log.isDebugEnabled()) {
						log.debug("EndJournal RequestId:" + requestId);
					}
				}
            }
        }
    }
    
    public void destroy(){
        context = null;
    }
}