/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.util;

import java.util.Locale;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.struts.Globals;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;

import jp.ossc.tstruts.config.RootModuleConfigImpl;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class MyRequestUtil {
	private static MessageResources messages =
					MessageResources.getMessageResources("org.apache.struts.util.LocalStrings");

	/**
	 * NGXg̃pXɑΉModuleConfigԂB
	 * <p>
	 * NGXg̃pXɑΉModuleConfig肳̂ActionServletprocess\bh̐擪(NGXg̈ԍŏ)ŁA
	 * RequestUtils.selectModule\bhĂ΂ꂽƂBselectModule\bhĂ΂ꂽȂ΁A{\bh͐ModuleConfigԂB
	 * selectModule\bhĂ΂O(FilterȂ)̓ftHgModuleConfigɕԂĂ܂̂ŁA
	 * {\bhĂԑORequestUtils.selectModule\bhĂłƁB
	 * 
	 * @param request	HttpServletRequestIuWFNg
	 * @param context	ServletContextIuWFNg
	 * @return		NGXg̃pXɑΉModuleConfigIuWFNg
	 */
	public static ModuleConfig getModuleConfig(HttpServletRequest request, ServletContext context) {
		ModuleConfig config = (ModuleConfig)request.getAttribute(Globals.MODULE_KEY);
		if (config == null) {
			config = (ModuleConfig)context.getAttribute(Globals.MODULE_KEY);
		}
		return (config);
	}
	
	public static RootModuleConfigImpl getRootModuleConfig(ServletContext context) {
		RootModuleConfigImpl config = (RootModuleConfigImpl)context.getAttribute(Globals.MODULE_KEY);
		return config;
	}

	/**
	 * Look up and return current user locale, based on the specified parameters.
	 * 
	 * @param pageContext The PageContext associated with this request
	 * @param locale Name of the session attribute for our user's Locale.  If this is 
	 * <code>null</code>, the default locale key is used for the lookup.
	 * @return current user locale
	 */
	public static Locale retrieveUserLocale(HttpServletRequest request, String locale) {
		Locale userLocale = null;
		HttpSession session = request.getSession(false);

		if (locale == null) {
			locale = Globals.LOCALE_KEY;
		}

		// Only check session if sessions are enabled
		if (session != null) {
			userLocale = (Locale)session.getAttribute(locale);
		}

		if (userLocale == null) {
			// Returns Locale based on Accept-Language header or the server default
			userLocale = request.getLocale();
		}

		return userLocale;
	}

	/**
	 * Look up and return a message string, based on the specified parameters.
	 *
	 * @param pageContext The PageContext associated with this request
	 * @param bundle Name of the servlet context attribute for our
	 *  message resources bundle
	 * @param locale Name of the session attribute for our user's Locale
	 * @param key Message key to be looked up and returned
	 * @return message string
	 *
	 * @exception ServletException if a lookup error occurs (will have been
	 *  saved in the request already)
	 */
	public static String message(ServletContext servletContext, HttpServletRequest request, String bundle, String locale, String key) throws ServletException {
		return (message(servletContext, request, bundle, locale, key, null));		
	}

	/**
	 * Look up and return a message string, based on the specified parameters.
	 *
	 * @param servletContext The ServletContext associated with this request
	 * @param request
	 * @param bundle Name of the servlet context attribute for our
	 *  message resources bundle
	 * @param locale Name of the session attribute for our user's Locale
	 * @param key Message key to be looked up and returned
	 * @param args Replacement parameters for this message
	 * @return message string
	 * @exception ServletException if a lookup error occurs (will have been
	 *  saved in the request already)
	 */
	public static String message(ServletContext servletContext, HttpServletRequest request, String bundle, String locale, String key, Object args[]) throws ServletException {
		MessageResources resources = retrieveMessageResources(servletContext, request, bundle, false);

		Locale userLocale = retrieveUserLocale(request, locale);

		if (args == null) {
				return (resources.getMessage(userLocale, key));
		} else {
				return (resources.getMessage(userLocale, key, args));
		}
	}

	/**
	 * Returns the appropriate MessageResources object for the current module and 
	 * the given bundle.
	 * 
	 * @param pageContext Search the context's scopes for the resources.
	 * @param bundle The bundle name to look for.  If this is <code>null</code>, the 
	 * default bundle name is used.
	 * @return MessageResources The bundle's resources stored in some scope. 
	 * @throws ServletException if the MessageResources object could not be found.
	 * 
	 */
	private static MessageResources retrieveMessageResources(
		ServletContext servletContext, HttpServletRequest request, 
		String bundle,
		boolean checkPageScope) throws ServletException {
		MessageResources resources = null;

		if (bundle == null) {
			bundle = Globals.MESSAGES_KEY;
		}
		
		resources = (MessageResources)request.getAttribute(bundle);
			
		if (resources == null) {
			HttpSession session = request.getSession(false);
			resources = (MessageResources)session.getAttribute(bundle);
		}
			
		if (resources == null) {
			resources = (MessageResources)servletContext.getAttribute(bundle);
		}

		if (resources == null) {
			ServletException ex = new ServletException(messages.getMessage("message.bundle", bundle));
			servletContext.setAttribute(Globals.EXCEPTION_KEY, ex);
			throw ex;
		}

		return resources;
	}
}
