/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.util;

import java.io.IOException;
import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.commons.logging.*;

import jp.ossc.nimbus.service.context.Context;

import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.config.SystemConfig;
import jp.ossc.tstruts.common.InvocationContext;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author M.Takata
 * @since 1.0
 */
public class ThreadContextInitializeFilter implements Filter{
    
    /**
     * OóB<p>
     */
    protected static final Log log
         = LogFactory.getLog(ThreadContextInitializeFilter.class);
    
    /**
     * ThreadContextT[rXSystemConfig̑B<p>
     */
    protected static final String CONTEXT_NAME = "ThreadContext";
    
    /**
     * ThreadContextT[rXɐݒ肷ReLXg̃L[B<p>
     */
    protected static final String CONTEXT_NAME_KEY = "CONTEXT_NAME";
    
    /**
     * ThreadContextT[rXɐݒ肷ZbVID̃L[B<p>
     */
    protected static final String SESSION_ID_KEY = "SESSION_ID";
    
    /**
     * ThreadContextT[rXɐݒ肷郊NGXgID̃L[B<p>
     */
    protected static final String REQUEST_ID_KEY = "REQUEST_ID";
    
    protected ServletContext context;
    
    public void init(FilterConfig filterConfig)throws ServletException{
        context = filterConfig.getServletContext();
    }
    
    public void doFilter(
        ServletRequest request,
        ServletResponse response,
        FilterChain chain
    ) throws IOException, ServletException{
        final SystemConfig config = (SystemConfig)context
            .getAttribute(MyGlobals.SYSTEM_CONFIG_KEY);
        config.setLocal();
        
        InvocationContext invokeContext = null;
        if(request.getAttribute(MyGlobals.INVOCATION_CONTEXT_KEY) == null){
            try{
                invokeContext = config.createInvocationContext();
                request.setAttribute(
                    MyGlobals.INVOCATION_CONTEXT_KEY,
                    invokeContext
                );
            }catch(Exception e){
                log.fatal("Failed to create InvocationContext", e);
            }
        }
        
        final Context context = (Context)MyServiceUtil
            .getServiceObjectBySystemConfigProperty(CONTEXT_NAME);
        if(context != null){
            if(invokeContext != null){
                context.put(REQUEST_ID_KEY, invokeContext.getRequestID());
            }
            if(request instanceof HttpServletRequest){
                final HttpServletRequest httpReq = (HttpServletRequest)request;
                String contextPath = httpReq.getContextPath();
                if(contextPath != null && contextPath.length() != 0){
                    contextPath = contextPath.substring(1);
                }
                context.put(CONTEXT_NAME_KEY, contextPath);
                final HttpSession session
                     = httpReq.getSession(false);
                if(session != null){
                    context.put(SESSION_ID_KEY, session.getId());
                }
            }
        }
        
        chain.doFilter(request, response);
    }
    
    public void destroy(){
        context = null;
    }
}