/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.transaction;

import junit.framework.*;
import com.meterware.httpunit.*;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class TestTransactionUsingHttpUnit extends TestCase {

	//	protected Log log = LogFactory.getLog((this.getClass()).getName());

	//RXgN^

	public String hiddenTransactionId = null;
	com.meterware.httpunit.WebConversation webConversation =
		new com.meterware.httpunit.WebConversation();

	public TestTransactionUsingHttpUnit(String name) {
		super(name);
		System.out.println("name = " + name);
		System.out.println("test:start ");
		System.out.println("test:start testInput");
		//			log.fatal("test");
	}

	public static Test suite() {
		TestSuite TestList = new TestSuite();
		TestList.addTestSuite(TestTransactionUsingHttpUnit.class);
		return TestList;
	}
   
	protected void setUp() throws Exception {
	}

	/**
	 * dMh~eXgB<p>
	 * 1ڃNGXg͐JځB2ڃNGXg͐JځB
	 * 3ڃNGXg2ڃNGXgグ邽ߓdMh~ʂ֑JځB<br>
	 *
	 */

	public void testTransaction() {
		try {
			System.out.println("test:start");
			//HttpUnit
			System.out.println("Request1:start");
			com.meterware.httpunit.WebConversation webConversation;
			com.meterware.httpunit.WebResponse webResponse;
			webConversation = new com.meterware.httpunit.WebConversation();
			webResponse =
				webConversation.getResponse(
					"http://localhost:8080/tstruts-cactus/test/testMenu.do");
			//Htmlo͓e擾
			String title = webResponse.getTitle();
			System.out.println("/testMenu.do Title " + title);

			System.out.println("WebForm[] getForms() ");

			WebForm[] forms = webResponse.getForms();
			for (int i = 0; i < forms.length; i++) {
				System.out.println(forms[i]);
				System.out.println("ID = " + forms[i].getID());
			}

			WebForm form = webResponse.getFormWithID("form1");
			hiddenTransactionId = form.getParameterValue("TransactionToken");
			System.out.println("TransactionToken擾" + hiddenTransactionId);

			//Hiddenڂߍ܂Ă邩̔菈
			if (hiddenTransactionId != null) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request2:start");
			webConversation = new com.meterware.httpunit.WebConversation();

			com.meterware.httpunit.WebRequest webRequest = form.getRequest();

			com.meterware.httpunit.WebResponse webResponse2 =
				webConversation.getResponse(webRequest);
			WebForm form2 = webResponse2.getFormWithID("form2");
			hiddenTransactionId = form2.getParameterValue("TransactionToken");
			System.out.println("TransactionToken擾" + hiddenTransactionId);

			String title2 = webResponse2.getTitle();
			System.out.println("/testMenu2.do Title " + title2);

			System.out.println("Request2:end");

			//Jڂ̔菈
			if (title2.equals("OK")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request3:start");
			webResponse = webConversation.getResponse(webRequest);
			String title3 = webResponse.getTitle();
			System.out.println("/testMenu2.do Title " + title3);

			//dMh~ʂ֑Jڂ̔菈
			if (title3.equals("NG")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request3:end");

			System.out.println("test:end");

		} catch (Exception e) {
			System.out.println("catchException: " + e);
			e.printStackTrace();
			System.out.println("testTransaction1: failure");
			fail();
		}
	}

	/**
	 * dMh~eXgB<p>
	 * TransactedMaxlȏ̃NGXg𓊂ɍŏɓNGXg𓊂eXg.
	 * TransactedMaxu3vƐݒ肵ꍇ̃eXgB
	 * 
	 */

	public void testTransaction2() {
		try {
			System.out.println("test:start");
			//HttpUnit
			System.out.println("Request1:start");
			com.meterware.httpunit.WebConversation webConversation;
			com.meterware.httpunit.WebResponse webResponse;
			webConversation = new com.meterware.httpunit.WebConversation();
			webResponse =
				webConversation.getResponse(
					"http://localhost:8080/tstruts-cactus/test/testMenu.do");
			//Htmlo͓e擾
			String title = webResponse.getTitle();
			System.out.println("Title " + title);

			System.out.println("WebForm[] getForms() ");

			WebForm form = webResponse.getFormWithID("form1");
			hiddenTransactionId = form.getParameterValue("TransactionToken");
			System.out.println("TransactionToken擾" + hiddenTransactionId);

			//Hiddenڂߍ܂Ă邩̔菈
			if (hiddenTransactionId != null) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request2:start");
			webConversation = new com.meterware.httpunit.WebConversation();

			com.meterware.httpunit.WebRequest webRequest1 = form.getRequest();

			com.meterware.httpunit.WebResponse webResponse2 =
				webConversation.getResponse(webRequest1);
			WebForm form2 = webResponse2.getFormWithID("form2");
			hiddenTransactionId = form2.getParameterValue("TransactionToken");
			System.out.println("TransactionToken擾" + hiddenTransactionId);

			String title2 = webResponse2.getTitle();
			System.out.println("Title " + title2);

			System.out.println("Request2:end");

			//Jڂ̔菈
			if (title2.equals("OK")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request3:start");
			com.meterware.httpunit.WebRequest webRequest2 = form2.getRequest();
			com.meterware.httpunit.WebResponse webResponse3 =
				webConversation.getResponse(webRequest2);
			WebForm form3 = webResponse3.getFormWithID("form3");
			String title3 = webResponse3.getTitle();
			System.out.println("Title " + title3);

			//Jڂ̔菈
			if (title3.equals("OK")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request3:end");

			System.out.println("Request4:start");
			com.meterware.httpunit.WebRequest webRequest3 = form3.getRequest();
			com.meterware.httpunit.WebResponse webResponse4 =
				webConversation.getResponse(webRequest3);
			WebForm form4 = webResponse4.getFormWithID("form4");
			String title4 = webResponse4.getTitle();
			System.out.println("Title " + title4);

			//Jڂ̔菈
			if (title4.equals("OK")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request4:end");

			System.out.println("Request5:start");
			com.meterware.httpunit.WebResponse webResponse5 =
				webConversation.getResponse(
					"http://localhost:8080/tstruts-cactus/test/testMenu.do");
			WebForm form5 = webResponse5.getFormWithID("form1");
			String title5 = webResponse5.getTitle();
			System.out.println("Title " + title5);

			//Jڂ̔菈
			if (title5.equals("OK")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request5:end");

			System.out.println("Request6:start");
			com.meterware.httpunit.WebRequest webRequest5 = form5.getRequest();
			com.meterware.httpunit.WebResponse webResponse6 =
				webConversation.getResponse(webRequest5);
			WebForm form6 = webResponse6.getFormWithID("form2");
			String title6 = webResponse6.getTitle();
			System.out.println("Title " + title6);

			//Jڂ̔菈
			if (title6.equals("OK")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request6:end");

			System.out.println("Request7:start");
			com.meterware.httpunit.WebRequest webRequest6 = form6.getRequest();
			com.meterware.httpunit.WebResponse webResponse7 =
				webConversation.getResponse(webRequest6);
			WebForm form7 = webResponse7.getFormWithID("form3");
			String title7 = webResponse7.getTitle();
			System.out.println("Title " + title7);

			//Jڂ̔菈
			if (title7.equals("OK")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request7:end");

			System.out.println("Request8:start");
			com.meterware.httpunit.WebResponse webResponse8 =
				webConversation.getResponse(webRequest1);
			WebForm form8 = webResponse8.getFormWithID("form2");
			String title8 = webResponse8.getTitle();
			System.out.println("Title " + title8);

			//Jڂ̔菈
			if (title8.equals("OK")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

			System.out.println("Request8:end");

			System.out.println("test:end");

		} catch (Exception e) {
			System.out.println("catchException: " + e);
			System.out.println("testTransaction2: failure");
			fail();
		}
	}

	/**
	 * dMh~eXgB<p>
	 * Transactedݒʂ֑JڂƂAdMh~ʂ֑Jڂ邩B
	 * 
	 */
	public void testTransaction3() {
		try {
			System.out.println("test:start");
			//HttpUnit
			System.out.println("Request1:start");
			com.meterware.httpunit.WebConversation webConversation;
			com.meterware.httpunit.WebResponse webResponse;
			webConversation = new com.meterware.httpunit.WebConversation();
			webResponse =
				webConversation.getResponse(
					"http://localhost:8080/tstruts-cactus/test/testMenu2.do");
			//Htmlo͓e擾
			String title = webResponse.getTitle();
			System.out.println("Title " + title);

			//dMh~ʂ֑Jڂ̔菈
			if (title.equals("NG")) {
				assertTrue(true);
			} else {
				assertTrue(false);
			}

		} catch (Exception e) {
			System.out.println("catchException: " + e);
			System.out.println("testTransaction3: failure");
			fail();
		}
	}

}
