/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.action.web;

import org.apache.struts.action.DynaActionForm;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.common.InvocationContext;
import junit.framework.TestCase;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class FakeEJBActionInterceptorTest extends TestCase {

	/**
	 * Constructor for FakeEJBActionInterceptorTest.
	 * @param arg0
	 */
	public FakeEJBActionInterceptorTest(String arg0) {
		super(arg0);
	}

    /* ̂ȂRXgN^͕K{I */
	public FakeEJBActionInterceptorTest() {
		super();
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(FakeEJBActionInterceptorTest.class);
	}

	/**
	 * ݒ肵f[^ZbgĂ邩
	 */
	public void testCreateActionForm() {
		WebConversation webConversation = new WebConversation();
		WebResponse webResponse = null;
		WebRequest webRequest =
			new GetMethodWebRequest("http://localhost:8080/tstruts-cactus/testFakeEJBAction.do");

		webRequest.setParameter(
			MyGlobals.TESTCASE_CLASS_NAME,
			getClass().getName());

		webRequest.setParameter(
			MyGlobals.TESTCASE_METHOD_NAME,
			"setdataCreateActionForm");

		try {
			webResponse = webConversation.getResponse(webRequest);
			WebForm forms[] = webResponse.getForms();
			String a;
			a =
				webResponse.getFormWithName(
					"ResultFormBean").getParameterValue(
					"a");
			assertEquals("1", a);

			String b;
			b =
				webResponse.getFormWithName(
					"ResultFormBean").getParameterValue(
					"b");
			assertEquals("2", b);
			String sum;
			sum =
				webResponse.getFormWithName(
					"ResultFormBean").getParameterValue(
					"sum");
			assertEquals("3", sum);

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}

	}
    
	public InvocationContext setdataCreateActionForm(InvocationContext context) {
		DynaActionForm form = (DynaActionForm) context.getActionForm();
		form.set("a", "1");
		form.set("b", "2");
		form.set("sum", "3");
		
		context.setActionForm(form);
		return context;
	}

}
