/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.auth;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.cactus.FilterTestCase;
import org.apache.cactus.WebRequest;
import jp.ossc.tstruts.MyGlobals;
import jp.ossc.tstruts.common.DynaUserProfile;
import jp.ossc.tstruts.config.UserProfileConfig;
import jp.ossc.tstruts.config.UserProfilePropertyConfig;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class DefaultInitializerTest extends FilterTestCase {

	String className;
	String initializerClassName;
	UserProfilePropertyConfig properties[];

	protected void setUp() throws Exception {
		className = "jp.ossc.tstruts.common.DynaUserProfile";
		initializerClassName = "jp.ossc.tstruts.auth.DefaultInitializer";
		properties = null;
	}

	/**
	 * ev~eBu^̏l
	 * @throws Exception
	 */
	public void testPropertyDefault() throws Exception {
		setUp();
		properties = new UserProfilePropertyConfig[] {
			new UserProfilePropertyConfig("test1", "String", 0),
			new UserProfilePropertyConfig("test2", "boolean", 0),
			new UserProfilePropertyConfig("test3", "byte", 0),
			new UserProfilePropertyConfig("test4", "char", 0),
			new UserProfilePropertyConfig("test5", "double", 0),
			new UserProfilePropertyConfig("test6", "float", 0),
			new UserProfilePropertyConfig("test7", "int", 0),
			new UserProfilePropertyConfig("test8", "long", 0),
			new UserProfilePropertyConfig("test9", "short", 0)
		};
		DynaUserProfile profile = createUserProfile();

		assertNull(profile.get("test1"));
		assertEquals(new Boolean(false),	profile.get("test2"));
		assertEquals(new Byte((byte)0),		profile.get("test3"));
		assertEquals(new Character((char)0), profile.get("test4"));
		assertEquals(new Double(0D),		profile.get("test5"));
		assertEquals(new Float(0F),			profile.get("test6"));
		assertEquals(new Integer(0),		profile.get("test7"));
		assertEquals(new Long(0),			profile.get("test8"));
		assertEquals(new Short((short)0),	profile.get("test9"));
	}

	/**
	 * z^̍ڂ쐬邱ƂmFB
	 * @throws Exception
	 */
	public void testIndexedProperty() throws Exception {
		doFilter(config, request, response);

		DynaUserProfile profile = (DynaUserProfile)request.getAttribute(MyGlobals.USER_PROFILE_KEY);
		assertNotNull(profile.get("array1"));
		assertEquals(String[].class, profile.get("array1").getClass());
		String array1[] = (String[])profile.get("array1");
		assertEquals(2, array1.length);
		int array2[] = (int[])profile.get("array2");
		assertEquals(2, array2.length);
	}

	/**
	 * z^̍ڂ̃ftHglݒ肳邱ƂmFB
	 * @throws Exception
	 */
	public void testIndexedPropertyDefault() throws Exception {
		doFilter(config, request, response);
		DynaUserProfile profile = (DynaUserProfile)request.getAttribute(MyGlobals.USER_PROFILE_KEY);

		String array1[] = (String[])profile.get("array1");
		assertEquals("a", array1[0]);
		assertEquals("b", array1[1]);
		assertEquals("a", profile.get("array1", 0));
		assertEquals("b", profile.get("array1", 1));
		int array2[] = (int[])profile.get("array2");
		assertEquals(9, array2[0]);
		assertEquals(0, array2[1]);
		assertEquals(new Integer(9), profile.get("array2", 0));
		assertEquals(new Integer(0), profile.get("array2", 1));
	}

	/**
	 * [Uvt@C&lt;property&gt;vfdefaultɂftHglݒ肪ݒ肳邩ۂB
	 * @throws Exception
	 */
	public void testDefault() throws Exception {
		setUp();
		properties = new UserProfilePropertyConfig[] {
			new UserProfilePropertyConfig("test1", "String", 0, "test string"),
			new UserProfilePropertyConfig("test2", "boolean", 0, "true"),
			new UserProfilePropertyConfig("test3", "byte", 0, "7"),
			new UserProfilePropertyConfig("test4", "char", 0, "c"),
			new UserProfilePropertyConfig("test5", "double", 0, "0.156"),
			new UserProfilePropertyConfig("test6", "float", 0, "0.793"),
			new UserProfilePropertyConfig("test7", "int", 0, "10"),
			new UserProfilePropertyConfig("test8", "long", 0, "1000"),
			new UserProfilePropertyConfig("test9", "short", 0, "987")
		};
		DynaUserProfile profile = createUserProfile();
		assertEquals("test string",			profile.get("test1"));
		assertEquals(new Boolean(true),		profile.get("test2"));
		assertEquals(new Byte((byte)7),		profile.get("test3"));
		assertEquals(new Character('c'),	profile.get("test4"));
		assertEquals(new Double(0.156D),	profile.get("test5"));
		assertEquals(new Float(0.793F),		profile.get("test6"));
		assertEquals(new Integer(10),		profile.get("test7"));
		assertEquals(new Long(1000),		profile.get("test8"));
		assertEquals(new Short((short)987),	profile.get("test9"));
	}

	public void beginDefaultFromResourceJa(WebRequest request) {
		request.addHeader("Accept-Language", "ja");
	}

	/**
	 * {̃uEŨNGXgɁAJa\[XŃ[Uvt@C邩B
	 * @throws Exception
	 */
	public void testDefaultFromResourceJa() throws Exception {
		doFilter(config, request, response);

		DynaUserProfile profile = (DynaUserProfile)request.getAttribute(MyGlobals.USER_PROFILE_KEY);
		assertEquals("QXg", profile.get("nickname"));
	}

	public void beginDefaultFromResourceEn(WebRequest request) {
		request.addHeader("Accept-Language", "en");
	}

	/**
	 * p̃uEŨNGXgɁAEn\[XŃ[Uvt@C邩B
	 * @throws Exception
	 */
	public void testDefaultFromResourceEn() throws Exception {
		doFilter(config, request, response);

		DynaUserProfile profile = (DynaUserProfile)request.getAttribute(MyGlobals.USER_PROFILE_KEY);
		assertEquals("guest", profile.get("nickname"));
	}

	/**
	 * tB^[gpAUserProfileConfigNX쐬Bȉ̃oϐgAsB
	 * <dl>
	 *   <dt>className</dt>
	 *   <dd>vt@C̃NX</dd>
	 *   <dt>initializerClassName</dt>
	 *   <dd>CjVCŨNX</dd>
	 *   <dt>properties</dt>
	 *   <dd>UserProfilePropertyConfig̔z</dd>
	 * </dl>
	 * @return
	 * @throws Exception
	 */
	private UserProfileConfig createUserProfileConfig() throws Exception {
		UserProfileConfig config = new UserProfileConfig(className, initializerClassName);
		if (properties != null) {
			for (int i = 0; i < properties.length; ++i) {
				config.addProperty(properties[i]);
			}
		}
		return config;
	}
	
	/**
	 * tB^[gpAUserProfileNX쐬Bȉ̃oϐgAsB
	 * <dl>
	 *   <dt>className</dt>
	 *   <dd>vt@C̃NX</dd>
	 *   <dt>initializerClassName</dt>
	 *   <dd>CjVCŨNX</dd>
	 *   <dt>properties</dt>
	 *   <dd>UserProfilePropertyConfig̔z</dd>
	 * </dl>
	 * @return
	 * @throws Exception
	 */
	private DynaUserProfile createUserProfile() throws Exception {
		UserProfileConfig config = createUserProfileConfig();
		return (DynaUserProfile)config.createDefaultUserProfile(request);
	}

	/**
	 * tB^[sB
	 * @throws ServletException
	 * @throws IOException
	 */
	protected static void doFilter(FilterConfig config,
		ServletRequest request,
		ServletResponse response) throws ServletException, IOException {
		UserProfileFilter filter = new UserProfileFilter();
		filter.init(config);
		
		FilterChain mockFilterChain = new FilterChain() {
			public void doFilter(ServletRequest request, ServletResponse response)
			throws IOException, ServletException {
			}
			
			public void init(FilterConfig config) {
			}
			
			public void destory() {
			}
		};
		
		filter.doFilter(request, response, mockFilterChain);
	}

}
