/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.cache;

import jp.ossc.nimbus.core.ServiceManagerFactory;

import org.apache.cactus.ServletTestCase;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class TestActionCacheByCactus extends ServletTestCase {

	//RXgN^

	WebConversation webConversation = new com.meterware.httpunit.WebConversation();

	public TestActionCacheByCactus(String name) {
		super(name);
	}

	/**
	 * DynaActionFormBeanɂȂp[^w肳ꂽƂ̃eXgB<br>
	 * 
	 * Cache-Key𐶐A폈<br>
	 * Cache-KeyƂĉw肳ĂȂ̂ŁALbVƂCacheEntrygÂB<br>
	 * 
	 *   <action
     *       path="/noSuchParameter"
     *       type="AddAction3"
     *       name="AddFormBean"
     *       input="/cacheadd.jsp"
     *       scope="request"
     *       cache="global">
     *       
	 *            <cache-key parameter="noSuchParameter" />
     *       <forward name="success" path="addcheck.jsp" />
     *       <forward name="failure" path="/cacheadd.jsp" />
     *   </action>
	 */

	public void testNoSuchParameter() {
		try {
			WebRequest webRequest = new GetMethodWebRequest(
					"http://localhost:8080/tstruts-cactus/cache/noSuchParameter.do");
			webRequest.setParameter("a", "3");
			webRequest.setParameter("b", "4");
			WebResponse webResponse = webConversation.getResponse(webRequest);
			
			webRequest.setParameter("a", "5");
			webRequest.setParameter("b", "6");
			webResponse = webConversation.getResponse(webRequest);

			ActionCache cache = (ActionCache)ServiceManagerFactory.getServiceObject("tstruts", "GlobalCacheHolderService");

			CacheKey key = cache.createNewKey("/cache/noSuchParameter");
			key.addKey("noSuchParameter", null);	
			CacheEntryImpl entry = (CacheEntryImpl)cache.get(key);
			assertNotNull(entry);
			
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * beanNamêݎw肳ꂽƂ̃eXgB<br>
	 * 
	 * Cache-KeyƂbeanNamew肵ꍇACache2ł̂ŁA<br>
	 * CacheT[rXԂB<br>
	 * 
	 *   <action
	 *       path="/onlyBeanName"
	 *       type="AddAction3"
	 *       name="AddFormBean"
	 *       input="/cacheadd.jsp"
	 *       scope="request"
	 *       cache="global">
	 *       
	 *       <cache-key beanName="AddFormBean"/>
	 *       <forward name="success" path="addcheck.jsp" />
	 *       <forward name="failure" path="/cacheadd.jsp" />
	 *   </action>
	 */

//	public void testOnlyBeanName() {
//		try {
//			WebRequest webRequest = new GetMethodWebRequest(
//					"http://localhost:8080/tstruts-cactus/cache/onlyBeanName.do");
//			webRequest.setParameter("a", "3");
//			webRequest.setParameter("b", "4");
//			WebResponse webResponse = webConversation.getResponse(webRequest);
//			
//			webRequest.setParameter("a", "5");
//			webRequest.setParameter("b", "6");
//			webResponse = webConversation.getResponse(webRequest);
//
//			ActionCache cache = (ActionCache)ServiceManagerFactory.getServiceObject("tstruts", "GlobalCacheHolderService");
//
//			CacheKey key = new CacheKey("/cache/onlyBeanName");
//			
//			CacheEntry entry = (CacheEntry)cache.get(key);
//			assertNotNull(entry);
//
//		} catch (Exception e) {
//			e.printStackTrace();
//			fail();
//		}
//	}


}
