/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.taglib.html;

import org.apache.commons.lang.StringUtils;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import junit.framework.TestCase;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class TestSelectForward extends TestCase {

	public TestSelectForward(String name) {
		super(name);

	}


	public void testSelectForward() {
		String url = "http://localhost:8080/tstruts-cactus/testSelectForward.do";
		WebRequest webRequest = new GetMethodWebRequest(url);
		webRequest.setParameter("a", "5");
		webRequest.setParameter("b", "5");

		try {
			WebConversation webConversation = new WebConversation();
			WebResponse webResponse = webConversation.getResponse(webRequest);
			/*
			 * 
			<action
				path="/testSelectForward"
				type="AddAction"
				name="sampleBean">

				<select-forward property="sum">
					<forward-value value="10" name="success" />
					<forward-value value="20" name="over" />
					<forward-default name="other" />
				</select-forward>

				<forward name="success" path="/LoginError.jsp" />				
				<forward name="failure" path="/testcheck.jsp" />				
				<forward name="other" path="/result.jsp" /> 
			</action>
			*/
			assertTrue(StringUtils.contains(webResponse.getText(), "OCs"));

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}

	}

	public void testSelectGlobalForward() {
		String url = "http://localhost:8080/tstruts-cactus/testSelectForward.do";
		WebRequest webRequest = new GetMethodWebRequest(url);

		webRequest.setParameter("a", "15");
		webRequest.setParameter("b", "5");

		try {
			WebConversation webConversation = new WebConversation();
			WebResponse webResponse = webConversation.getResponse(webRequest);

			// a + b = 20  over
			// <global-forwards>
			//    <forward name="over" path="/addcheck.jsp" />
			// I
			assertTrue(StringUtils.contains(webResponse.getForms()[0].getAction(), "/add2.do"));

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	public void testSelectDefaultForward() {
		String url = "http://localhost:8080/tstruts-cactus/testSelectForward.do";
		WebRequest webRequest = new GetMethodWebRequest(url);

		webRequest.setParameter("a", "12");
		webRequest.setParameter("b", "5");

		try {
			WebConversation webConversation = new WebConversation();
			WebResponse webResponse = webConversation.getResponse(webRequest);

			// a + b ̒l other
			/*
			 * 
			<action
				path="/testSelectForward"
				type="AddAction"
				name="sampleBean">

				<select-forward property="sum">
					<forward-value value="10" name="success" />
					<forward-value value="20" name="over" />
					<forward-default name="other" />
				</select-forward>

				<forward name="success" path="/LoginError.jsp" />				
				<forward name="failure" path="/testcheck.jsp" />				
				<forward name="other" path="/result.jsp" /> 
			</action>
			*/
			assertEquals(0, webResponse.getForms().length);

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}
}
