/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.taglib.html;

import org.apache.commons.lang.StringUtils;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;


import junit.framework.TestCase;

/**
  * Submit摜̃eXg<p>
		ytestHtmlImageTag.jspz
        <html:image
        	property="submit.top"
        	src="img/top.gif"
        	onclick="this.form.submit()"/>
        <html:image
        	property="submit.back"
        	src="img/back.gif"
        	onclick="this.form.submit()"/>
        <html:image
        	property="submit.next"
        	src="img/next.gif"
        	onclick="this.form.submit()"/>
        <input type="submit" name="submit" value="<bean:message key="button.submit"/>">

		ystruts-config-test-SelectForward.xmlz
       <action
            path="/testHtmlImageTag"
            name="sampleBean">

			<select-forward property="submit">
				<forward-value value="top" name="success" />
				<forward-value value="back" name="failure" />
				<forward-value value="button.submit" name="message" />
				<forward-value value="next" name="other" />
			</select-forward>

			<forward name="success" path="/testcheck.jsp" />				
			<forward name="failure" path="/LoginError.jsp" />				
			<forward name="message" path="/testcheck.jsp" />				
			<forward name="other" path="/Login.jsp" /> 
        </action>
  * 
  * @version $Revision: 1.1 $
  * @author H.Matsuno
  * @since 1.0
  */
public class TestValueMessageResource extends TestCase {
	

	/**
	 * Constructor for TestHtmlImageTag.
	 * @param arg0
	 */
	public TestValueMessageResource(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(TestValueMessageResource.class);
	}

	/** 
	 * Submit摜select-forwardeXg<p>
	 * eXgځF
	 * Esubmit{^valuebZ[WvpeBŎw肳ꂽƂɁA
	 * @K؂ɉʑJڂ邱
	 * @@- button.submit -> Login.jsp
	 */
	public void testHtmlSubmitTagJa() {
		String url = "http://localhost:8080/tstruts-cactus/startTest.do";
		WebRequest webRequest = new GetMethodWebRequest(url);
		webRequest.setHeaderField("accept-language", "ja");

		try {
			WebConversation webConversation = new WebConversation();
			WebResponse webResponse = webConversation.getResponse(webRequest);

			WebForm form[] = webResponse.getForms();
			
			SubmitButton button = form[0].getSubmitButton("submit");
			
			webConversation = new WebConversation();
			webRequest = form[0].getRequest(button.getName(), button.getValue());
			webRequest.setHeaderField("accept-language", "ja");
			webResponse = webConversation.getResponse(webRequest);
			
			assertTrue(StringUtils.contains(webResponse.getForms()[0].getAction(), "j_security_check"));
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
		
	}

	/** 
	 * Submit摜select-forwardeXg<p>
	 * eXgځF
	 * Esubmit{^valuep̃bZ[WvpeBŎw肳ꂽƂɁA
	 * @K؂ɉʑJڂ邱
	 * @@- button.submit -> Login.jsp
	 */
	public void testHtmlSubmitTagEn() {
		WebConversation webConversation = new WebConversation();
		String url = "http://localhost:8080/tstruts-cactus/startTest.do";
		WebRequest webRequest = new GetMethodWebRequest(url);
		webRequest.setHeaderField("accept-language", "en");

		try {
			WebResponse webResponse = webConversation.getResponse(webRequest);

			
			WebForm form[] = webResponse.getForms();
			SubmitButton button = form[0].getSubmitButton("submit");
			webRequest = form[0].getRequest(button);
			webRequest.setHeaderField("accept-language", "en");
			webResponse = webConversation.getResponse(webRequest);

			assertTrue(StringUtils.contains(webResponse.getForms()[0].getAction(), "j_security_check"));
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}

	}
}
