/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.common;

import jp.ossc.tstruts.config.UserProfileConfigTest;
import jp.ossc.tstruts.config.UserProfilePropertyConfig;

import junit.framework.TestCase;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class DynaUserProfileTest extends TestCase {

	/**
	 * Constructor for DynaUserProfileTest.
	 * @param arg0
	 */
	public DynaUserProfileTest(String arg0) {
		super(arg0);
	}

	String className;
	String initializerClassName;
	UserProfilePropertyConfig properties[];

	protected void setUp() throws Exception {
		className = "jp.ossc.tstruts.common.DynaUserProfile";
		initializerClassName = "jp.ossc.tstruts.auth.DefaultInitializer";
		properties = new UserProfilePropertyConfig[0];
	}

	public void testValueHolders() throws Exception {
		setUp();
		properties = new UserProfilePropertyConfig[] {
			new UserProfilePropertyConfig("test1", "String", 0),
		};
		DynaUserProfile profile = createUserProfile();
		DynaUserProfile.ValueHolder values[] = profile.getValueHolders();
		assertNotNull(values);
	}

	/**
	 * UserProfileConfigNX쐬Bȉ̃oϐgAsB
	 * <dl>
	 *   <dt>className</dt>
	 *   <dd>vt@C̃NX</dd>
	 *   <dt>initializerClassName</dt>
	 *   <dd>CjVCŨNX</dd>
	 *   <dt>properties</dt>
	 *   <dd>UserProfilePropertyConfig̔z</dd>
	 * </dl>
	 * @return
	 * @throws Exception
	 */
	private DynaUserProfile createUserProfile() throws Exception {
		return (DynaUserProfile)UserProfileConfigTest.createUserProfile(
			className, initializerClassName, properties);
	}
}
