/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.InputStream;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

import jp.ossc.tstruts.ExtendActionServlet;
import junit.framework.TestCase;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class ExtendFormBeanConfigTest extends TestCase {

	/**
	 * Constructor for ExtendFormBeanConfigTest.
	 * @param arg0
	 */
	public ExtendFormBeanConfigTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ExtendFormBeanConfigTest.class);
	}

	public void testAddFormImportConfig() throws Exception{
		ClassLoader cl = getClass().getClassLoader();
		Digester d = DigesterLoader.createDigester(
			cl.getResource(ExtendActionServlet.DEFAULT_DIGESTER_RULE_PATH));
		
		ModuleConfig config = new ModuleConfigImpl("");
		d.push(config);

		
		/*
		 * ExtendFormBeanConfigaddFormImportConfig()\bh
		 * 삷邩ǂeXg
		 * 
		 * yTvݒt@Cz
		 * <?xml version="1.0" encoding="ISO-8859-1"?>
		 * 
		 * <struts-config>
		 * 
		 *   <form-beans>
 		 *    <form-bean name="UserIdBean"
 		 *               type="org.apache.struts.action.DynaActionForm">
 		 *      <form-property name="user" type="java.lang.String" 
		 *                      transfer="true" encrypt="true" />
		 *       <form-property name="id" type="java.lang.String" />
		 *     </form-bean>
		 *   
		 *     <form-bean name="ShoppingBean"
		 *                type="org.apache.struts.action.DynaAcitonForm"
		 *                className="jp.ossc.tstruts.config.ExtendFormBeanConfig">
		 *       <form-property name="code" type="java.lang.String"
		 *                      className="jp.ossc.tstruts.config.ExtendFormPropertyConfig"
		 *                      transfer="true" />
		 *       <form-property name="total_cost" type="java.lang.String" />
		 * 
		 *       <form-import name="UserIdBean" transfer="true" encrypt="true" />
		 *     </form-bean>
		 *   </form-beans>
		 * 
		 * </struts-config>
		 */
		 
		// XMLt@CǂݍŃIuWFNgɕϊ
		InputStream in = this.getClass().getResourceAsStream("/jp/ossc/tstruts/config/test-ExtendFormBeanConfig.xml");
		try{
			d.parse(in);
		} catch (Exception e){
			; // Do Nothing
		}
		
		// ShoppingBean̎qvf<form-property>4邩
		assertEquals(4, 
				config.findFormBeanConfig("ShoppingBean").findFormPropertyConfigs().length);
	}

}
