/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.InputStream;

import org.apache.commons.digester.Digester;

import junit.framework.TestCase;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author H.Matsuno
 * @since 1.0
 */
public class ExtendFormPropertyConfigTest extends TestCase {

	/**
	 * Constructor for ExtendFormPropertyConfigTest.
	 * @param arg0
	 */
	public ExtendFormPropertyConfigTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ExtendFormPropertyConfigTest.class);
	}
	
	public void testDigester() throws Exception{
		Digester d = new Digester();

		/*
		 * ExtendFormPropertyConfigDigesterp^𐳂
		 * Zbg邩eXg
		 */
		// d.addObjectCreate("struts-config/form-beans/form-bean/form-import", FormImportConfig.class);
		// d.addSetProperties("struts-config/form-beans/form-bean/form-import");
		d.addObjectCreate("struts-config/form-beans/form-bean/form-property", ExtendFormPropertyConfig.class);
		d.addSetProperties("struts-config/form-beans/form-bean/form-property");

		// XMLt@CǂݍŃIuWFNgɕϊ
//		InputStream in = new FileInputStream("src/test/org/tstruts/config/test-ExtendFormPropertyConfig.xml");
		InputStream in = this.getClass().getResourceAsStream("/jp/ossc/tstruts/config/test-ExtendFormPropertyConfig.xml");
		ExtendFormPropertyConfig obj = (ExtendFormPropertyConfig)d.parse(in);

		// ExtendFormProperyConfig̃p^`FbN
		assertEquals("userid", obj.getName());
		assertEquals("String", obj.getType());
		assertTrue(obj.getTransfer());
		assertTrue(obj.getEncrypt());
		
	}
	

}
