/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2003 The T-Struts Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE T-STRUTS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE T-STRUTS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the T-Struts Project.
 */
package jp.ossc.tstruts.config;

import java.io.InputStream;
import java.util.List;

import jp.ossc.tstruts.ExtendActionServlet;
import jp.ossc.tstruts.action.ExtendActionMapping;
import junit.framework.TestCase;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;

/**
 * 
 * @version $Name: release-1_1-1_0 $
 * @author N.Kurosawa
 * @since 1.0
 */
public class TilesDefinitionsConfigTest extends TestCase {

	public TilesDefinitionsConfigTest(String arg0) {
		super(arg0);
	}

	/**
	 * eTiles֘A^OɂăIuWFNg邱ƂmF
	 * @throws Exception
	 */
	public void testDefinitions() throws Exception {
		ClassLoader cl = getClass().getClassLoader();
		Digester d = DigesterLoader.createDigester(
			cl.getResource(ExtendActionServlet.DEFAULT_DIGESTER_RULE_PATH));

		RootModuleConfigImpl config = new RootModuleConfigImpl("");
		d.push(config);

		//		eXgf[^F
		//		<?xml version="1.0" encoding="ISO-8859-1"?>
		//		<struts-config>
		//			<form-beans />
		//			<global-exceptions />
		//			<global-forwards />
		//	
		//			<action-mappings>
		//				<action path="/Index"
		//						forward="def1"
		//						cache="global">				
		//					<cache-key beanName="BeanForm" property="username"/>
		//					<cache-key parameter="REQUEST_PARAMETER"/>
		//				</action>
		//			</action-mappings>
		//	
		//			<tiles-definitions>
		//				<definition name="def1" path="def1.jsp">
		//					<put name="title" type="resource" value="top.title"/>
		//					<put name="menu" type="action" value="/Menu.do" />
		//					<putList name="body">
		//						<put type="resource" value="body.top" />
		//						<put type="resource" value="body.second" />
		//						<put type="path" value="/jsp/search.jsp" />
		//					</putList>
		//					<putMap name="ad">
		//						<put name="adHeader" type="resource" value="ad.Header" />
		//						<put name="adHtml" type="path" value="/jsp/ad.jsp" />
		//						<put name="adFooter" type="resource" value="ad.Footer" />
		//					</putMap>
		//				</definition>
		//			</tiles-definitions>
		//
		//			<controller
		//				processorClass="jp.ossc.tstruts.ExtendRequestProcessor"
		//				forwardPattern="/WEB-INF/jsp$M$P"/>
		//		</struts-config>

		InputStream in =
			this.getClass().getResourceAsStream(
				"/jp/ossc/tstruts/config/test-TilesDefinitionsConfig.xml");
		d.parse(in);

		ExtendActionMapping action =
			(ExtendActionMapping) config.findActionConfig("/Index");
		assertNotNull(action);
		assertEquals("global", action.getCache());
		CacheKeyConfig cache[] = action.getCacheKeyConfigs();
		assertEquals("BeanForm", cache[0].getBeanName());
		assertEquals("username", cache[0].getProperty());
		assertEquals("REQUEST_PARAMETER", cache[1].getParameter());

		TilesDefinitionsConfig tiles = config.getTilesDefinitionsConfig();
		assertNotNull(tiles);
		TileDefinitionConfig tile = tiles.getDefinitions()[0];
		assertNotNull(tile);

		TilePutConfigBase base1 = tile.get("title");
		assertNotNull(base1);
		assertEquals("top.title", base1.getValue());
		assertEquals("title", base1.getName());

		TilePutConfigBase base2 = tile.get("menu");
		assertNotNull(base2);
		assertEquals("/Menu.do", base2.getValue());
		TilePropertyConfig properties[] = base2.getPropertyConfigs();
		for (int i = 0; i < properties.length; i++) {
			if (properties[i].getName().equalsIgnoreCase("NAME1")) {
				assertEquals("parameter", properties[i].getParameter());
			}
			if (properties[i].getName().equalsIgnoreCase("NAME2")) {
				assertEquals("bean", properties[i].getBeanName());
				assertEquals("property", properties[i].getProperty());
			}
			if (properties[i].getName().equalsIgnoreCase("NAME3")) {
				assertEquals("value", properties[i].getValue());
			}

		}

		TilePutConfigBase base3 = tile.get("body");
		assertNotNull(base3);
		List list = ((TilePutListConfig) base3).getList();
		assertEquals(3, list.size());
		assertEquals(
			"body.top",
			((TilePutConfigBase) list.remove(0)).getValue());
		assertEquals(
			"body.second",
			((TilePutConfigBase) list.remove(0)).getValue());
		assertEquals(
			"/jsp/search.jsp",
			((TilePutConfigBase) list.remove(0)).getValue());

		TilePutConfigBase base4 = tile.get("ad");
		assertNotNull(base4);
		TilePutListConfig base4ListConfig = (TilePutListConfig) base4;
		assertEquals(3, base4ListConfig.size());
		assertEquals("ad.Header", base4ListConfig.get("adHeader").getValue());
		assertEquals("/jsp/ad.jsp", base4ListConfig.get("adHtml").getValue());
		assertEquals("ad.Footer", base4ListConfig.get("adFooter").getValue());
	}

	/**
	 * TileExtendł邩ǂ̃eXg<br>
	 * 
	 * @throws Exception
	 */
	public void testExtendDefinitions() throws Exception {
		ClassLoader cl = getClass().getClassLoader();
		Digester d = DigesterLoader.createDigester(
			cl.getResource(ExtendActionServlet.DEFAULT_DIGESTER_RULE_PATH));

		RootModuleConfigImpl config = new RootModuleConfigImpl("");
		d.push(config);

		//		eXgf[^F
		//		<definition name="def2" path="def1.jsp" extend="def1">
		//			<put name="title" type="resource" value="top.extend.title"/>
		//		</definition>

		InputStream in =
			this.getClass().getResourceAsStream(
				"/jp/ossc/tstruts/config/test-TilesDefinitionsConfig.xml");
		d.parse(in);

		ExtendActionMapping action =
			(ExtendActionMapping) config.findActionConfig("/Index");
		assertNotNull(action);
		assertEquals("global", action.getCache());
		CacheKeyConfig cache[] = action.getCacheKeyConfigs();
		assertEquals("BeanForm", cache[0].getBeanName());
		assertEquals("username", cache[0].getProperty());
		assertEquals("REQUEST_PARAMETER", cache[1].getParameter());

		TilesDefinitionsConfig tiles = config.getTilesDefinitionsConfig();
		assertNotNull(tiles);
		tiles.freeze();
		tiles.processTilesExtentions();
		TileDefinitionConfig tile = tiles.findTileConfig("def2");
		assertNotNull(tile);

		TilePutConfigBase base1 = tile.get("title");
		assertNotNull(base1);
		assertEquals("top.extend.title", base1.getValue());
		assertEquals("title", base1.getName());

		TilePutConfigBase base2 = tile.get("menu");
		assertNotNull(base2);
		assertEquals("/Menu.do", base2.getValue());
		TilePropertyConfig properties[] = base2.getPropertyConfigs();
		for (int i = 0; i < properties.length; i++) {
			if (properties[i].getName().equalsIgnoreCase("NAME1")) {
				assertEquals("parameter", properties[i].getParameter());
			}
			if (properties[i].getName().equalsIgnoreCase("NAME2")) {
				assertEquals("bean", properties[i].getBeanName());
				assertEquals("property", properties[i].getProperty());
			}
			if (properties[i].getName().equalsIgnoreCase("NAME3")) {
				assertEquals("value", properties[i].getValue());
			}

		}

		TilePutConfigBase base3 = tile.get("body");
		assertNotNull(base3);
		List list = ((TilePutListConfig) base3).getList();
		assertEquals(3, list.size());
		assertEquals(
			"body.top",
			((TilePutConfigBase) list.remove(0)).getValue());
		assertEquals(
			"body.second",
			((TilePutConfigBase) list.remove(0)).getValue());
		assertEquals(
			"/jsp/search.jsp",
			((TilePutConfigBase) list.remove(0)).getValue());

		TilePutConfigBase base4 = tile.get("ad");
		assertNotNull(base4);
		TilePutListConfig base4ListConfig = (TilePutListConfig) base4;
		assertEquals(3, base4ListConfig.size());
		assertEquals("ad.Header", base4ListConfig.get("adHeader").getValue());
		assertEquals("/jsp/ad.jsp", base4ListConfig.get("adHtml").getValue());
		assertEquals("ad.Footer", base4ListConfig.get("adFooter").getValue());
	}

}
