/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import java.math.BigInteger;
import org.eclipse.core.databinding.conversion.Converter;

public class NumberToStringConverter
extends Converter {
    private final NumberFormat numberFormat;
    private final Class fromType;
    private boolean fromTypeIsLong;
    private boolean fromTypeIsDecimalType;
    private boolean fromTypeIsBigInteger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NumberToStringConverter(NumberFormat numberFormat, Class fromType) {
        block29: {
            block28: {
                block27: {
                    block26: {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        super(fromType, clazz);
                        this.numberFormat = numberFormat;
                        this.fromType = fromType;
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("java.lang.Integer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz2.equals(fromType) || Integer.TYPE.equals(fromType)) break block26;
                        Class<?> clazz3 = class$2;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$2 = Class.forName("java.lang.Long");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!clazz3.equals(fromType) && !Long.TYPE.equals(fromType)) break block27;
                    }
                    this.fromTypeIsLong = true;
                    return;
                }
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(fromType) || Float.TYPE.equals(fromType)) break block28;
                Class<?> clazz4 = class$4;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$4 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz4.equals(fromType) && !Double.TYPE.equals(fromType)) break block29;
            }
            this.fromTypeIsDecimalType = true;
            return;
        }
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(fromType)) return;
        this.fromTypeIsBigInteger = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object fromObject) {
        if (fromObject == null && !this.fromType.isPrimitive()) {
            return "";
        }
        Number number = (Number)fromObject;
        String result = null;
        if (this.fromTypeIsLong) {
            NumberFormat numberFormat = this.numberFormat;
            synchronized (numberFormat) {
                result = this.numberFormat.format(number.longValue());
            }
        }
        if (this.fromTypeIsDecimalType) {
            NumberFormat numberFormat = this.numberFormat;
            synchronized (numberFormat) {
                result = this.numberFormat.format(number.doubleValue());
            }
        }
        if (this.fromTypeIsBigInteger) {
            NumberFormat numberFormat = this.numberFormat;
            synchronized (numberFormat) {
                result = this.numberFormat.format((BigInteger)number);
            }
        }
        return result;
    }

    public static NumberToStringConverter fromDouble(boolean primitive) {
        return NumberToStringConverter.fromDouble(NumberFormat.getNumberInstance(), primitive);
    }

    public static NumberToStringConverter fromDouble(NumberFormat numberFormat, boolean primitive) {
        Class<?> clazz;
        if (primitive) {
            clazz = Double.TYPE;
        } else {
            clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        return new NumberToStringConverter(numberFormat, clazz);
    }

    public static NumberToStringConverter fromLong(boolean primitive) {
        return NumberToStringConverter.fromLong(NumberFormat.getIntegerInstance(), primitive);
    }

    public static NumberToStringConverter fromLong(NumberFormat numberFormat, boolean primitive) {
        Class<?> clazz;
        if (primitive) {
            clazz = Long.TYPE;
        } else {
            clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        return new NumberToStringConverter(numberFormat, clazz);
    }

    public static NumberToStringConverter fromFloat(boolean primitive) {
        return NumberToStringConverter.fromFloat(NumberFormat.getNumberInstance(), primitive);
    }

    public static NumberToStringConverter fromFloat(NumberFormat numberFormat, boolean primitive) {
        Class<?> clazz;
        if (primitive) {
            clazz = Float.TYPE;
        } else {
            clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        return new NumberToStringConverter(numberFormat, clazz);
    }

    public static NumberToStringConverter fromInteger(boolean primitive) {
        return NumberToStringConverter.fromInteger(NumberFormat.getIntegerInstance(), primitive);
    }

    public static NumberToStringConverter fromInteger(NumberFormat numberFormat, boolean primitive) {
        Class<?> clazz;
        if (primitive) {
            clazz = Integer.TYPE;
        } else {
            clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        return new NumberToStringConverter(numberFormat, clazz);
    }

    public static NumberToStringConverter fromBigInteger() {
        return NumberToStringConverter.fromBigInteger(NumberFormat.getIntegerInstance());
    }

    public static NumberToStringConverter fromBigInteger(NumberFormat numberFormat) {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new NumberToStringConverter(numberFormat, clazz);
    }
}

