/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.tree;

import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.internal.databinding.observable.tree.IChildrenCountUpdate;
import org.eclipse.core.internal.databinding.observable.tree.IChildrenUpdate;
import org.eclipse.core.internal.databinding.observable.tree.IHasChildrenUpdate;
import org.eclipse.core.internal.databinding.observable.tree.IObservableTree;
import org.eclipse.core.internal.databinding.observable.tree.ITreeChangeListener;
import org.eclipse.core.internal.databinding.observable.tree.TreeChangeEvent;
import org.eclipse.core.internal.databinding.observable.tree.TreeDiff;
import org.eclipse.core.internal.databinding.observable.tree.TreePath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;

public abstract class AbstractObservableTree
extends AbstractObservable
implements IObservableTree {
    private boolean stale;
    private ListenerList treeListeners = new ListenerList(1);

    public AbstractObservableTree(Realm realm) {
        super(realm);
    }

    public void addChild(TreePath parentPath, Object childElement) {
        throw new UnsupportedOperationException();
    }

    public void addTreeChangeListener(ITreeChangeListener listener) {
        this.treeListeners.add((Object)listener);
    }

    public int getChildCount(TreePath parentPath) {
        return this.getChildren(parentPath).length;
    }

    public boolean hasChildren(TreePath parentPath) {
        return this.getChildCount(parentPath) > 0;
    }

    public void insertChild(TreePath parentPath, int index, Object childElement) {
        throw new UnsupportedOperationException();
    }

    public boolean isLazy() {
        return false;
    }

    public boolean isOrdered() {
        return false;
    }

    public void removeChild(TreePath parentPath, Object childElement) {
        throw new UnsupportedOperationException();
    }

    public void removeChild(TreePath parentPath, int index) {
        throw new UnsupportedOperationException();
    }

    public void removeTreeChangeListener(ITreeChangeListener listener) {
        this.treeListeners.remove((Object)listener);
    }

    public void setChildCount(TreePath parentPath, int count) {
        throw new UnsupportedOperationException();
    }

    public void setChildren(TreePath parentPath, Object[] children) {
        throw new UnsupportedOperationException();
    }

    public void updateChildren(IChildrenUpdate update) {
        TreePath parent = update.getParent();
        Object[] children = this.getChildren(parent);
        int i = 0;
        while (i < update.getLength()) {
            int targetIndex = update.getOffset() + i;
            if (targetIndex < children.length) {
                update.setChild(children[targetIndex], targetIndex);
            } else {
                update.setStatus((IStatus)new Status(2, "org.eclipse.core.databinding", 0, BindingMessages.getString("IndexOutOfRange"), null));
            }
            ++i;
        }
        update.done();
    }

    public void updateChildrenCount(IChildrenCountUpdate update) {
        TreePath[] parents = update.getParents();
        int i = 0;
        while (i < parents.length) {
            update.setChildCount(parents[i], this.getChildCount(parents[i]));
            ++i;
        }
        update.done();
    }

    public void updateHasChildren(IHasChildrenUpdate update) {
        TreePath[] parents = update.getElements();
        int i = 0;
        while (i < parents.length) {
            update.setHasChilren(parents[i], this.hasChildren(parents[i]));
            ++i;
        }
        update.done();
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setStale(boolean stale) {
        this.stale = stale;
        if (stale) {
            this.fireStale();
        }
    }

    protected void fireTreeChange(TreeDiff diff) {
        this.fireChange();
        Object[] listeners = this.treeListeners.getListeners();
        TreeChangeEvent event = new TreeChangeEvent(this, diff);
        int i = 0;
        while (i < listeners.length) {
            ((ITreeChangeListener)listeners[i]).handleTreeChange(event);
            ++i;
        }
    }
}

